/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RetryPolicy;
import com.microsoft.windowsazure.services.core.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.services.core.storage.RetryResult;

public final class RetryLinearRetry
extends RetryPolicy
implements RetryPolicyFactory {
    public RetryLinearRetry() {
        this(30000, 3);
    }

    public RetryLinearRetry(int deltaBackoff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
    }

    @Override
    public RetryPolicy createInstance(OperationContext opContext) {
        return new RetryLinearRetry(this.deltaBackoffIntervalInMs, this.maximumAttempts);
    }

    @Override
    public RetryResult shouldRetry(int currentRetryCount, int statusCode, Exception lastException, OperationContext opContext) {
        if (statusCode >= 400 && statusCode < 500 || statusCode == 501 || statusCode == 505) {
            return new RetryResult(0, false);
        }
        int backoff = Math.max(Math.min(this.deltaBackoffIntervalInMs, 90000), 3000);
        return new RetryResult(backoff, currentRetryCount < this.maximumAttempts);
    }
}

