/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RetryPolicy;
import com.microsoft.windowsazure.services.core.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.services.core.storage.RetryResult;
import java.util.Random;

public final class RetryExponentialRetry
extends RetryPolicy
implements RetryPolicyFactory {
    private final Random randRef = new Random();
    private int resolvedMaxBackoff = 90000;
    private int resolvedMinBackoff = 3000;

    public RetryExponentialRetry() {
        this(30000, 3);
    }

    public RetryExponentialRetry(int deltaBackoff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
    }

    public RetryExponentialRetry(int minBackoff, int deltaBackoff, int maxBackOff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
        this.resolvedMinBackoff = minBackoff;
        this.resolvedMaxBackoff = maxBackOff;
    }

    @Override
    public RetryPolicy createInstance(OperationContext opContext) {
        return new RetryExponentialRetry(this.resolvedMinBackoff, this.deltaBackoffIntervalInMs, this.resolvedMaxBackoff, this.maximumAttempts);
    }

    @Override
    public RetryResult shouldRetry(int currentRetryCount, int statusCode, Exception lastException, OperationContext opContext) {
        if (statusCode >= 400 && statusCode < 500 || statusCode == 501 || statusCode == 505) {
            return new RetryResult(-1, false);
        }
        if (currentRetryCount < this.maximumAttempts) {
            double incrementDelta = Math.pow(2.0, currentRetryCount) - 1.0;
            int boundedRandDelta = (int)((double)this.deltaBackoffIntervalInMs * 0.8) + this.randRef.nextInt((int)((double)this.deltaBackoffIntervalInMs * 1.2) - (int)((double)this.deltaBackoffIntervalInMs * 0.8));
            return new RetryResult((int)Math.round(Math.min((double)this.resolvedMinBackoff + (incrementDelta *= (double)boundedRandDelta), (double)this.resolvedMaxBackoff)), true);
        }
        return new RetryResult(-1, false);
    }
}

