/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import java.util.ArrayList;

public class ResultSegment<T> {
    private final ResultContinuation continuationToken;
    private final int length;
    private final int pageSize;
    private final ArrayList<T> results;

    public ResultSegment(ArrayList<T> results, int pageSize, ResultContinuation token) {
        this.results = results;
        this.length = results.size();
        this.pageSize = pageSize;
        this.continuationToken = token;
    }

    public ResultContinuation getContinuationToken() {
        return this.continuationToken;
    }

    public boolean getHasMoreResults() {
        return this.continuationToken != null;
    }

    public boolean getIsPageComplete() {
        return this.length == this.pageSize;
    }

    public int getLength() {
        return this.length;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRemainingPageResults() {
        return this.pageSize - this.length;
    }

    public ArrayList<T> getResults() {
        return this.results;
    }
}

