/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.RequestResult;
import com.microsoft.windowsazure.services.core.storage.ResponseReceivedEvent;
import com.microsoft.windowsazure.services.core.storage.SendingRequestEvent;
import com.microsoft.windowsazure.services.core.storage.StorageEvent;
import com.microsoft.windowsazure.services.core.storage.StorageEventMultiCaster;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;

public final class OperationContext {
    private long clientTimeInMs;
    private String clientRequestID;
    private Logger logger;
    private final ArrayList<RequestResult> requestResults;
    private StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> sendingRequestEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> responseReceivedEventHandler = new StorageEventMultiCaster();
    private MessageDigest intermediateMD5;
    private HttpURLConnection currentRequestObject;
    protected Object operationState;
    private volatile long currentOperationByteCount;

    public OperationContext() {
        this.clientRequestID = UUID.randomUUID().toString();
        this.requestResults = new ArrayList();
    }

    public String getClientRequestID() {
        return this.clientRequestID;
    }

    public long getClientTimeInMs() {
        return this.clientTimeInMs;
    }

    public long getCurrentOperationByteCount() {
        return this.currentOperationByteCount;
    }

    public HttpURLConnection getCurrentRequestObject() {
        return this.currentRequestObject;
    }

    public MessageDigest getIntermediateMD5() {
        return this.intermediateMD5;
    }

    public synchronized RequestResult getLastResult() {
        if (this.requestResults == null || this.requestResults.size() == 0) {
            return null;
        }
        return this.requestResults.get(this.requestResults.size() - 1);
    }

    private Logger getLogger() {
        return this.logger;
    }

    public ArrayList<RequestResult> getRequestResults() {
        return this.requestResults;
    }

    public synchronized void appendRequestResult(RequestResult requestResult) {
        this.requestResults.add(requestResult);
    }

    public StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> getSendingRequestEventHandler() {
        return this.sendingRequestEventHandler;
    }

    public StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> getResponseReceivedEventHandler() {
        return this.responseReceivedEventHandler;
    }

    public void initialize() {
        this.setClientTimeInMs(0L);
        this.requestResults.clear();
        this.setIntermediateMD5(null);
        this.operationState = null;
        this.setCurrentRequestObject(null);
    }

    public void setClientRequestID(String clientRequestID) {
        this.clientRequestID = clientRequestID;
    }

    public void setClientTimeInMs(long clientTimeInMs) {
        this.clientTimeInMs = clientTimeInMs;
    }

    public void setCurrentOperationByteCount(long currentOperationByteCount) {
        this.currentOperationByteCount = currentOperationByteCount;
    }

    public void setCurrentRequestObject(HttpURLConnection currentRequestObject) {
        this.currentRequestObject = currentRequestObject;
    }

    public void setIntermediateMD5(MessageDigest intermediateMD5) {
        this.intermediateMD5 = intermediateMD5;
    }

    private void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setSendingRequestEventHandler(StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> sendingRequestEventHandler) {
        this.sendingRequestEventHandler = sendingRequestEventHandler;
    }

    public void setResponseReceivedEventHandler(StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> responseReceivedEventHandler) {
        this.responseReceivedEventHandler = responseReceivedEventHandler;
    }
}

