/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class UserAgentFilter
extends ClientFilter {
    private static String azureSDKProductToken;

    public UserAgentFilter() {
        if (azureSDKProductToken == null || azureSDKProductToken.isEmpty()) {
            azureSDKProductToken = this.createAzureSDKProductToken();
        }
    }

    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        String userAgent;
        if (clientRequest.getHeaders().containsKey((Object)"User-Agent")) {
            String currentUserAgent = (String)clientRequest.getHeaders().getFirst((Object)"User-Agent");
            userAgent = azureSDKProductToken + " " + currentUserAgent;
            clientRequest.getHeaders().remove((Object)"User-Agent");
        } else {
            userAgent = azureSDKProductToken;
        }
        clientRequest.getHeaders().add((Object)"User-Agent", (Object)userAgent);
        return this.getNext().handle(clientRequest);
    }

    private String createAzureSDKProductToken() {
        String version = this.getVersionFromResources();
        String productToken = version != null && !version.isEmpty() ? "Azure-SDK-For-Java/" + version : "Azure-SDK-For-Java";
        return productToken;
    }

    private String getVersionFromResources() {
        String version = "unknown";
        Properties properties = new Properties();
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/maven/com.microsoft.windowsazure/microsoft-windowsazure-api/pom.properties");
            if (inputStream != null) {
                properties.load(inputStream);
                version = properties.getProperty("version");
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }
}

