/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core;

import com.microsoft.windowsazure.services.core.Builder;
import com.microsoft.windowsazure.services.core.ConfigurationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.inject.Named;

public class DefaultBuilder
implements Builder,
Builder.Registry {
    Map<Class<?>, Builder.Factory<?>> factories = new HashMap();
    Map<Class<?>, Map<Class<?>, List<Builder.Alteration<?>>>> alterations = new HashMap();

    public static DefaultBuilder create() {
        DefaultBuilder builder = new DefaultBuilder();
        for (Builder.Exports exports : ServiceLoader.load(Builder.Exports.class)) {
            exports.register(builder);
        }
        return builder;
    }

    void addFactory(Class<?> service, Builder.Factory<?> factory) {
        this.factories.put(service, factory);
    }

    @Override
    public <T> Builder.Registry add(Class<T> service) {
        return this.add(service, service);
    }

    Constructor<?> findInjectConstructor(Class<?> implementation) {
        Constructor<?> withInject = null;
        Constructor<?> withoutInject = null;
        int count = 0;
        for (Constructor<?> ctor : implementation.getConstructors()) {
            if (ctor.getAnnotation(Inject.class) != null) {
                if (withInject != null) {
                    throw new RuntimeException("Class must not have multple @Inject annotations: " + implementation.getName());
                }
                withInject = ctor;
                continue;
            }
            ++count;
            withoutInject = ctor;
        }
        if (withInject != null) {
            return withInject;
        }
        if (count != 1) {
            throw new RuntimeException("Class without @Inject annotation must have one constructor: " + implementation.getName());
        }
        return withoutInject;
    }

    @Override
    public <T, TImpl> Builder.Registry add(Class<T> service, Class<TImpl> implementation) {
        final Constructor<?> ctor = this.findInjectConstructor(implementation);
        final Class[] parameterTypes = ctor.getParameterTypes();
        final Annotation[][] parameterAnnotations = ctor.getParameterAnnotations();
        this.addFactory(service, new Builder.Factory<T>(){

            @Override
            public <S> T create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                Object[] initializationArguments = new Object[parameterTypes.length];
                for (int i = 0; i != parameterTypes.length; ++i) {
                    boolean located = false;
                    String named = DefaultBuilder.this.findNamedAnnotation(parameterAnnotations[i]);
                    String fullName = DefaultBuilder.this.dotCombine(profile, named);
                    boolean probeProperties = fullName != null && fullName != "";
                    int startingIndex = 0;
                    while (!located && probeProperties) {
                        String nameProbe = fullName.substring(startingIndex);
                        if (!located && named != null && properties.containsKey(nameProbe)) {
                            located = true;
                            initializationArguments[i] = properties.get(nameProbe);
                            continue;
                        }
                        if ((startingIndex = fullName.indexOf(46, startingIndex) + 1) != 0) continue;
                        probeProperties = false;
                    }
                    if (located) continue;
                    located = true;
                    initializationArguments[i] = builder.build(fullName, service, parameterTypes[i], properties);
                }
                try {
                    return ctor.newInstance(initializationArguments);
                }
                catch (InstantiationException e) {
                    throw new ConfigurationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationException(e);
                }
            }
        });
        return this;
    }

    protected String dotCombine(String profile, String named) {
        boolean noName;
        boolean noProfile = profile == null || profile == "";
        boolean bl = noName = named == null || named == "";
        if (noName) {
            return profile;
        }
        if (noProfile) {
            return named;
        }
        return profile + "." + named;
    }

    protected String findNamedAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!Named.class.isAssignableFrom(annotation.getClass())) continue;
            return ((Named)annotation).value();
        }
        return null;
    }

    @Override
    public <T> Builder.Registry add(Builder.Factory<T> factory) {
        for (Type genericInterface : factory.getClass().getGenericInterfaces()) {
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            if (!parameterizedType.getRawType().equals(Builder.Factory.class)) continue;
            Type typeArgument = parameterizedType.getActualTypeArguments()[0];
            this.addFactory((Class)typeArgument, factory);
        }
        return this;
    }

    @Override
    public <S, T> T build(String profile, Class<S> service, Class<T> instanceClass, Map<String, Object> properties) {
        List<Builder.Alteration<?>> alterationList;
        Builder.Factory<?> factory = this.factories.get(instanceClass);
        if (factory == null) {
            throw new RuntimeException("Service or property not registered: " + profile + " " + service.getName());
        }
        Object instance = factory.create(profile, service, this, properties);
        Map<Class<?>, List<Builder.Alteration<?>>> alterationMap = this.alterations.get(service);
        if (alterationMap != null && (alterationList = alterationMap.get(instanceClass)) != null) {
            for (Builder.Alteration<?> alteration : alterationList) {
                instance = alteration.alter(profile, instance, this, properties);
            }
        }
        return (T)instance;
    }

    @Override
    public <S, T> void alter(Class<S> service, Class<T> instance, Builder.Alteration<T> alteration) {
        if (!this.alterations.containsKey(service)) {
            this.alterations.put(service, new HashMap());
        }
        if (!this.alterations.get(service).containsKey(instance)) {
            this.alterations.get(service).put(instance, new ArrayList());
        }
        this.alterations.get(service).get(instance).add(alteration);
    }
}

