/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.models;

import com.microsoft.windowsazure.services.blob.models.AccessConditionHeaderType;
import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import java.util.Date;

public final class AccessCondition {
    public static final AccessCondition NONE = new AccessCondition(AccessConditionHeaderType.NONE, null);
    private AccessConditionHeaderType header = AccessConditionHeaderType.NONE;
    private String value;

    public static AccessCondition ifMatch(String etag) {
        return new AccessCondition(AccessConditionHeaderType.IF_MATCH, etag);
    }

    public static AccessCondition ifModifiedSince(Date lastMotified) {
        return new AccessCondition(AccessConditionHeaderType.IF_MODIFIED_SINCE, new RFC1123DateConverter().format(lastMotified));
    }

    public static AccessCondition ifNoneMatch(String etag) {
        return new AccessCondition(AccessConditionHeaderType.IF_NONE_MATCH, etag);
    }

    public static AccessCondition ifNotModifiedSince(Date lastMotified) {
        return new AccessCondition(AccessConditionHeaderType.IF_UNMODIFIED_SINCE, new RFC1123DateConverter().format(lastMotified));
    }

    protected AccessCondition() {
    }

    protected AccessCondition(AccessConditionHeaderType headerType, String value) {
        this.setHeader(headerType);
        this.setValue(value);
    }

    public AccessConditionHeaderType getHeader() {
        return this.header;
    }

    public void setHeader(AccessConditionHeaderType header) {
        this.header = header;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

