/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.sun.jersey.api.client.ClientRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SharedKeyUtils {
    public static final String AUTHORIZATION_FILTER_MARKER = SharedKeyUtils.class.getName();

    public static String getCanonicalizedHeaders(ClientRequest cr) {
        ArrayList<String> msHeaders = new ArrayList<String>();
        for (String key : cr.getHeaders().keySet()) {
            if (!key.toLowerCase(Locale.US).startsWith("x-ms-")) continue;
            msHeaders.add(key.toLowerCase(Locale.US));
        }
        Collections.sort(msHeaders);
        String result = "";
        for (String msHeader : msHeaders) {
            result = result + msHeader + ":" + cr.getHeaders().getFirst((Object)msHeader) + "\n";
        }
        return result;
    }

    public static String getHeader(ClientRequest cr, String headerKey) {
        List values = (List)cr.getHeaders().get((Object)headerKey);
        if (values == null || values.size() != 1) {
            return SharedKeyUtils.nullEmpty(null);
        }
        return SharedKeyUtils.nullEmpty(values.get(0).toString());
    }

    private static String nullEmpty(String value) {
        return value != null ? value : "";
    }

    public static List<QueryParam> getQueryParams(String queryString) {
        ArrayList<QueryParam> result = new ArrayList<QueryParam>();
        if (queryString != null) {
            String[] params;
            for (String param : params = queryString.split("&")) {
                result.add(SharedKeyUtils.getQueryParam(param));
            }
        }
        return result;
    }

    private static QueryParam getQueryParam(String param) {
        QueryParam result = new QueryParam();
        int index = param.indexOf("=");
        if (index < 0) {
            result.setName(param);
        } else {
            result.setName(param.substring(0, index));
            String value = param.substring(index + 1);
            int commaIndex = value.indexOf(44);
            if (commaIndex < 0) {
                result.addValue(value);
            } else {
                for (String v : value.split(",")) {
                    result.addValue(v);
                }
            }
        }
        return result;
    }

    public static class QueryParam
    implements Comparable<QueryParam> {
        private String name;
        private final List<String> values = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void addValue(String value) {
            this.values.add(value);
        }

        @Override
        public int compareTo(QueryParam o) {
            return this.name.compareTo(o.name);
        }
    }
}

