/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.models.AccessCondition;
import com.microsoft.windowsazure.services.blob.models.AcquireLeaseOptions;
import com.microsoft.windowsazure.services.blob.models.AcquireLeaseResult;
import com.microsoft.windowsazure.services.blob.models.BlobProperties;
import com.microsoft.windowsazure.services.blob.models.BlobServiceOptions;
import com.microsoft.windowsazure.services.blob.models.BlockList;
import com.microsoft.windowsazure.services.blob.models.BreakLeaseResult;
import com.microsoft.windowsazure.services.blob.models.CommitBlobBlocksOptions;
import com.microsoft.windowsazure.services.blob.models.ContainerACL;
import com.microsoft.windowsazure.services.blob.models.CopyBlobOptions;
import com.microsoft.windowsazure.services.blob.models.CopyBlobResult;
import com.microsoft.windowsazure.services.blob.models.CreateBlobBlockOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobPagesOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobPagesResult;
import com.microsoft.windowsazure.services.blob.models.CreateBlobResult;
import com.microsoft.windowsazure.services.blob.models.CreateBlobSnapshotOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobSnapshotResult;
import com.microsoft.windowsazure.services.blob.models.CreateContainerOptions;
import com.microsoft.windowsazure.services.blob.models.DeleteBlobOptions;
import com.microsoft.windowsazure.services.blob.models.DeleteContainerOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobMetadataOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobMetadataResult;
import com.microsoft.windowsazure.services.blob.models.GetBlobOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobPropertiesOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobPropertiesResult;
import com.microsoft.windowsazure.services.blob.models.GetBlobResult;
import com.microsoft.windowsazure.services.blob.models.GetContainerACLResult;
import com.microsoft.windowsazure.services.blob.models.GetContainerPropertiesResult;
import com.microsoft.windowsazure.services.blob.models.GetServicePropertiesResult;
import com.microsoft.windowsazure.services.blob.models.ListBlobBlocksOptions;
import com.microsoft.windowsazure.services.blob.models.ListBlobBlocksResult;
import com.microsoft.windowsazure.services.blob.models.ListBlobRegionsOptions;
import com.microsoft.windowsazure.services.blob.models.ListBlobRegionsResult;
import com.microsoft.windowsazure.services.blob.models.ListBlobsOptions;
import com.microsoft.windowsazure.services.blob.models.ListBlobsResult;
import com.microsoft.windowsazure.services.blob.models.ListContainersOptions;
import com.microsoft.windowsazure.services.blob.models.ListContainersResult;
import com.microsoft.windowsazure.services.blob.models.PageRange;
import com.microsoft.windowsazure.services.blob.models.ServiceProperties;
import com.microsoft.windowsazure.services.blob.models.SetBlobMetadataOptions;
import com.microsoft.windowsazure.services.blob.models.SetBlobMetadataResult;
import com.microsoft.windowsazure.services.blob.models.SetBlobPropertiesOptions;
import com.microsoft.windowsazure.services.blob.models.SetBlobPropertiesResult;
import com.microsoft.windowsazure.services.blob.models.SetContainerMetadataOptions;
import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.utils.CommaStringBuilder;
import com.microsoft.windowsazure.services.core.utils.pipeline.ClientFilterAdapter;
import com.microsoft.windowsazure.services.core.utils.pipeline.PipelineHelpers;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.Base64;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public abstract class BlobOperationRestProxy
implements BlobContract {
    private static final String API_VERSION = "2011-08-18";
    private final Client channel;
    private final String accountName;
    private final String url;
    private final RFC1123DateConverter dateMapper;
    private final ServiceFilter[] filters;

    protected BlobOperationRestProxy(Client channel, String accountName, String url) {
        this(channel, new ServiceFilter[0], accountName, url, new RFC1123DateConverter());
    }

    protected BlobOperationRestProxy(Client channel, ServiceFilter[] filters, String accountName, String url, RFC1123DateConverter dateMapper) {
        this.channel = channel;
        this.accountName = accountName;
        this.url = url;
        this.filters = filters;
        this.dateMapper = dateMapper;
    }

    @Override
    public abstract BlobContract withFilter(ServiceFilter var1);

    protected Client getChannel() {
        return this.channel;
    }

    protected String getAccountName() {
        return this.accountName;
    }

    protected String getUrl() {
        return this.url;
    }

    protected RFC1123DateConverter getDateMapper() {
        return this.dateMapper;
    }

    protected ServiceFilter[] getFilters() {
        return this.filters;
    }

    private void ThrowIfError(ClientResponse r) {
        PipelineHelpers.ThrowIfError(r);
    }

    private void ThrowIfNotSuccess(ClientResponse clientResponse) {
        PipelineHelpers.ThrowIfNotSuccess(clientResponse);
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, Object value) {
        return PipelineHelpers.addOptionalQueryParam(webResource, key, value);
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, int value, int defaultValue) {
        return PipelineHelpers.addOptionalQueryParam(webResource, key, value, defaultValue);
    }

    private WebResource.Builder addOptionalHeader(WebResource.Builder builder, String name, Object value) {
        return PipelineHelpers.addOptionalHeader(builder, name, value);
    }

    private WebResource.Builder addOptionalMetadataHeader(WebResource.Builder builder, Map<String, String> metadata) {
        return PipelineHelpers.addOptionalMetadataHeader(builder, metadata);
    }

    private WebResource.Builder addOptionalRangeHeader(WebResource.Builder builder, Long rangeStart, Long rangeEnd) {
        return PipelineHelpers.addOptionalRangeHeader(builder, rangeStart, rangeEnd);
    }

    private WebResource.Builder addOptionalAccessConditionHeader(WebResource.Builder builder, AccessCondition accessCondition) {
        return PipelineHelpers.addOptionalAccessConditionHeader(builder, accessCondition);
    }

    private WebResource.Builder addOptionalSourceAccessConditionHeader(WebResource.Builder builder, AccessCondition accessCondition) {
        return PipelineHelpers.addOptionalSourceAccessConditionHeader(builder, accessCondition);
    }

    private HashMap<String, String> getMetadataFromHeaders(ClientResponse response) {
        return PipelineHelpers.getMetadataFromHeaders(response);
    }

    private WebResource addOptionalBlobListingIncludeQueryParam(ListBlobsOptions options, WebResource webResource) {
        CommaStringBuilder sb = new CommaStringBuilder();
        sb.addValue(options.isIncludeSnapshots(), "snapshots");
        sb.addValue(options.isIncludeUncommittedBlobs(), "uncommittedblobs");
        sb.addValue(options.isIncludeMetadata(), "metadata");
        webResource = this.addOptionalQueryParam(webResource, "include", sb.toString());
        return webResource;
    }

    private WebResource addOptionalContainerIncludeQueryParam(ListContainersOptions options, WebResource webResource) {
        CommaStringBuilder sb = new CommaStringBuilder();
        sb.addValue(options.isIncludeMetadata(), "metadata");
        webResource = this.addOptionalQueryParam(webResource, "include", sb.toString());
        return webResource;
    }

    private WebResource.Builder addPutBlobHeaders(CreateBlobOptions options, WebResource.Builder builder) {
        builder = this.addOptionalHeader(builder, "Content-Type", options.getContentType());
        if (options.getContentType() == null) {
            builder = (WebResource.Builder)builder.type("application/octet-stream");
        }
        builder = this.addOptionalHeader(builder, "Content-Encoding", options.getContentEncoding());
        builder = this.addOptionalHeader(builder, "Content-Language", options.getContentLanguage());
        builder = this.addOptionalHeader(builder, "Content-MD5", options.getContentMD5());
        builder = this.addOptionalHeader(builder, "Cache-Control", options.getCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-type", options.getBlobContentType());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-encoding", options.getBlobContentEncoding());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-language", options.getBlobContentLanguage());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-md5", options.getBlobContentMD5());
        builder = this.addOptionalHeader(builder, "x-ms-blob-cache-control", options.getBlobCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        return builder;
    }

    private GetBlobPropertiesResult getBlobPropertiesResultFromResponse(ClientResponse response) {
        BlobProperties properties = new BlobProperties();
        properties.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        properties.setBlobType((String)response.getHeaders().getFirst((Object)"x-ms-blob-type"));
        properties.setLeaseStatus((String)response.getHeaders().getFirst((Object)"x-ms-lease-status"));
        properties.setContentLength(Long.parseLong((String)response.getHeaders().getFirst((Object)"Content-Length")));
        properties.setContentType((String)response.getHeaders().getFirst((Object)"Content-Type"));
        properties.setContentMD5((String)response.getHeaders().getFirst((Object)"Content-MD5"));
        properties.setContentEncoding((String)response.getHeaders().getFirst((Object)"Content-Encoding"));
        properties.setContentLanguage((String)response.getHeaders().getFirst((Object)"Content-Language"));
        properties.setCacheControl((String)response.getHeaders().getFirst((Object)"Cache-Control"));
        properties.setEtag((String)response.getHeaders().getFirst((Object)"Etag"));
        if (response.getHeaders().containsKey((Object)"x-ms-blob-sequence-number")) {
            properties.setSequenceNumber(Long.parseLong((String)response.getHeaders().getFirst((Object)"x-ms-blob-sequence-number")));
        }
        HashMap<String, String> metadata = this.getMetadataFromHeaders(response);
        GetBlobPropertiesResult result = new GetBlobPropertiesResult();
        result.setMetadata(metadata);
        result.setProperties(properties);
        return result;
    }

    private WebResource getResource(BlobServiceOptions options) {
        WebResource webResource = this.channel.resource(this.url).path("/");
        webResource = this.addOptionalQueryParam(webResource, "timeout", options.getTimeout());
        for (ServiceFilter filter : this.filters) {
            webResource.addFilter((ClientFilter)new ClientFilterAdapter(filter));
        }
        return webResource;
    }

    private String getCopyBlobSourceName(String sourceContainer, String sourceBlob, CopyBlobOptions options) {
        String sourceName = "/" + this.accountName;
        if (sourceContainer != null) {
            sourceName = sourceName + "/" + sourceContainer;
        }
        sourceName = sourceName + "/" + sourceBlob;
        if (options.getSourceSnapshot() != null) {
            sourceName = sourceName + "?snapshot=" + options.getSourceSnapshot();
        }
        return sourceName;
    }

    @Override
    public GetServicePropertiesResult getServiceProperties() throws ServiceException {
        return this.getServiceProperties(new BlobServiceOptions());
    }

    @Override
    public GetServicePropertiesResult getServiceProperties(BlobServiceOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("resType", "service").queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        GetServicePropertiesResult result = new GetServicePropertiesResult();
        result.setValue((ServiceProperties)builder.get(ServiceProperties.class));
        return result;
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties) throws ServiceException {
        this.setServiceProperties(serviceProperties, new BlobServiceOptions());
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties, BlobServiceOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("resType", "service").queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder.put((Object)serviceProperties);
    }

    @Override
    public void createContainer(String container) throws ServiceException {
        this.createContainer(container, new CreateContainerOptions());
    }

    @Override
    public void createContainer(String container, CreateContainerOptions options) throws ServiceException {
        if (container == null || container.isEmpty()) {
            throw new IllegalArgumentException("The container cannot be null or empty.");
        }
        WebResource webResource = this.getResource(options).path(container).queryParam("resType", "container");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalHeader(builder, "x-ms-blob-public-access", options.getPublicAccess());
        builder.put();
    }

    @Override
    public void deleteContainer(String container) throws ServiceException {
        this.deleteContainer(container, new DeleteContainerOptions());
    }

    @Override
    public void deleteContainer(String container, DeleteContainerOptions options) throws ServiceException {
        if (container == null || container.isEmpty()) {
            throw new IllegalArgumentException("The root container has already been created.");
        }
        WebResource webResource = this.getResource(options).path(container).queryParam("resType", "container");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.delete();
    }

    @Override
    public GetContainerPropertiesResult getContainerProperties(String container) throws ServiceException {
        return this.getContainerProperties(container, new BlobServiceOptions());
    }

    @Override
    public GetContainerPropertiesResult getContainerProperties(String container, BlobServiceOptions options) throws ServiceException {
        return this.getContainerPropertiesImpl(container, options, null);
    }

    @Override
    public GetContainerPropertiesResult getContainerMetadata(String container) throws ServiceException {
        return this.getContainerMetadata(container, new BlobServiceOptions());
    }

    @Override
    public GetContainerPropertiesResult getContainerMetadata(String container, BlobServiceOptions options) throws ServiceException {
        return this.getContainerPropertiesImpl(container, options, "metadata");
    }

    private GetContainerPropertiesResult getContainerPropertiesImpl(String container, BlobServiceOptions options, String operation) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).queryParam("resType", "container");
        webResource = this.addOptionalQueryParam(webResource, "comp", operation);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        GetContainerPropertiesResult properties = new GetContainerPropertiesResult();
        properties.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        properties.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        properties.setMetadata(this.getMetadataFromHeaders(response));
        return properties;
    }

    @Override
    public GetContainerACLResult getContainerACL(String container) throws ServiceException {
        return this.getContainerACL(container, new BlobServiceOptions());
    }

    @Override
    public GetContainerACLResult getContainerACL(String container, BlobServiceOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).queryParam("resType", "container").queryParam("comp", "acl");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        ContainerACL.SignedIdentifiers si = (ContainerACL.SignedIdentifiers)response.getEntity(ContainerACL.SignedIdentifiers.class);
        ContainerACL acl = new ContainerACL();
        acl.setSignedIdentifiers(si.getSignedIdentifiers());
        if ("container".equals(response.getHeaders().getFirst((Object)"x-ms-blob-public-access"))) {
            acl.setPublicAccess(ContainerACL.PublicAccessType.CONTAINER_AND_BLOBS);
        } else if ("blob".equals(response.getHeaders().getFirst((Object)"x-ms-blob-public-access"))) {
            acl.setPublicAccess(ContainerACL.PublicAccessType.BLOBS_ONLY);
        } else {
            acl.setPublicAccess(ContainerACL.PublicAccessType.NONE);
        }
        acl.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        acl.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        GetContainerACLResult result = new GetContainerACLResult();
        result.setValue(acl);
        return result;
    }

    @Override
    public void setContainerACL(String container, ContainerACL acl) throws ServiceException {
        this.setContainerACL(container, acl, new BlobServiceOptions());
    }

    @Override
    public void setContainerACL(String container, ContainerACL acl, BlobServiceOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).queryParam("resType", "container").queryParam("comp", "acl");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        if (acl.getPublicAccess() == ContainerACL.PublicAccessType.BLOBS_ONLY) {
            builder = this.addOptionalHeader(builder, "x-ms-blob-public-access", "blob");
        } else if (acl.getPublicAccess() == ContainerACL.PublicAccessType.CONTAINER_AND_BLOBS) {
            builder = this.addOptionalHeader(builder, "x-ms-blob-public-access", "container");
        }
        ContainerACL.SignedIdentifiers si = new ContainerACL.SignedIdentifiers();
        si.setSignedIdentifiers(acl.getSignedIdentifiers());
        builder.put((Object)si);
    }

    @Override
    public void setContainerMetadata(String container, HashMap<String, String> metadata) throws ServiceException {
        this.setContainerMetadata(container, metadata, new SetContainerMetadataOptions());
    }

    @Override
    public void setContainerMetadata(String container, HashMap<String, String> metadata, SetContainerMetadataOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).queryParam("resType", "container").queryParam("comp", "metadata");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalMetadataHeader(builder, metadata);
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.put((Object)"");
    }

    @Override
    public ListContainersResult listContainers() throws ServiceException {
        return this.listContainers(new ListContainersOptions());
    }

    @Override
    public ListContainersResult listContainers(ListContainersOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("comp", "list");
        webResource = this.addOptionalQueryParam(webResource, "prefix", options.getPrefix());
        webResource = this.addOptionalQueryParam(webResource, "marker", options.getMarker());
        webResource = this.addOptionalQueryParam(webResource, "maxresults", options.getMaxResults(), 0);
        webResource = this.addOptionalContainerIncludeQueryParam(options, webResource);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        return (ListContainersResult)builder.get(ListContainersResult.class);
    }

    @Override
    public ListBlobsResult listBlobs(String container) throws ServiceException {
        return this.listBlobs(container, new ListBlobsOptions());
    }

    @Override
    public ListBlobsResult listBlobs(String container, ListBlobsOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).queryParam("comp", "list").queryParam("resType", "container");
        webResource = this.addOptionalQueryParam(webResource, "prefix", options.getPrefix());
        webResource = this.addOptionalQueryParam(webResource, "marker", options.getMarker());
        webResource = this.addOptionalQueryParam(webResource, "maxresults", options.getMaxResults(), 0);
        webResource = this.addOptionalQueryParam(webResource, "delimiter", options.getDelimiter());
        webResource = this.addOptionalBlobListingIncludeQueryParam(options, webResource);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        return (ListBlobsResult)builder.get(ListBlobsResult.class);
    }

    @Override
    public CreateBlobResult createPageBlob(String container, String blob, long length) throws ServiceException {
        return this.createPageBlob(container, blob, length, new CreateBlobOptions());
    }

    @Override
    public CreateBlobResult createPageBlob(String container, String blob, long length, CreateBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-blob-type", "PageBlob");
        builder = this.addOptionalHeader(builder, "Content-Length", 0);
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-length", length);
        builder = this.addOptionalHeader(builder, "x-ms-blob-sequence-number", options.getSequenceNumber());
        builder = this.addPutBlobHeaders(options, builder);
        ClientResponse clientResponse = (ClientResponse)builder.put(ClientResponse.class, (Object)"");
        this.ThrowIfError(clientResponse);
        CreateBlobResult createBlobResult = new CreateBlobResult();
        createBlobResult.setEtag((String)clientResponse.getHeaders().getFirst((Object)"ETag"));
        createBlobResult.setLastModified(this.dateMapper.parse((String)clientResponse.getHeaders().getFirst((Object)"Last-Modified")));
        return createBlobResult;
    }

    @Override
    public CreateBlobResult createBlockBlob(String container, String blob, InputStream contentStream) throws ServiceException {
        return this.createBlockBlob(container, blob, contentStream, new CreateBlobOptions());
    }

    @Override
    public CreateBlobResult createBlockBlob(String container, String blob, InputStream contentStream, CreateBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = (WebResource.Builder)builder.header("x-ms-blob-type", (Object)"BlockBlob");
        builder = this.addPutBlobHeaders(options, builder);
        Object contentObject = contentStream == null ? (Object)new byte[0] : contentStream;
        ClientResponse clientResponse = (ClientResponse)builder.put(ClientResponse.class, contentObject);
        this.ThrowIfError(clientResponse);
        CreateBlobResult createBlobResult = new CreateBlobResult();
        createBlobResult.setEtag((String)clientResponse.getHeaders().getFirst((Object)"ETag"));
        createBlobResult.setLastModified(this.dateMapper.parse((String)clientResponse.getHeaders().getFirst((Object)"Last-Modified")));
        return createBlobResult;
    }

    @Override
    public GetBlobPropertiesResult getBlobProperties(String container, String blob) throws ServiceException {
        return this.getBlobProperties(container, blob, new GetBlobPropertiesOptions());
    }

    @Override
    public GetBlobPropertiesResult getBlobProperties(String container, String blob, GetBlobPropertiesOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.method("HEAD", ClientResponse.class);
        this.ThrowIfNotSuccess(response);
        return this.getBlobPropertiesResultFromResponse(response);
    }

    @Override
    public GetBlobMetadataResult getBlobMetadata(String container, String blob) throws ServiceException {
        return this.getBlobMetadata(container, blob, new GetBlobMetadataOptions());
    }

    @Override
    public GetBlobMetadataResult getBlobMetadata(String container, String blob, GetBlobMetadataOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "metadata");
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        GetBlobMetadataResult properties = new GetBlobMetadataResult();
        properties.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        properties.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        properties.setMetadata(this.getMetadataFromHeaders(response));
        return properties;
    }

    @Override
    public SetBlobPropertiesResult setBlobProperties(String container, String blob, SetBlobPropertiesOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-blob-cache-control", options.getCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-type", options.getContentType());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-md5", options.getContentMD5());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-encoding", options.getContentEncoding());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-language", options.getContentLanguage());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-length", options.getContentLength());
        builder = this.addOptionalHeader(builder, "x-ms-sequence-number-action", options.getSequenceNumberAction());
        builder = this.addOptionalHeader(builder, "x-ms-blob-sequence-number", options.getSequenceNumber());
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)"");
        this.ThrowIfError(response);
        SetBlobPropertiesResult result = new SetBlobPropertiesResult();
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        result.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        if (response.getHeaders().getFirst((Object)"x-ms-blob-sequence-number") != null) {
            result.setSequenceNumber(Long.parseLong((String)response.getHeaders().getFirst((Object)"x-ms-blob-sequence-number")));
        }
        return result;
    }

    @Override
    public SetBlobMetadataResult setBlobMetadata(String container, String blob, HashMap<String, String> metadata) throws ServiceException {
        return this.setBlobMetadata(container, blob, metadata, new SetBlobMetadataOptions());
    }

    @Override
    public SetBlobMetadataResult setBlobMetadata(String container, String blob, HashMap<String, String> metadata, SetBlobMetadataOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "metadata");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalMetadataHeader(builder, metadata);
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)"");
        this.ThrowIfError(response);
        SetBlobMetadataResult result = new SetBlobMetadataResult();
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        result.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        return result;
    }

    @Override
    public GetBlobResult getBlob(String container, String blob) throws ServiceException {
        return this.getBlob(container, blob, new GetBlobOptions());
    }

    @Override
    public GetBlobResult getBlob(String container, String blob, GetBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalRangeHeader(builder, options.getRangeStart(), options.getRangeEnd());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        if (options.isComputeRangeMD5()) {
            builder = this.addOptionalHeader(builder, "x-ms-range-get-content-md5", "true");
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfNotSuccess(response);
        GetBlobPropertiesResult properties = this.getBlobPropertiesResultFromResponse(response);
        GetBlobResult blobResult = new GetBlobResult();
        blobResult.setProperties(properties.getProperties());
        blobResult.setMetadata(properties.getMetadata());
        blobResult.setContentStream(response.getEntityInputStream());
        return blobResult;
    }

    @Override
    public void deleteBlob(String container, String blob) throws ServiceException {
        this.deleteBlob(container, blob, new DeleteBlobOptions());
    }

    @Override
    public void deleteBlob(String container, String blob, DeleteBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        if (options.getDeleteSnaphotsOnly() != null) {
            builder = this.addOptionalHeader(builder, "x-ms-delete-snapshots", options.getDeleteSnaphotsOnly() != false ? "only" : "include");
        }
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.delete();
    }

    @Override
    public CreateBlobSnapshotResult createBlobSnapshot(String container, String blob) throws ServiceException {
        return this.createBlobSnapshot(container, blob, new CreateBlobSnapshotOptions());
    }

    @Override
    public CreateBlobSnapshotResult createBlobSnapshot(String container, String blob, CreateBlobSnapshotOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "snapshot");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)"");
        this.ThrowIfError(response);
        CreateBlobSnapshotResult blobSnapshot = new CreateBlobSnapshotResult();
        blobSnapshot.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        blobSnapshot.setSnapshot((String)response.getHeaders().getFirst((Object)"x-ms-snapshot"));
        blobSnapshot.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        return blobSnapshot;
    }

    @Override
    public CopyBlobResult copyBlob(String destinationContainer, String destinationBlob, String sourceContainer, String sourceBlob) throws ServiceException {
        return this.copyBlob(destinationContainer, destinationBlob, sourceContainer, sourceBlob, new CopyBlobOptions());
    }

    @Override
    public CopyBlobResult copyBlob(String destinationContainer, String destinationBlob, String sourceContainer, String sourceBlob, CopyBlobOptions options) {
        String path = this.createPathFromContainer(destinationContainer);
        WebResource webResource = this.getResource(options).path(path).path(destinationBlob);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalHeader(builder, "x-ms-source-lease-id", options.getSourceLeaseId());
        builder = this.addOptionalHeader(builder, "x-ms-copy-source", this.getCopyBlobSourceName(sourceContainer, sourceBlob, options));
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder = this.addOptionalSourceAccessConditionHeader(builder, options.getSourceAccessCondition());
        ClientResponse clientResponse = (ClientResponse)builder.put(ClientResponse.class, (Object)"");
        this.ThrowIfError(clientResponse);
        CopyBlobResult copyBlobResult = new CopyBlobResult();
        copyBlobResult.setEtag((String)clientResponse.getHeaders().getFirst((Object)"ETag"));
        copyBlobResult.setLastModified(this.dateMapper.parse((String)clientResponse.getHeaders().getFirst((Object)"Last-Modified")));
        return copyBlobResult;
    }

    @Override
    public AcquireLeaseResult acquireLease(String container, String blob) throws ServiceException {
        return this.acquireLease(container, blob, new AcquireLeaseOptions());
    }

    @Override
    public AcquireLeaseResult acquireLease(String container, String blob, AcquireLeaseOptions options) throws ServiceException {
        return this.putLeaseImpl("acquire", container, blob, null, options, options.getAccessCondition());
    }

    @Override
    public AcquireLeaseResult renewLease(String container, String blob, String leaseId) throws ServiceException {
        return this.renewLease(container, blob, leaseId, new BlobServiceOptions());
    }

    @Override
    public AcquireLeaseResult renewLease(String container, String blob, String leaseId, BlobServiceOptions options) throws ServiceException {
        return this.putLeaseImpl("renew", container, blob, leaseId, options, null);
    }

    @Override
    public void releaseLease(String container, String blob, String leaseId) throws ServiceException {
        this.releaseLease(container, blob, leaseId, new BlobServiceOptions());
    }

    @Override
    public void releaseLease(String container, String blob, String leaseId, BlobServiceOptions options) throws ServiceException {
        this.putLeaseImpl("release", container, blob, leaseId, options, null);
    }

    @Override
    @Deprecated
    public void breakLease(String container, String blob, String leaseId) throws ServiceException {
        this.breakLease(container, blob);
    }

    @Override
    @Deprecated
    public void breakLease(String container, String blob, String leaseId, BlobServiceOptions options) throws ServiceException {
        this.breakLease(container, blob, options);
    }

    @Override
    public BreakLeaseResult breakLease(String container, String blob) throws ServiceException {
        return this.breakLease(container, blob, new BlobServiceOptions());
    }

    @Override
    public BreakLeaseResult breakLease(String container, String blob, BlobServiceOptions options) throws ServiceException {
        ClientResponse response = this.doLeaseOperation("break", container, blob, null, options, null);
        BreakLeaseResult result = new BreakLeaseResult();
        result.setRemainingLeaseTimeInSeconds(Integer.parseInt((String)response.getHeaders().getFirst((Object)"x-ms-lease-time")));
        return result;
    }

    private AcquireLeaseResult putLeaseImpl(String leaseAction, String container, String blob, String leaseId, BlobServiceOptions options, AccessCondition accessCondition) throws ServiceException {
        ClientResponse response = this.doLeaseOperation(leaseAction, container, blob, leaseId, options, accessCondition);
        AcquireLeaseResult result = new AcquireLeaseResult();
        result.setLeaseId((String)response.getHeaders().getFirst((Object)"x-ms-lease-id"));
        return result;
    }

    private ClientResponse doLeaseOperation(String leaseAction, String container, String blob, String leaseId, BlobServiceOptions options, AccessCondition accessCondition) {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "lease");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        if (leaseId != null) {
            builder = this.addOptionalHeader(builder, "x-ms-lease-id", leaseId);
        }
        builder = this.addOptionalHeader(builder, "x-ms-lease-action", leaseAction);
        builder = this.addOptionalAccessConditionHeader(builder, accessCondition);
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)"");
        this.ThrowIfError(response);
        return response;
    }

    @Override
    public CreateBlobPagesResult clearBlobPages(String container, String blob, PageRange range) throws ServiceException {
        return this.clearBlobPages(container, blob, range, new CreateBlobPagesOptions());
    }

    @Override
    public CreateBlobPagesResult clearBlobPages(String container, String blob, PageRange range, CreateBlobPagesOptions options) throws ServiceException {
        return this.updatePageBlobPagesImpl("clear", container, blob, range, 0L, null, options);
    }

    @Override
    public CreateBlobPagesResult createBlobPages(String container, String blob, PageRange range, long length, InputStream contentStream) throws ServiceException {
        return this.createBlobPages(container, blob, range, length, contentStream, new CreateBlobPagesOptions());
    }

    @Override
    public CreateBlobPagesResult createBlobPages(String container, String blob, PageRange range, long length, InputStream contentStream, CreateBlobPagesOptions options) throws ServiceException {
        return this.updatePageBlobPagesImpl("update", container, blob, range, length, contentStream, options);
    }

    private CreateBlobPagesResult updatePageBlobPagesImpl(String action, String container, String blob, PageRange range, long length, InputStream contentStream, CreateBlobPagesOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "page");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalRangeHeader(builder, range.getStart(), range.getEnd());
        builder = this.addOptionalHeader(builder, "Content-Length", length);
        builder = this.addOptionalHeader(builder, "Content-MD5", options.getContentMD5());
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalHeader(builder, "x-ms-page-write", action);
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        Object contentObject = contentStream == null ? (Object)new byte[0] : contentStream;
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, contentObject);
        this.ThrowIfError(response);
        CreateBlobPagesResult result = new CreateBlobPagesResult();
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        result.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        result.setContentMD5((String)response.getHeaders().getFirst((Object)"Content-MD5"));
        result.setSequenceNumber(Long.parseLong((String)response.getHeaders().getFirst((Object)"x-ms-blob-sequence-number")));
        return result;
    }

    @Override
    public ListBlobRegionsResult listBlobRegions(String container, String blob) throws ServiceException {
        return this.listBlobRegions(container, blob, new ListBlobRegionsOptions());
    }

    @Override
    public ListBlobRegionsResult listBlobRegions(String container, String blob, ListBlobRegionsOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "pagelist");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalRangeHeader(builder, options.getRangeStart(), options.getRangeEnd());
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        ListBlobRegionsResult result = (ListBlobRegionsResult)response.getEntity(ListBlobRegionsResult.class);
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        result.setContentLength(Long.parseLong((String)response.getHeaders().getFirst((Object)"x-ms-blob-content-length")));
        result.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        return result;
    }

    @Override
    public void createBlobBlock(String container, String blob, String blockId, InputStream contentStream) throws ServiceException {
        this.createBlobBlock(container, blob, blockId, contentStream, new CreateBlobBlockOptions());
    }

    @Override
    public void createBlobBlock(String container, String blob, String blockId, InputStream contentStream, CreateBlobBlockOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "block");
        try {
            webResource = this.addOptionalQueryParam(webResource, "blockid", new String(Base64.encode((String)blockId), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalHeader(builder, "Content-MD5", options.getContentMD5());
        builder.put((Object)contentStream);
    }

    @Override
    public void commitBlobBlocks(String container, String blob, BlockList blockList) throws ServiceException {
        this.commitBlobBlocks(container, blob, blockList, new CommitBlobBlocksOptions());
    }

    @Override
    public void commitBlobBlocks(String container, String blob, BlockList blockList, CommitBlobBlocksOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "blocklist");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalHeader(builder, "x-ms-blob-cache-control", options.getBlobCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-type", options.getBlobContentType());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-encoding", options.getBlobContentEncoding());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-language", options.getBlobContentLanguage());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-md5", options.getBlobContentMD5());
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.put((Object)blockList);
    }

    @Override
    public ListBlobBlocksResult listBlobBlocks(String container, String blob) throws ServiceException {
        return this.listBlobBlocks(container, blob, new ListBlobBlocksOptions());
    }

    @Override
    public ListBlobBlocksResult listBlobBlocks(String container, String blob, ListBlobBlocksOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "blocklist");
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        if (options.isCommittedList() && options.isUncommittedList()) {
            webResource = this.addOptionalQueryParam(webResource, "blocklisttype", "all");
        } else if (options.isCommittedList()) {
            webResource = this.addOptionalQueryParam(webResource, "blocklisttype", "committed");
        } else if (options.isUncommittedList()) {
            webResource = this.addOptionalQueryParam(webResource, "blocklisttype", "uncommitted");
        }
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        ListBlobBlocksResult result = (ListBlobBlocksResult)response.getEntity(ListBlobBlocksResult.class);
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        result.setContentType((String)response.getHeaders().getFirst((Object)"Content-Type"));
        String blobContentLength = (String)response.getHeaders().getFirst((Object)"x-ms-blob-content-length");
        if (blobContentLength != null) {
            result.setContentLength(Long.parseLong(blobContentLength));
        } else {
            result.setContentLength(0L);
        }
        String lastModified = (String)response.getHeaders().getFirst((Object)"Last-Modified");
        if (lastModified != null) {
            result.setLastModified(this.dateMapper.parse(lastModified));
        }
        return result;
    }

    private String createPathFromContainer(String containerName) {
        String path = containerName == null || containerName.isEmpty() ? "$root" : containerName;
        return path;
    }
}

