/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.SharedAccessBlobPermissions;
import java.util.Date;
import java.util.EnumSet;

public final class SharedAccessBlobPolicy {
    private EnumSet<SharedAccessBlobPermissions> permissions;
    private Date sharedAccessExpiryTime;
    private Date sharedAccessStartTime;

    public static EnumSet<SharedAccessBlobPermissions> permissionsFromString(String value) {
        char[] chars = value.toCharArray();
        EnumSet<SharedAccessBlobPermissions> retSet = EnumSet.noneOf(SharedAccessBlobPermissions.class);
        block6: for (char c : chars) {
            switch (c) {
                case 'r': {
                    retSet.add(SharedAccessBlobPermissions.READ);
                    continue block6;
                }
                case 'w': {
                    retSet.add(SharedAccessBlobPermissions.WRITE);
                    continue block6;
                }
                case 'd': {
                    retSet.add(SharedAccessBlobPermissions.DELETE);
                    continue block6;
                }
                case 'l': {
                    retSet.add(SharedAccessBlobPermissions.LIST);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("value");
                }
            }
        }
        return retSet;
    }

    public static String permissionsToString(EnumSet<SharedAccessBlobPermissions> permissions) {
        if (permissions == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (permissions.contains((Object)SharedAccessBlobPermissions.READ)) {
            builder.append("r");
        }
        if (permissions.contains((Object)SharedAccessBlobPermissions.WRITE)) {
            builder.append("w");
        }
        if (permissions.contains((Object)SharedAccessBlobPermissions.DELETE)) {
            builder.append("d");
        }
        if (permissions.contains((Object)SharedAccessBlobPermissions.LIST)) {
            builder.append("l");
        }
        return builder.toString();
    }

    public EnumSet<SharedAccessBlobPermissions> getPermissions() {
        return this.permissions;
    }

    public Date getSharedAccessExpiryTime() {
        return this.sharedAccessExpiryTime;
    }

    public Date getSharedAccessStartTime() {
        return this.sharedAccessStartTime;
    }

    public void setPermissions(EnumSet<SharedAccessBlobPermissions> permissions) {
        this.permissions = permissions;
    }

    public void setSharedAccessExpiryTime(Date sharedAccessExpiryTime) {
        this.sharedAccessExpiryTime = sharedAccessExpiryTime;
    }

    public void setSharedAccessStartTime(Date sharedAccessStartTime) {
        this.sharedAccessStartTime = sharedAccessStartTime;
    }
}

