/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobDeserializationHelper;
import com.microsoft.windowsazure.services.blob.client.PageRange;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class GetPageRangesResponse {
    private ArrayList<PageRange> pageRanges = new ArrayList();
    private boolean isParsed;
    private final InputStream streamRef;

    public GetPageRangesResponse(InputStream stream) {
        this.streamRef = stream;
    }

    public ArrayList<PageRange> getPageRanges() throws XMLStreamException, StorageException {
        if (!this.isParsed) {
            this.parseResponse();
        }
        return this.pageRanges;
    }

    public void parseResponse() throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(this.streamRef);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "PageList");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (name.equals("PageRange")) {
                this.pageRanges = BlobDeserializationHelper.readPageRanges(xmlr);
                continue;
            }
            if (name.equals("PageList") && eventType == 2) break;
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        this.isParsed = true;
    }
}

