/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobDeserializationHelper;
import com.microsoft.windowsazure.services.blob.client.BlockEntry;
import com.microsoft.windowsazure.services.blob.client.BlockSearchMode;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class GetBlockListResponse {
    private final ArrayList<BlockEntry> blocks = new ArrayList();
    private boolean isParsed;
    private final InputStream streamRef;

    public GetBlockListResponse(InputStream stream) {
        this.streamRef = stream;
    }

    public ArrayList<BlockEntry> getBlocks() throws XMLStreamException, StorageException {
        if (!this.isParsed) {
            this.parseResponse();
        }
        return this.blocks;
    }

    public void parseResponse() throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(this.streamRef);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "BlockList");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (name.equals("CommittedBlocks")) {
                eventType = xmlr.next();
                if (eventType != 1 || !"Block".equals(xmlr.getName().toString())) continue;
                this.blocks.addAll(BlobDeserializationHelper.readBlobBlocks(xmlr, BlockSearchMode.COMMITTED));
                xmlr.require(2, null, "CommittedBlocks");
                continue;
            }
            if (name.equals("UncommittedBlocks")) {
                eventType = xmlr.next();
                if (eventType != 1 || !"Block".equals(xmlr.getName().toString())) continue;
                this.blocks.addAll(BlobDeserializationHelper.readBlobBlocks(xmlr, BlockSearchMode.UNCOMMITTED));
                xmlr.require(2, null, "UncommittedBlocks");
                continue;
            }
            if (name.equals("BlockList") && eventType == 2) break;
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        this.isParsed = true;
    }
}

