/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobContainerPublicAccessType;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.ContainerListingDetails;
import com.microsoft.windowsazure.services.blob.client.SharedAccessBlobPolicy;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.Credentials;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseRequest;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.LeaseAction;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ListingContext;
import java.io.IOException;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class ContainerRequest {
    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        BaseRequest.addMetadata(request, name, value, opContext);
    }

    public static HttpURLConnection create(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        return BaseRequest.create(uri, timeout, containerBuilder, opContext);
    }

    private static HttpURLConnection createURLConnection(URI uri, int timeout, UriQueryBuilder query, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.createURLConnection(uri, timeout, query, opContext);
    }

    public static HttpURLConnection delete(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        return BaseRequest.delete(uri, timeout, containerBuilder, opContext);
    }

    public static HttpURLConnection getAcl(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    protected static UriQueryBuilder getContainerUriQueryBuilder() throws StorageException {
        UriQueryBuilder uriBuilder = new UriQueryBuilder();
        try {
            uriBuilder.add("restype", "container");
        }
        catch (IllegalArgumentException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        return uriBuilder;
    }

    public static HttpURLConnection getMetadata(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        return BaseRequest.getMetadata(uri, timeout, containerBuilder, opContext);
    }

    public static HttpURLConnection getProperties(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        return BaseRequest.getProperties(uri, timeout, containerBuilder, opContext);
    }

    public static HttpURLConnection list(URI uri, int timeout, ListingContext listingContext, ContainerListingDetails detailsIncluded, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        if (detailsIncluded == ContainerListingDetails.ALL || detailsIncluded == ContainerListingDetails.METADATA) {
            builder.add("include", "metadata");
        }
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, int timeout, BlobContainerPublicAccessType publicAccess, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("PUT");
        request.setDoOutput(true);
        if (publicAccess != BlobContainerPublicAccessType.OFF) {
            request.setRequestProperty("x-ms-blob-public-access", publicAccess.toString().toLowerCase());
        }
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        return BaseRequest.setMetadata(uri, timeout, containerBuilder, opContext);
    }

    public static HttpURLConnection lease(URI uri, int timeout, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "lease");
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("x-ms-lease-action", action.toString());
        if (leaseTimeInSeconds != null) {
            request.setRequestProperty("x-ms-lease-duration", leaseTimeInSeconds.toString());
        } else {
            request.setRequestProperty("x-ms-lease-duration", "-1");
        }
        if (proposedLeaseId != null) {
            request.setRequestProperty("x-ms-proposed-lease-id", proposedLeaseId);
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static void signRequest(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        BaseRequest.signRequestForBlobAndQueue(request, credentials, contentLength, opContext);
    }

    public static void signRequestForSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        BaseRequest.signRequestForBlobAndQueueSharedKeyLite(request, credentials, contentLength, opContext);
    }

    public static void writeSharedAccessIdentifiersToStream(HashMap<String, SharedAccessBlobPolicy> sharedAccessPolicies, StringWriter outWriter) throws XMLStreamException {
        Utility.assertNotNull("sharedAccessPolicies", sharedAccessPolicies);
        Utility.assertNotNull("outWriter", outWriter);
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        if (sharedAccessPolicies.keySet().size() > 5) {
            String errorMessage = String.format("Too many %d shared access policy identifiers provided. Server does not support setting more than %d on a single container.", sharedAccessPolicies.keySet().size(), 5);
            throw new IllegalArgumentException(errorMessage);
        }
        xmlw.writeStartDocument();
        xmlw.writeStartElement("SignedIdentifiers");
        for (Map.Entry<String, SharedAccessBlobPolicy> entry : sharedAccessPolicies.entrySet()) {
            SharedAccessBlobPolicy policy = entry.getValue();
            xmlw.writeStartElement("SignedIdentifier");
            xmlw.writeStartElement("Id");
            xmlw.writeCharacters(entry.getKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("AccessPolicy");
            xmlw.writeStartElement("Start");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Expiry");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Permission");
            xmlw.writeCharacters(SharedAccessBlobPolicy.permissionsToString(policy.getPermissions()));
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    private ContainerRequest() {
    }
}

