/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobOutputStream;
import com.microsoft.windowsazure.services.blob.client.BlobRequest;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.CloudBlob;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.GetPageRangesResponse;
import com.microsoft.windowsazure.services.blob.client.PageOperationType;
import com.microsoft.windowsazure.services.blob.client.PageProperties;
import com.microsoft.windowsazure.services.blob.client.PageRange;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class CloudPageBlob
extends CloudBlob {
    public CloudPageBlob(URI uri) throws StorageException {
        super(BlobType.PAGE_BLOB);
        Utility.assertNotNull("blobAbsoluteUri", uri);
        this.uri = uri;
        this.parseURIQueryStringAndVerify(uri, null, Utility.determinePathStyleFromUri(uri, null));
    }

    public CloudPageBlob(CloudPageBlob otherBlob) throws StorageException {
        super(otherBlob);
    }

    public CloudPageBlob(URI uri, CloudBlobClient client) throws StorageException {
        super(BlobType.PAGE_BLOB, uri, client);
    }

    public CloudPageBlob(URI uri, CloudBlobClient client, CloudBlobContainer container) throws StorageException {
        super(BlobType.PAGE_BLOB, uri, client, container);
    }

    public CloudPageBlob(URI uri, String snapshotID, CloudBlobClient client) throws StorageException {
        super(BlobType.PAGE_BLOB, uri, snapshotID, client);
    }

    @DoesServiceRequest
    public void clearPages(long offset, long length) throws StorageException, IOException {
        this.clearPages(offset, length, null, null, null);
    }

    @DoesServiceRequest
    public void clearPages(long offset, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (offset % 512L != 0L) {
            throw new IllegalArgumentException("Page start offset must be multiple of 512!");
        }
        if (length % 512L != 0L) {
            throw new IllegalArgumentException("Page data must be multiple of 512!");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        PageProperties pageProps = new PageProperties();
        pageProps.setPageOperation(PageOperationType.CLEAR);
        pageProps.getRange().setStartOffset(offset);
        pageProps.getRange().setEndOffset(offset + length - 1L);
        this.putPagesInternal(pageProps, null, length, null, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void create(long length) throws StorageException {
        this.create(length, null, null, null);
    }

    @DoesServiceRequest
    public void create(final long length, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (length % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.put(blob.getTransformedAddress(opContext), this.getRequestOptions().getTimeoutIntervalInMs(), blob.properties, BlobType.PAGE_BLOB, length, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                BlobRequest.addMetadata(request, blob.metadata, opContext);
                this.signRequest(client, request, 0L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ArrayList<PageRange> downloadPageRanges() throws StorageException {
        return this.downloadPageRanges(null, null, null);
    }

    @DoesServiceRequest
    public ArrayList<PageRange> downloadPageRanges(final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, ArrayList<PageRange>> impl = new StorageOperation<CloudBlobClient, CloudBlob, ArrayList<PageRange>>((RequestOptions)options){

            @Override
            public ArrayList<PageRange> execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.getPageRanges(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), blob.snapshotID, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                blob.updateLengthFromResponse(request);
                GetPageRangesResponse response = new GetPageRangesResponse(request.getInputStream());
                return response.getPageRanges();
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public BlobOutputStream openOutputStream(long length) throws StorageException {
        return this.openOutputStream(length, null, null, null);
    }

    @DoesServiceRequest
    public BlobOutputStream openOutputStream(long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        this.assertNoWriteOperationForSnapshot();
        options.applyDefaults(this.blobServiceClient);
        if (options.getStoreBlobContentMD5()) {
            throw new IllegalArgumentException("Blob Level MD5 is not supported for PageBlob");
        }
        return new BlobOutputStream(this, length, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private void putPagesInternal(final PageProperties pageProperties, final byte[] data, final long length, final String md5, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.putPage(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), pageProperties, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                if (pageProperties.getPageOperation() == PageOperationType.UPDATE) {
                    if (blobOptions.getUseTransactionalContentMD5()) {
                        request.setRequestProperty("Content-MD5", md5);
                    }
                    this.signRequest(client, request, length, null);
                    request.getOutputStream().write(data);
                } else {
                    this.signRequest(client, request, 0L, null);
                }
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException {
        this.upload(sourceStream, length, null, null, null);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        if (length <= 0L || length % 512L != 0L) {
            throw new IllegalArgumentException("Page data must be multiple of 512!");
        }
        if (options.getStoreBlobContentMD5()) {
            throw new IllegalArgumentException("Blob Level MD5 is not supported for PageBlob");
        }
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        if (length <= 0x400000L) {
            this.create(length, accessCondition, options, opContext);
            this.uploadPages(sourceStream, 0L, length, accessCondition, options, opContext);
        } else {
            BlobOutputStream streamRef = this.openOutputStream(length, accessCondition, options, opContext);
            Utility.writeToOutputStream(sourceStream, streamRef, length, false, false, null, opContext);
            ((OutputStream)streamRef).close();
        }
    }

    @DoesServiceRequest
    public void uploadPages(InputStream sourceStream, long offset, long length) throws StorageException, IOException {
        this.uploadPages(sourceStream, offset, length, null, null, null);
    }

    @DoesServiceRequest
    public void uploadPages(InputStream sourceStream, long offset, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (offset % 512L != 0L) {
            throw new IllegalArgumentException("Page start offset must be multiple of 512!");
        }
        if (length % 512L != 0L) {
            throw new IllegalArgumentException("Page data must be multiple of 512!");
        }
        if (length > 0x400000L) {
            throw new IllegalArgumentException("Max write size is 4MB. Please specify a smaller range.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        PageProperties pageProps = new PageProperties();
        pageProps.setPageOperation(PageOperationType.UPDATE);
        pageProps.getRange().setStartOffset(offset);
        pageProps.getRange().setEndOffset(offset + length - 1L);
        byte[] data = new byte[(int)length];
        String md5 = null;
        int count = 0;
        for (long total = 0L; total < length; total += (long)count) {
            count = sourceStream.read(data, 0, (int)Math.min(length - total, Integer.MAX_VALUE));
        }
        if (options.getUseTransactionalContentMD5()) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(data, 0, data.length);
                md5 = Base64.encode(digest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.putPagesInternal(pageProps, data, length, md5, accessCondition, options, opContext);
    }
}

