/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobOutputStream;
import com.microsoft.windowsazure.services.blob.client.BlobRequest;
import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.BlockEntry;
import com.microsoft.windowsazure.services.blob.client.BlockListingFilter;
import com.microsoft.windowsazure.services.blob.client.CloudBlob;
import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.blob.client.CloudBlobContainer;
import com.microsoft.windowsazure.services.blob.client.GetBlockListResponse;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.StreamMd5AndLength;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;

public final class CloudBlockBlob
extends CloudBlob {
    public CloudBlockBlob(URI uri) throws StorageException {
        super(BlobType.BLOCK_BLOB);
        Utility.assertNotNull("blobAbsoluteUri", uri);
        this.uri = uri;
        this.parseURIQueryStringAndVerify(uri, null, Utility.determinePathStyleFromUri(uri, null));
    }

    public CloudBlockBlob(CloudBlockBlob otherBlob) throws StorageException {
        super(otherBlob);
    }

    public CloudBlockBlob(URI uri, CloudBlobClient client) throws StorageException {
        super(BlobType.BLOCK_BLOB, uri, client);
    }

    public CloudBlockBlob(URI uri, CloudBlobClient client, CloudBlobContainer container) throws StorageException {
        super(BlobType.BLOCK_BLOB, uri, client, container);
    }

    public CloudBlockBlob(URI uri, String snapshotID, CloudBlobClient client) throws StorageException {
        super(BlobType.BLOCK_BLOB, uri, snapshotID, client);
    }

    @DoesServiceRequest
    public void commitBlockList(Iterable<BlockEntry> blockList) throws StorageException {
        this.commitBlockList(blockList, null, null, null);
    }

    @DoesServiceRequest
    public void commitBlockList(final Iterable<BlockEntry> blockList, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.putBlockList(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), blob.properties, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                BlobRequest.addMetadata(request, blob.metadata, opContext);
                byte[] blockListBytes = BlobRequest.writeBlockListToStream(blockList, opContext);
                ByteArrayInputStream blockListInputStream = new ByteArrayInputStream(blockListBytes);
                StreamMd5AndLength descriptor = Utility.analyzeStream(blockListInputStream, -1L, -1L, true, true);
                request.setRequestProperty("Content-MD5", descriptor.getMd5());
                this.signRequest(client, request, descriptor.getLength(), null);
                Utility.writeToOutputStream(blockListInputStream, request.getOutputStream(), descriptor.getLength(), false, false, null, opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ArrayList<BlockEntry> downloadBlockList() throws StorageException {
        return this.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
    }

    @DoesServiceRequest
    public ArrayList<BlockEntry> downloadBlockList(final BlockListingFilter blockListingFilter, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("blockListingFilter", (Object)blockListingFilter);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StorageOperation<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>> impl = new StorageOperation<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>>((RequestOptions)options){

            @Override
            public ArrayList<BlockEntry> execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.getBlockList(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), blob.snapshotID, blockListingFilter, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                blob.updateLengthFromResponse(request);
                GetBlockListResponse response = new GetBlockListResponse(request.getInputStream());
                return response.getBlocks();
            }
        };
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    public BlobOutputStream openOutputStream() throws StorageException {
        return this.openOutputStream(null, null, null);
    }

    public BlobOutputStream openOutputStream(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        this.assertNoWriteOperationForSnapshot();
        options.applyDefaults(this.blobServiceClient);
        return new BlobOutputStream(this, accessCondition, options, opContext);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException {
        this.upload(sourceStream, length, null, null, null);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unkown length stream, or a positive number of bytes");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        opContext.initialize();
        options.applyDefaults(this.blobServiceClient);
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        if (sourceStream.markSupported() && (length < 0L || options.getStoreBlobContentMD5()) && (descriptor = Utility.analyzeStream(sourceStream, length, this.blobServiceClient.getSingleBlobPutThresholdInBytes(), true, options.getStoreBlobContentMD5())).getMd5() != null && options.getStoreBlobContentMD5()) {
            this.properties.setContentMD5(descriptor.getMd5());
        }
        if (sourceStream.markSupported() && descriptor.getLength() != -1L && descriptor.getLength() < (long)this.blobServiceClient.getSingleBlobPutThresholdInBytes()) {
            this.uploadFullBlob(sourceStream, descriptor.getLength(), accessCondition, options, opContext);
        } else {
            BlobOutputStream writeStream = this.openOutputStream(accessCondition, options, opContext);
            writeStream.write(sourceStream, length);
            writeStream.close();
        }
    }

    @DoesServiceRequest
    public void uploadBlock(String blockId, InputStream sourceStream, long length) throws StorageException, IOException {
        this.uploadBlock(blockId, sourceStream, length, null, null, null);
    }

    @DoesServiceRequest
    public void uploadBlock(String blockId, InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unkown length stream, or a positive number of bytes");
        }
        if (length > 0x400000L) {
            throw new IllegalArgumentException("Invalid stream length, length must be less than or equal to 4 MB in size.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new BlobRequestOptions();
        }
        options.applyDefaults(this.blobServiceClient);
        if (Utility.isNullOrEmpty(blockId) || !Base64.validateIsBase64String(blockId)) {
            throw new IllegalArgumentException("Invalid blockID, BlockID must be a valid Base64 String.");
        }
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        InputStream bufferedStreamReference = sourceStream;
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        if (!sourceStream.markSupported()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            descriptor = Utility.writeToOutputStream(sourceStream, byteStream, length, false, options.getUseTransactionalContentMD5(), null, opContext);
            bufferedStreamReference = new ByteArrayInputStream(byteStream.toByteArray());
        } else if (length < 0L || options.getUseTransactionalContentMD5()) {
            descriptor = Utility.analyzeStream(sourceStream, length, -1L, true, options.getUseTransactionalContentMD5());
        }
        if (descriptor.getLength() > 0x400000L) {
            throw new IllegalArgumentException("Invalid stream length, length must be less than or equal to 4 MB in size.");
        }
        this.uploadBlockInternal(blockId, descriptor.getMd5(), bufferedStreamReference, descriptor.getLength(), accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private void uploadBlockInternal(final String blockId, final String md5, final InputStream sourceStream, final long length, final AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        StorageOperation<CloudBlobClient, CloudBlob, Void> impl = new StorageOperation<CloudBlobClient, CloudBlob, Void>((RequestOptions)options){

            @Override
            public Void execute(CloudBlobClient client, CloudBlob blob, OperationContext opContext) throws Exception {
                BlobRequestOptions blobOptions = (BlobRequestOptions)this.getRequestOptions();
                HttpURLConnection request = BlobRequest.putBlock(blob.getTransformedAddress(opContext), blobOptions.getTimeoutIntervalInMs(), blockId, accessCondition, blobOptions, opContext);
                this.setConnection(request);
                if (blobOptions.getUseTransactionalContentMD5()) {
                    request.setRequestProperty("Content-MD5", md5);
                }
                this.signRequest(client, request, length, null);
                Utility.writeToOutputStream(sourceStream, request.getOutputStream(), length, true, false, null, opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(request);
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, impl, options.getRetryPolicyFactory(), opContext);
    }
}

