/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobAttributes;
import com.microsoft.windowsazure.services.blob.client.BlobProperties;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseResponse;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

final class BlobResponse
extends BaseResponse {
    BlobResponse() {
    }

    public static BlobAttributes getAttributes(HttpURLConnection request, URI resourceURI, String snapshotID, OperationContext opContext) throws URISyntaxException, ParseException {
        String blobType = request.getHeaderField("x-ms-blob-type");
        BlobAttributes attributes = new BlobAttributes(BlobType.parse(blobType));
        BlobProperties properties = attributes.getProperties();
        properties.setCacheControl(request.getHeaderField("Cache-Control"));
        properties.setContentEncoding(request.getHeaderField("Content-Encoding"));
        properties.setContentLanguage(request.getHeaderField("Content-Language"));
        properties.setContentMD5(request.getHeaderField("Content-MD5"));
        properties.setContentType(request.getHeaderField("Content-Type"));
        properties.setEtag(request.getHeaderField("ETag"));
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        lastModifiedCalendar.setTime(new Date(request.getLastModified()));
        properties.setLastModified(lastModifiedCalendar.getTime());
        properties.setLeaseStatus(BaseResponse.getLeaseStatus(request));
        properties.setLeaseState(BaseResponse.getLeaseState(request));
        properties.setLeaseDuration(BaseResponse.getLeaseDuration(request));
        String rangeHeader = request.getHeaderField("Cache-Range");
        String xContentLengthHeader = request.getHeaderField("x-ms-blob-content-length");
        if (!Utility.isNullOrEmpty(rangeHeader)) {
            properties.setLength(Long.parseLong(rangeHeader));
        } else if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            properties.setLength(Long.parseLong(xContentLengthHeader));
        } else {
            String contentLength = request.getHeaderField("Content-Length");
            if (!Utility.isNullOrEmpty(contentLength)) {
                properties.setLength(Long.parseLong(contentLength));
            }
        }
        attributes.uri = resourceURI;
        attributes.snapshotID = snapshotID;
        attributes.setMetadata(BlobResponse.getMetadata(request));
        attributes.setCopyState(BaseResponse.getCopyState(request));
        return attributes;
    }

    public static String getLeaseID(HttpURLConnection request, OperationContext opContext) {
        return request.getHeaderField("x-ms-lease-id");
    }

    public static String getLeaseTime(HttpURLConnection request, OperationContext opContext) {
        return request.getHeaderField("x-ms-lease-time");
    }

    public static String getSnapshotTime(HttpURLConnection request, OperationContext opContext) {
        return request.getHeaderField("x-ms-snapshot");
    }
}

