/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.CloudBlobClient;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;

public final class BlobRequestOptions
extends RequestOptions {
    private Integer concurrentRequestCount = null;
    private Boolean useTransactionalContentMD5 = false;
    private Boolean storeBlobContentMD5 = false;
    private Boolean disableContentMD5Validation = false;
    private Boolean useSparsePageBlob = false;

    public BlobRequestOptions() {
    }

    public BlobRequestOptions(BlobRequestOptions other) {
        super(other);
        this.setConcurrentRequestCount(other.getConcurrentRequestCount());
        this.setStoreBlobContentMD5(other.getStoreBlobContentMD5());
        this.setUseTransactionalContentMD5(other.getUseTransactionalContentMD5());
        this.setUseSparsePageBlob(other.getUseSparsePageBlob());
        this.disableContentMD5Validation = other.disableContentMD5Validation;
    }

    protected void applyDefaults(CloudBlobClient client) {
        super.applyBaseDefaults(client);
        if (this.getConcurrentRequestCount() == null) {
            this.setConcurrentRequestCount(client.getConcurrentRequestCount());
        }
    }

    public Integer getConcurrentRequestCount() {
        return this.concurrentRequestCount;
    }

    protected boolean getDisableContentMD5Validation() {
        return this.disableContentMD5Validation;
    }

    public boolean getStoreBlobContentMD5() {
        return this.storeBlobContentMD5;
    }

    public boolean getUseSparsePageBlob() {
        return this.useSparsePageBlob;
    }

    public boolean getUseTransactionalContentMD5() {
        return this.useTransactionalContentMD5;
    }

    public void setConcurrentRequestCount(Integer concurrentRequestCount) {
        this.concurrentRequestCount = concurrentRequestCount;
    }

    public void setDisableContentMD5Validation(boolean disableContentMD5Validation) {
        this.disableContentMD5Validation = disableContentMD5Validation;
    }

    public void setStoreBlobContentMD5(boolean storeBlobContentMD5) {
        this.storeBlobContentMD5 = storeBlobContentMD5;
    }

    public void setUseSparsePageBlob(boolean useSparsePageBlob) {
        this.useSparsePageBlob = useSparsePageBlob;
    }

    public void setUseTransactionalContentMD5(boolean useTransactionalContentMD5) {
        this.useTransactionalContentMD5 = useTransactionalContentMD5;
    }
}

