/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.BlockEntry;
import com.microsoft.windowsazure.services.blob.client.BlockSearchMode;
import com.microsoft.windowsazure.services.blob.client.CloudBlob;
import com.microsoft.windowsazure.services.blob.client.CloudBlockBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class BlobOutputStream
extends OutputStream {
    private static Random blockSequenceGenerator = new Random();
    private final CloudBlob parentBlobRef;
    private BlobType streamType = BlobType.UNSPECIFIED;
    volatile boolean streamFaulted;
    Object lastErrorLock = new Object();
    IOException lastError;
    OperationContext opContext;
    BlobRequestOptions options;
    private MessageDigest md5Digest;
    private long blockIdSequenceNumber = -1L;
    private ArrayList<BlockEntry> blockList;
    private long currentPageOffset;
    private long firstNonZeroBufferedByte = -1L;
    private long lastNonZeroBufferedByte = -1L;
    private ByteArrayOutputStream outBuffer;
    private int currentBufferedBytes;
    private int internalWriteThreshold = -1;
    private volatile int outstandingRequests;
    private final ExecutorService threadExecutor;
    private final CompletionService<Void> completionService;
    AccessCondition accessCondition = null;

    protected BlobOutputStream(CloudBlob parentBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.accessCondition = accessCondition;
        this.parentBlobRef = parentBlob;
        this.parentBlobRef.assertCorrectBlobType();
        this.options = new BlobRequestOptions(options);
        this.outBuffer = new ByteArrayOutputStream();
        this.opContext = opContext;
        this.streamFaulted = false;
        if (this.options.getConcurrentRequestCount() < 1) {
            throw new IllegalArgumentException("ConcurrentRequestCount");
        }
        if (this.options.getStoreBlobContentMD5()) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.threadExecutor = Executors.newFixedThreadPool(this.options.getConcurrentRequestCount());
        this.completionService = new ExecutorCompletionService<Void>(this.threadExecutor);
    }

    protected BlobOutputStream(CloudBlockBlob parentBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this((CloudBlob)parentBlob, accessCondition, options, opContext);
        this.blockIdSequenceNumber = (long)blockSequenceGenerator.nextInt(Integer.MAX_VALUE) + (long)blockSequenceGenerator.nextInt(2147383647);
        this.blockList = new ArrayList();
        this.streamType = BlobType.BLOCK_BLOB;
        this.internalWriteThreshold = this.parentBlobRef.blobServiceClient.getWriteBlockSizeInBytes();
    }

    @DoesServiceRequest
    protected BlobOutputStream(CloudPageBlob parentBlob, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this(parentBlob, accessCondition, options, opContext);
        this.streamType = BlobType.PAGE_BLOB;
        this.internalWriteThreshold = (int)Math.min((long)this.parentBlobRef.blobServiceClient.getPageBlobStreamWriteSizeInBytes(), length);
        if (length % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (this.options.getStoreBlobContentMD5()) {
            throw new IllegalArgumentException("Blob Level MD5 is not supported for PageBlob");
        }
        parentBlob.create(length, accessCondition, options, opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamState() throws IOException {
        Object object = this.lastErrorLock;
        synchronized (object) {
            if (this.streamFaulted) {
                throw this.lastError;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void close() throws IOException {
        this.flush();
        this.checkStreamState();
        IOException tempException = null;
        Object object = this.lastErrorLock;
        synchronized (object) {
            this.streamFaulted = true;
            tempException = this.lastError = new IOException("Stream is already closed.");
        }
        while (this.outstandingRequests > 0) {
            this.waitForTaskToComplete();
        }
        this.threadExecutor.shutdown();
        object = this.lastErrorLock;
        synchronized (object) {
            if (tempException != this.lastError) {
                throw this.lastError;
            }
        }
        try {
            this.commit();
        }
        catch (StorageException e) {
            throw Utility.initIOException(e);
        }
    }

    @DoesServiceRequest
    private void commit() throws StorageException, IOException {
        if (this.options.getStoreBlobContentMD5()) {
            this.parentBlobRef.getProperties().setContentMD5(Base64.encode(this.md5Digest.digest()));
        }
        if (this.streamType == BlobType.BLOCK_BLOB) {
            CloudBlockBlob blobRef = (CloudBlockBlob)this.parentBlobRef;
            blobRef.commitBlockList(this.blockList, this.accessCondition, this.options, this.opContext);
        } else if (this.streamType == BlobType.PAGE_BLOB) {
            this.parentBlobRef.uploadProperties(this.accessCondition, this.options, this.opContext);
        }
    }

    @DoesServiceRequest
    private synchronized void dispatchWrite(final int writeLength) throws IOException {
        if (writeLength == 0) {
            return;
        }
        Callable<Void> worker = null;
        if (this.outstandingRequests > this.options.getConcurrentRequestCount() * 2) {
            this.waitForTaskToComplete();
        }
        final ByteArrayInputStream bufferRef = new ByteArrayInputStream(this.outBuffer.toByteArray());
        if (this.streamType == BlobType.BLOCK_BLOB) {
            final CloudBlockBlob blobRef = (CloudBlockBlob)this.parentBlobRef;
            final String blockID = Base64.encode(Utility.getBytesFromLong(this.blockIdSequenceNumber++));
            this.blockList.add(new BlockEntry(blockID, BlockSearchMode.LATEST));
            worker = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        blobRef.uploadBlock(blockID, bufferRef, writeLength, BlobOutputStream.this.accessCondition, BlobOutputStream.this.options, BlobOutputStream.this.opContext);
                    }
                    catch (IOException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = e;
                        }
                    }
                    catch (StorageException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = Utility.initIOException(e);
                        }
                    }
                    return null;
                }
            };
        } else if (this.streamType == BlobType.PAGE_BLOB) {
            final CloudPageBlob blobRef = (CloudPageBlob)this.parentBlobRef;
            long tempOffset = this.currentPageOffset;
            long tempLength = writeLength;
            if (this.options.getUseSparsePageBlob()) {
                if (this.lastNonZeroBufferedByte == -1L) {
                    this.firstNonZeroBufferedByte = -1L;
                    this.lastNonZeroBufferedByte = -1L;
                    this.currentBufferedBytes = 0;
                    this.currentPageOffset += (long)writeLength;
                    this.outBuffer = new ByteArrayOutputStream();
                    return;
                }
                long bufferOffset = this.firstNonZeroBufferedByte - this.firstNonZeroBufferedByte % 512L;
                tempOffset = this.currentPageOffset + bufferOffset;
                tempLength = this.lastNonZeroBufferedByte - bufferOffset + (512L - this.lastNonZeroBufferedByte % 512L);
                this.firstNonZeroBufferedByte = -1L;
                this.lastNonZeroBufferedByte = -1L;
                if (bufferOffset > 0L && bufferOffset != bufferRef.skip(bufferOffset)) {
                    throw Utility.initIOException(Utility.generateNewUnexpectedStorageException(null));
                }
            }
            final long opWriteLength = tempLength;
            final long opOffset = tempOffset;
            this.currentPageOffset += (long)writeLength;
            worker = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        blobRef.uploadPages(bufferRef, opOffset, opWriteLength, BlobOutputStream.this.accessCondition, BlobOutputStream.this.options, BlobOutputStream.this.opContext);
                    }
                    catch (IOException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = e;
                        }
                    }
                    catch (StorageException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = Utility.initIOException(e);
                        }
                    }
                    return null;
                }
            };
        }
        this.completionService.submit(worker);
        ++this.outstandingRequests;
        this.currentBufferedBytes = 0;
        this.outBuffer = new ByteArrayOutputStream();
    }

    @Override
    @DoesServiceRequest
    public synchronized void flush() throws IOException {
        this.checkStreamState();
        if (this.streamType == BlobType.PAGE_BLOB && this.currentBufferedBytes > 0 && this.currentBufferedBytes % 512 != 0) {
            throw new IOException(String.format("Page data must be a multiple of 512 bytes, buffer currently contains %d bytes.", this.currentBufferedBytes));
        }
        this.dispatchWrite(this.currentBufferedBytes);
    }

    private void waitForTaskToComplete() throws IOException {
        try {
            Future<Void> future = this.completionService.take();
            future.get();
        }
        catch (InterruptedException e) {
            throw Utility.initIOException(e);
        }
        catch (ExecutionException e) {
            throw Utility.initIOException(e);
        }
        --this.outstandingRequests;
    }

    @Override
    @DoesServiceRequest
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    @DoesServiceRequest
    public void write(byte[] data, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.writeInternal(data, offset, length);
    }

    @DoesServiceRequest
    public void write(InputStream sourceStream, long writeLength) throws IOException, StorageException {
        Utility.writeToOutputStream(sourceStream, this, writeLength, false, false, null, this.opContext);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @DoesServiceRequest
    private synchronized void writeInternal(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            this.checkStreamState();
            int availableBufferBytes = this.internalWriteThreshold - this.currentBufferedBytes;
            int nextWrite = Math.min(availableBufferBytes, length);
            if (this.options.getStoreBlobContentMD5()) {
                this.md5Digest.update(data, offset, nextWrite);
            }
            if (this.options.getUseSparsePageBlob()) {
                for (int m = 0; m < nextWrite; ++m) {
                    if (data[m + offset] == 0) continue;
                    if (this.firstNonZeroBufferedByte == -1L) {
                        this.firstNonZeroBufferedByte = this.currentBufferedBytes + m;
                    }
                    this.lastNonZeroBufferedByte = this.currentBufferedBytes + m;
                }
            }
            this.outBuffer.write(data, offset, nextWrite);
            this.currentBufferedBytes += nextWrite;
            offset += nextWrite;
            length -= nextWrite;
            if (this.currentBufferedBytes != this.internalWriteThreshold) continue;
            this.dispatchWrite(this.internalWriteThreshold);
        }
    }
}

