/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.client;

import com.microsoft.windowsazure.services.blob.client.BlobRequestOptions;
import com.microsoft.windowsazure.services.blob.client.BlobType;
import com.microsoft.windowsazure.services.blob.client.CloudBlob;
import com.microsoft.windowsazure.services.blob.client.CloudPageBlob;
import com.microsoft.windowsazure.services.blob.client.PageRange;
import com.microsoft.windowsazure.services.core.storage.AccessCondition;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageErrorCode;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class BlobInputStream
extends InputStream {
    private final CloudBlob parentBlobRef;
    private MessageDigest md5Digest;
    private volatile boolean streamFaulted;
    private IOException lastError;
    private final OperationContext opContext;
    private final BlobRequestOptions options;
    private long streamLength = -1L;
    private final int readSize;
    private boolean validateBlobMd5;
    private final String retrievedContentMD5Value;
    private ByteArrayInputStream currentBuffer;
    private long markedPosition;
    private int markExpiry;
    private ArrayList<PageRange> pageBlobRanges;
    private int currentPageRangeIndex;
    private long currentAbsoluteReadPosition;
    private long bufferStartOffset;
    private int bufferSize;
    private AccessCondition accessCondition = null;

    @DoesServiceRequest
    protected BlobInputStream(CloudBlob parentBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.parentBlobRef = parentBlob;
        this.parentBlobRef.assertCorrectBlobType();
        this.options = new BlobRequestOptions(options);
        this.opContext = opContext;
        this.streamFaulted = false;
        this.currentAbsoluteReadPosition = 0L;
        this.readSize = parentBlob.blobServiceClient.getStreamMinimumReadSizeInBytes();
        if (options.getUseTransactionalContentMD5() && this.readSize > 0x400000) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB");
        }
        parentBlob.downloadAttributes(accessCondition, this.options, this.opContext);
        HttpURLConnection attributesRequest = this.opContext.getCurrentRequestObject();
        this.retrievedContentMD5Value = attributesRequest.getHeaderField("Content-MD5");
        this.validateBlobMd5 = !options.getDisableContentMD5Validation() && !Utility.isNullOrEmpty(this.retrievedContentMD5Value);
        String previousLeaseId = null;
        if (accessCondition != null) {
            previousLeaseId = accessCondition.getLeaseID();
            if (!accessCondition.verifyConditional(this.parentBlobRef.getProperties().getEtag(), this.parentBlobRef.getProperties().getLastModified())) {
                throw new StorageException(StorageErrorCode.CONDITION_FAILED.toString(), "The conditionals specified for this operation did not match server.", 412, null, null);
            }
        }
        this.accessCondition = AccessCondition.generateIfMatchCondition(this.parentBlobRef.getProperties().getEtag());
        this.accessCondition.setLeaseID(previousLeaseId);
        this.streamLength = parentBlob.getProperties().getLength();
        if (this.validateBlobMd5) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        if (this.parentBlobRef.getProperties().getBlobType() == BlobType.PAGE_BLOB && this.options.getUseSparsePageBlob()) {
            this.pageBlobRanges = ((CloudPageBlob)parentBlob).downloadPageRanges(this.accessCondition, options, opContext);
        } else if (this.parentBlobRef.getProperties().getBlobType() == BlobType.BLOCK_BLOB && this.options.getUseSparsePageBlob()) {
            throw new IllegalArgumentException("The UseSparsePageBlob option is not applicable of Block Blob streams.");
        }
        this.reposition(0L);
    }

    @Override
    public synchronized int available() throws IOException {
        return this.bufferSize - (int)(this.currentAbsoluteReadPosition - this.bufferStartOffset);
    }

    private synchronized void checkStreamState() throws IOException {
        if (this.streamFaulted) {
            throw this.lastError;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.currentBuffer = null;
        this.streamFaulted = true;
        this.lastError = new IOException("Stream is closed");
    }

    @DoesServiceRequest
    private synchronized void dispatchRead(int readLength) throws IOException {
        try {
            byte[] byteBuffer = new byte[readLength];
            if (this.options.getUseSparsePageBlob()) {
                long resolvedReadStart = this.currentAbsoluteReadPosition;
                long resolvedReadEnd = this.currentAbsoluteReadPosition + (long)readLength;
                PageRange startRange = this.getCurrentRange();
                if (startRange != null) {
                    resolvedReadStart = startRange.getStartOffset();
                    resolvedReadEnd = startRange.getEndOffset() + 1L;
                    while (this.currentAbsoluteReadPosition > startRange.getEndOffset()) {
                        ++this.currentPageRangeIndex;
                        startRange = this.getCurrentRange();
                        if (startRange == null) break;
                        resolvedReadStart = startRange.getStartOffset();
                        resolvedReadEnd = startRange.getEndOffset() + 1L;
                    }
                }
                if (startRange != null) {
                    PageRange endRange;
                    int endDex = this.currentPageRangeIndex + 1;
                    PageRange pageRange = endRange = endDex < this.pageBlobRanges.size() ? this.pageBlobRanges.get(endDex) : null;
                    while (endDex < this.pageBlobRanges.size() - 1 && this.currentAbsoluteReadPosition + (long)readLength >= endRange.getEndOffset()) {
                        endRange = this.pageBlobRanges.get(++endDex);
                        resolvedReadEnd = endRange.getEndOffset() + 1L;
                    }
                    int bufferOffset = (int)(resolvedReadStart - this.currentAbsoluteReadPosition);
                    int opReadLength = (int)Math.min((long)(readLength - bufferOffset), (resolvedReadEnd = Math.min(resolvedReadEnd, this.currentAbsoluteReadPosition + (long)readLength)) - resolvedReadStart);
                    if (opReadLength > 0) {
                        this.parentBlobRef.downloadRangeInternal(resolvedReadStart, opReadLength, byteBuffer, bufferOffset, this.accessCondition, this.options, this.opContext);
                    }
                }
            } else {
                this.parentBlobRef.downloadRangeInternal(this.currentAbsoluteReadPosition, readLength, byteBuffer, 0, this.accessCondition, this.options, this.opContext);
            }
            this.currentBuffer = new ByteArrayInputStream(byteBuffer);
            this.bufferSize = readLength;
            this.bufferStartOffset = this.currentAbsoluteReadPosition;
        }
        catch (StorageException e) {
            this.streamFaulted = true;
            this.lastError = Utility.initIOException(e);
            throw this.lastError;
        }
    }

    private PageRange getCurrentRange() {
        if (this.currentPageRangeIndex >= this.pageBlobRanges.size()) {
            return null;
        }
        return this.pageBlobRanges.get(this.currentPageRangeIndex);
    }

    protected synchronized boolean getValidateBlobMd5() {
        return this.validateBlobMd5;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedPosition = this.currentAbsoluteReadPosition;
        this.markExpiry = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    @DoesServiceRequest
    public int read() throws IOException {
        byte[] tBuff = new byte[1];
        int numberOfBytesRead = this.read(tBuff, 0, 1);
        if (numberOfBytesRead > 0) {
            return tBuff[0] & 0xFF;
        }
        if (numberOfBytesRead == 0) {
            throw new IOException("Unexpected error. Stream returned unexpected number of bytes.");
        }
        return -1;
    }

    @Override
    @DoesServiceRequest
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    @DoesServiceRequest
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        return this.readInternal(b, off, len);
    }

    @DoesServiceRequest
    private synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        int numberOfBytesRead;
        this.checkStreamState();
        if ((this.currentBuffer == null || this.currentBuffer.available() == 0) && this.currentAbsoluteReadPosition < this.streamLength) {
            this.dispatchRead((int)Math.min((long)this.readSize, this.streamLength - this.currentAbsoluteReadPosition));
        }
        if ((numberOfBytesRead = this.currentBuffer.read(b, off, len = Math.min(len, this.readSize))) > 0) {
            this.currentAbsoluteReadPosition += (long)numberOfBytesRead;
            if (this.validateBlobMd5) {
                String calculatedMd5;
                this.md5Digest.update(b, off, numberOfBytesRead);
                if (this.currentAbsoluteReadPosition == this.streamLength && !(calculatedMd5 = Base64.encode(this.md5Digest.digest())).equals(this.retrievedContentMD5Value)) {
                    this.lastError = Utility.initIOException(new StorageException("InvalidMd5", String.format("Blob data corrupted (integrity check failed), Expected value is %s, retrieved %s", this.retrievedContentMD5Value, calculatedMd5), 306, null, null));
                    this.streamFaulted = true;
                    throw this.lastError;
                }
            }
        }
        if (this.markExpiry > 0 && this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            this.markedPosition = 0L;
            this.markExpiry = 0;
        }
        return numberOfBytesRead;
    }

    private synchronized void reposition(long absolutePosition) {
        this.currentAbsoluteReadPosition = absolutePosition;
        this.currentBuffer = new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            throw new IOException("Mark expired!");
        }
        this.validateBlobMd5 = false;
        this.md5Digest = null;
        this.reposition(this.markedPosition);
    }

    protected synchronized void setValidateBlobMd5(boolean validateBlobMd5) {
        this.validateBlobMd5 = validateBlobMd5;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L || this.currentAbsoluteReadPosition + n > this.streamLength) {
            throw new IndexOutOfBoundsException();
        }
        this.validateBlobMd5 = false;
        this.md5Digest = null;
        this.reposition(this.currentAbsoluteReadPosition + n);
        return n;
    }

    @DoesServiceRequest
    protected long writeTo(OutputStream outStream) throws IOException {
        byte[] buffer = new byte[8192];
        long total = 0L;
        int count = this.read(buffer);
        while (count != -1) {
            outStream.write(buffer, 0, count);
            total += (long)count;
            count = this.read(buffer);
        }
        return total;
    }
}

