package com.microsoft.sqlserver.jdbc;
import java.util.*;
public final class SQLServerResource_ja extends ListResourceBundle
				  {
protected Object[][]  getContents()
{
return contents;
}


static final Object[][] contents =
{
{"R_timedOutBeforeRouting","ルーティング先に接続する前にタイムアウトが発生しました。"},
{"R_invalidRoutingInfo","予期しないルーティング情報を受信しました。接続のプロパティと、SQL Server の構成を確認してください。"},
{"R_multipleRedirections","複数のリダイレクトが発生しました。1 回のログインに 1 つのリダイレクトだけが許可されます。"},
{"R_dbMirroringWithMultiSubnetFailover","multiSubnetFailover 接続プロパティを使用するミラー化された SQL Server インスタンスへの接続はサポートされていません。"},
{"R_dbMirroringWithReadOnlyIntent","ApplicationIntent ReadOnly 接続プロパティを使用するミラー化された SQL Server インスタンスへの接続はサポートされていません。"},
{"R_ipAddressLimitWithMultiSubnetFailover","{0} IP アドレスを超える構成の SQL Server インスタンスに対する multiSubnetFailover 接続プロパティを使用した接続はサポートされていません。"},
{"R_connectionTimedOut","接続のタイムアウト: 詳細情報はありません。"},
{"R_invalidPositionIndex","位置インデックス {0} は無効です。"},
{"R_invalidLength","長さ {0} は無効です。"},
{"R_unknownSSType","SQL Server データ型 {0} が無効です。"},
{"R_unknownJDBCType","JDBC データ型 {0} が無効です。"},
{"R_notSQLServer","ドライバーが予期しないログイン前の応答を受け取りました。接続プロパティを調べて、SQL Server のインスタンスがホスト上で実行されていて、ポートへの TCP/IP 接続が許可されていることを確認してください。このドライバーは、SQL Server 2005 以降でのみ使用できます。"},
{"R_tcpOpenFailed","{0}。接続プロパティを調べて、SQL Server のインスタンスがホスト上で実行されていて、ポートへの TCP/IP 接続が許可されており、そのポートへの TCP 接続がファイアウォールにブロックされていないことを確認してください。"},
{"R_unsupportedServerVersion","SQL Server バージョン {0} は、このドライバーではサポートされていません。"},
{"R_noServerResponse","SQL Server が応答を返しませんでした。接続が閉じられました。"},
{"R_truncatedServerResponse","SQL Server が不完全な応答を返しました。接続が閉じられました。"},
{"R_queryTimedOut","クエリがタイムアウトしました。"},
{"R_queryCancelled","クエリが取り消されました。"},
{"R_errorReadingStream","ストリーム オブジェクトからの値の読み込み中にエラーが発生しました。エラー: \"{0}\""},
{"R_streamReadReturnedInvalidValue","ストリーム読み取り操作から、データ読み取り量についての無効な値が返されました。"},
{"R_mismatchedStreamLength","ストリームの値の長さと指定された長さが一致していません。指定された長さは {0} でしたが、実際の長さは {1} です。"},
{"R_notSupported","この操作はサポートされていません。"},
{"R_invalidOutputParameter","出力パラメーターのインデックス {0} は無効です。"},
{"R_outputParameterNotRegisteredForOutput","出力パラメーター {0} が出力に登録されていません。"},
{"R_parameterNotDefinedForProcedure","パラメーター {0} がストアド プロシージャ {1} で定義されていません。"},
{"R_connectionIsClosed","接続は閉じられています。"},
{"R_invalidBooleanValue","プロパティ {0} には有効なブール値が含まれていません。使用できる値は、true または false だけです。"},
{"R_propertyMaximumExceedsChars","{0} プロパティの長さが、最大文字数の {1} 文字を超えています。"},
{"R_invalidPortNumber","ポート番号 {0} は無効です。"},
{"R_invalidTimeOut","timeout {0} は無効です。"},
{"R_invalidLockTimeOut","lockTimeOut {0} は無効です。"},
{"R_invalidAuthenticationScheme","authenticationScheme {0} が無効です。"},
{"R_invalidPacketSize","packetSize {0} は無効です。"},
{"R_packetSizeTooBigForSSL","SSL 暗号化は、{0} バイトより大きいネットワーク パケットでは使用できません。接続のプロパティと、SQL Server の構成を確認してください。"},
{"R_tcpipConnectionFailed","ホスト {0}、ポート {1} への TCP/IP 接続が失敗しました。エラー: \"{2}\"。"},
{"R_invalidTransactionLevel","トランザクション レベル {0} は無効です。"},
{"R_cantInvokeRollback","AutoCommit モードが \"true\" に設定されている場合は、ロールバック操作を実行することはできません。"},
{"R_cantSetSavepoint","AutoCommit モードが \"true\" に設定されているときは、savepoint を設定することはできません。"},
{"R_sqlServerHoldability","SQL Server は保持機能を接続レベルのみでサポートします。connection.setHoldability() メソッドを使用してください。"},
{"R_invalidHoldability","holdability 値 {0} は無効です。"},
{"R_invalidColumnArrayLength","列のアレイが無効です。長さを 1 にする必要があります。"},
{"R_valueNotSetForParameter","パラメーター番号 {0} に値が設定されていません。"},
{"R_sqlBrowserFailed","ホスト {0}、名前付きインスタンス {1} への接続が失敗しました。エラー: \"{2}\"。サーバーとインスタンスの名前を調べ、ポート 1434 への UDP トラフィックがファイアウォールにブロックされていないことを確認してください。SQL Server 2005 以降では、SQL Server Browser サービスがホスト上で実行されていることを確認してください。"},
{"R_notConfiguredToListentcpip","サーバー {0} は、TCP/IP をリッスンするように構成されていません。"},
{"R_cantIdentifyTableMetadata","メタデータのテーブル {0} を識別できません。"},
{"R_metaDataErrorForParameter","パラメーター {0} のメタデータ エラーが発生しました。"},
{"R_invalidParameterNumber","パラメーター番号 {0} は無効です。"},
{"R_noMetadata","メタデータがありません。"},
{"R_resultsetClosed","ResultSet は閉じられています。"},
{"R_invalidColumnName","列名 {0} は無効です。"},
{"R_resultsetNotUpdatable","ResultSet を更新することはできません。"},
{"R_indexOutOfRange","インデックス {0} は範囲外です。"},
{"R_savepointNotNamed","savepoint に名前が付けられていません。"},
{"R_savepointNamed","savepoint {0} には名前が付けられています。"},
{"R_resultsetNoCurrentRow","ResultSet に現在の行がありません。"},
{"R_mustBeOnInsertRow","カーソルが挿入行に置かれていません。"},
{"R_mustNotBeOnInsertRow","要求された操作を挿入行で行うことはできません。"},
{"R_cantUpdateDeletedRow","削除された行を更新することはできません。"},
{"R_noResultset","ステートメントは ResultSet を返しませんでした。"},
{"R_resultsetGeneratedForUpdate","更新に対して ResultSet が生成されました。"},
{"R_statementIsClosed","ステートメントは終了しています。"},
{"R_invalidRowcount","結果セットの最大行数 {0} は負以外の値にする必要があります。"},
{"R_invalidQueryTimeOutValue","クエリのタイムアウト値 {0} は無効です。"},
{"R_invalidFetchDirection","フェッチの方向 {0} は無効です。"},
{"R_invalidFetchSize","フェッチ サイズに負の値を指定することはできません。"},
{"R_noColumnParameterValue","行を更新するための列パラメーター値が指定されていません。"},
{"R_statementMustBeExecuted","結果を取得するには、事前にステートメントを実行する必要があります。"},
{"R_modeSuppliedNotValid","指定されたモードは無効です。"},
{"R_errorConnectionString","形式の正しくない名前または値が接続文字列に含まれています。"},
{"R_errorProcessingComplexQuery","複雑なクエリの処理中にエラーが発生しました。"},
{"R_invalidOffset","オフセット {0} は無効です。"},
{"R_nullConnection","接続 URL が NULL です。"},
{"R_invalidConnection","接続 URL が無効です。"},
{"R_cannotTakeArgumentsPreparedOrCallable","メソッド {0} は、PreparedStatement または CallableStatement で引数を取れません。"},
{"R_unsupportedConversionFromTo","{0} から {1} への変換はサポートされていません。"},
{"R_unsupportedConversionTo","{0} への変換はサポートされていません。"},
{"R_errorConvertingValue","{0} の値の JDBC データ型 {1} への変換中にエラーが発生しました。"},
{"R_streamIsClosed","ストリームは閉じられています。"},
{"R_invalidTDS","TDS プロトコル ストリームが無効です。"},
{"R_unexpectedToken"," 予期されていない token {0} です。"},
{"R_selectNotPermittedinBatch","SELECT ステートメントをバッチで使用することはできません。"},
{"R_failedToCreateXAConnection","XA コントロール接続を作成できませんでした。エラー: \"{0}\""},
{"R_codePageNotSupported","コード ページ {0} は Java 環境ではサポートされていません。"},
{"R_unknownSortId","SQL Server 照合順序 {0} は、このドライバーではサポートされていません。"},
{"R_unknownLCID","Windows 照合順序 {0} は、このドライバーではサポートされていません。"},
{"R_encodingErrorWritingTDS","TDS バッファーへの文字列の書き込み中に、エンコーディング エラーが発生しました。エラー: \"{0}\""},
{"R_processingError","処理エラー \"{0}\" が発生しました。"},
{"R_requestedOpNotSupportedOnForward","要求された操作は、前方のみの ResultSet ではサポートされていません。"},
{"R_unsupportedCursor","このカーソルの種類はサポートされていません。"},
{"R_unsupportedCursorOperation","要求された操作は、このカーソルの種類ではサポートされていません。"},
{"R_unsupportedConcurrency","コンカレンシーはサポートされていません。"},
{"R_unsupportedCursorAndConcurrency","カーソルの種類とコンカレンシーの組み合わせはサポートされていません。"},
{"R_stringReadError","文字列の読み取りエラーがオフセット {0} で発生しました。"},
{"R_stringWriteError","文字列の書き込みエラーがオフセット {0} で発生しました。"},
{"R_stringNotInHex","文字列が有効な 16 進形式ではありません。"},
{"R_unknownType","Java の型 {0} はサポートされていません。"},
{"R_physicalConnectionIsClosed","プールされたこの接続の動的接続は閉じられています。"},
{"R_invalidDataSourceReference","DataSource 参照が無効です。"},
{"R_cantGetColumnValueFromDeletedRow","削除された行から値を取得することができません。"},
{"R_cantGetUpdatedColumnValue","updateRow() または cancelRowUpdates() が呼び出されるまで、更新された列にアクセスすることはできません。"},
{"R_cantUpdateColumn","列の値は更新できません。"},
{"R_positionedUpdatesNotSupported","位置指定更新と位置指定削除はサポートされていません。"},
{"R_invalidAutoGeneratedKeys","autoGeneratedKeys パラメーターの値 {0} が無効です。値に使用できるのは、Statement.RETURN_GENERATED_KEYS と Statement.NO_GENERATED_KEYS のみです。"},
{"R_notConfiguredForIntegrated","このドライバーは、統合認証を行えるようには構成されていません。"},
{"R_failoverPartnerWithoutDB","failoverPartner 接続プロパティを使用するときは databaseName が必要です。"},
{"R_invalidPartnerConfiguration","サーバー {1} のデータベース {0} は、データベース ミラーリングを行えるようには構成されていません。"},
{"R_invaliddisableStatementPooling","disableStatementPooling 値 {0} は無効です。"},
{"R_invalidselectMethod","selectMethod {0} は無効です。"},
{"R_invalidpropertyValue","接続プロパティのデータ型 {0} が無効です。この接続のすべてのプロパティの型は、String である必要があります。"},
{"R_invalidArgument","引数 {0} が無効です。"},
{"R_streamWasNotMarkedBefore","ストリームがマークされていません。"},
{"R_invalidresponseBuffering","responseBuffering 接続プロパティ {0} が無効です。"},
{"R_invalidapplicationIntent","applicationIntent 接続プロパティ {0} が無効です。"},
{"R_dataAlreadyAccessed","データがアクセスされましたが、この列またはパラメーターには使用できませんでした。"},
{"R_outParamsNotPermittedinBatch","OUT および INOUT パラメーターは、バッチ内では許可されていません。"},
{"R_sslRequiredNoServerSupport","ドライバーが SSL (Secure Sockets Layer) 暗号化による SQL Server への安全な接続を確立できませんでした。アプリケーションが暗号化を要求しましたが、サーバーが SSL をサポートするように構成されていませんでした。"},
{"R_sslRequiredByServer","SQL Server ログインには、SSL (Secure Sockets Layer) を使用する暗号化接続が必要です。"},
{"R_sslFailed","ドライバーが SSL (Secure Sockets Layer) 暗号化による SQL Server への安全な接続を確立できませんでした。エラー: \"{0}\"。"},
{"R_certNameFailed","SSL (Secure Sockets Layer) の初期化中に、証明書内のサーバー名の検証が失敗しました。"},
{"R_failedToInitializeXA","ストアド プロシージャ xp_sqljdbc_xa_init を初期化できませんでした。状態: {0}。エラー: \"{1}\""},
{"R_failedFunctionXA","関数 {0} が失敗しました。状態: {1}。エラー: \"{2}\""},
{"R_noTransactionCookie","関数 {0} が失敗しました。トランザクション Cookie は返されませんでした。"},
{"R_failedToEnlist","参加できませんでした。エラー: \"{0}\""},
{"R_failedToUnEnlist","参加解除できませんでした。エラー: \"{0}\""},
{"R_failedToReadRecoveryXIDs","復旧 XA 分岐トランザクション ID (XID) を読み取れませんでした。エラー: \"{0}\""},
{"R_userPropertyDescription","データベース ユーザーです。"},
{"R_passwordPropertyDescription","データベース パスワードです。"},
{"R_databaseNamePropertyDescription","接続先のデータベース名です。"},
{"R_domainPropertyDescription","NTLM を使用して認証する Windows ドメイン。"},
{"R_serverNamePropertyDescription","SQL Server を実行しているコンピューターです。"},
{"R_portNumberPropertyDescription","SQL Server のインスタンスがリッスンしている TCP ポートです。"},
{"R_serverSpnPropertyDescription","SQL Server SPN。"},
{"R_columnEncryptionSettingPropertyDescription","列の暗号化の設定。"},
{"R_serverNameAsACEPropertyDescription","RFC 3490 の ToASCII 操作で定義されているように、serverName を Unicode から ASCII Compatible Encoding (ACE) に変換します。"},
{"R_sendStringParametersAsUnicodePropertyDescription","サーバーに送信する文字列パラメーターを Unicode にするかデータベースの文字セットにするかを決定します。"},
{"R_multiSubnetFailoverPropertyDescription","アプリケーションが Availability Group Listener または Failover Cluster Instance の Availability Group に接続することを示します。"},
{"R_applicationNamePropertyDescription","SQL Server のプロファイリングおよびログ記録ツールのアプリケーション名です。"},
{"R_lastUpdateCountPropertyDescription","サーバーに渡される SQL ステートメントから最新の更新数のみが返されるようにします。"},
{"R_disableStatementPoolingPropertyDescription","ステートメント プーリング機能を無効にします。"},
{"R_integratedSecurityPropertyDescription","SQL Server への接続に Windows 認証が使用されるかどうかを示します。"},
{"R_authenticationSchemePropertyDescription","統合認証に使用される認証方法です。"},
{"R_lockTimeoutPropertyDescription","データベースがロック タイムアウトを報告するまでの待機時間 (ミリ秒単位) です。"},
{"R_loginTimeoutPropertyDescription","失敗した接続をドライバーがタイムアウトにするまでの待機時間 (秒単位) です。"},
{"R_instanceNamePropertyDescription","接続先の SQL Server インスタンス名です。"},
{"R_xopenStatesPropertyDescription","例外発生時にドライバーが XOPEN と互換性がある SQL 状態コードを返すかどうかを決定します。"},
{"R_selectMethodPropertyDescription","アプリケーションがサーバー カーソルを使用して、順方向専用で読み取り専用の結果セットを処理できるようにします。"},
{"R_responseBufferingPropertyDescription","適応型のバッファー動作を制御して、アプリケーションが大きな結果セットをサーバー カーソルなしで処理できるようにします。"},
{"R_applicationIntentPropertyDescription","アプリケーションがサーバーに接続するときのワークロードのタイプを宣言します。有効値は、ReadOnly および ReadWrite です。"},
{"R_workstationIDPropertyDescription","ワークステーションのホスト名です。"},
{"R_failoverPartnerPropertyDescription","データベース ミラーリング構成で使用されているフェールオーバー サーバーの名前です。"},
{"R_packetSizePropertyDescription","SQL Server との通信に使用されるネットワーク パケットのサイズです。"},
{"R_encryptPropertyDescription","クライアントとサーバーとの間で SSL (Secure Sockets Layer) 暗号化を使用する必要があるかどうかを決定します。"},
{"R_trustServerCertificatePropertyDescription","ドライバーが SQL Server SSL (Secure Sockets Layer) 証明書を検証する必要があるかどうかを決定します。"},
{"R_trustStoreTypePropertyDescription","KeyStore の種類です。"},
{"R_trustStorePropertyDescription","証明書 TrustStore ファイルへのパスです。"},
{"R_trustStorePasswordPropertyDescription","信頼ストア データの整合性の確認に使用されるパスワードです。"},
{"R_trustManagerClassPropertyDescription","SSL 接続用の TrustManager としてインスタンス化するクラスです。"},
{"R_trustManagerConstructorArgPropertyDescription","trustManagerClass で指定したコンストラクターに渡す省略可能な引数です。"},
{"R_hostNameInCertificatePropertyDescription","SQL Server SSL (Secure Sockets Layer) 証明書を検証するときに使用されるホスト名です。"},
{"R_sendTimeAsDatetimePropertyDescription","データベースへの java.sql.Time 値の送信に SQL Server datetime データ型を使用するかどうかを指定します。"},
{"R_TransparentNetworkIPResolutionPropertyDescription","透過型ネットワーク IP 解決の機能を使用するかどうかを決定します。"},
{"R_queryTimeoutPropertyDescription","データベースがクエリ タイムアウトを報告するまでの待機時間 (ミリ秒)。"},
{"R_socketTimeoutPropertyDescription","java.net.SocketTimeoutException が生成されるまでの待機時間 (ミリ秒)。"},
{"R_serverPreparedStatementDiscardThresholdPropertyDescription","サーバー上の破棄された PREPARE ステートメントを閉じる (sp_unprepares のバッチを呼び出すことによる) タイミングのしきい値。値が 1 以下の場合、PreparedStatment を閉じると直ちに sp_unprepare が呼び出されます。"},
{"R_enablePrepareOnFirstPreparedStatementCallPropertyDescription","この設定では、sp_executesql を最初に呼び出した後、準備されたステートメントを最初の使用時 (property=true) または 2 番目の使用時 (property=false) に準備する (sp_prepexec) かどうかを指定します。"},
{"R_statementPoolingCacheSizePropertyDescription","この設定は接続のために準備されたステートメント キャッシュのサイズを指定します。1 より小さい値である場合、キャッシュはありません。"},
{"R_gsscredentialPropertyDescription","SQL Server にアクセスするために偽装された GSS 資格情報。"},
{"R_msiClientIdPropertyDescription","Azure AD MSI 認証用のアクセス トークンの生成に使用される、ユーザー割り当てマネージド ID のクライアント ID"},
{"R_noParserSupport","必要なパーサーのインスタンス化中にエラーが発生しました。エラー: \"{0}\""},
{"R_writeOnlyXML","この SQLXML インスタンスからは読み取れません。このインスタンスは書き込みデータ専用です。"},
{"R_dataHasBeenReadXML","この SQLXML インスタンスからは読み取れません。データは既に読み取り済みです。"},
{"R_readOnlyXML","この SQLXML インスタンスには書き込めません。このインスタンスは読み取りデータ専用です。"},
{"R_dataHasBeenSetXML","この SQLXML インスタンスには書き込めません。データは既に設定済みです。"},
{"R_noDataXML","この SQLXML インスタンスにはデータが設定されていません。"},
{"R_cantSetNull","NULL 値を設定することはできません。"},
{"R_failedToParseXML","XML を解析できませんでした。エラー: \"{0}\""},
{"R_isFreed","この {0} オブジェクトは既に解放されています。アクセスすることはできません。"},
{"R_invalidProperty","このプロパティはサポートされていません: {0}。"},
{"R_referencingFailedTSP","DataSource trustStore パスワードを設定する必要があります。"},
{"R_valueOutOfRange","1 つ以上の値が、{0} SQL Server データ型の値範囲外にあります。"},
{"R_valueOutOfRangeSQLType","1 つ以上の値が、{0} SQL 型の値の範囲外にあります。"},
{"R_integratedAuthenticationFailed","統合認証に失敗しました。"},
{"R_permissionDenied","セキュリティ違反です。ターゲット \"{0}\" へのアクセス許可が拒否されました。"},
{"R_getSchemaError","既定のスキーマ名の取得でエラーが発生しました。"},
{"R_setSchemaWarning","警告: setSchema は、このドライバー バージョンでは no-op です。"},
{"R_updateCountOutofRange","更新回数の値が範囲外です。"},
{"R_limitOffsetNotSupported","limit エスケープ シーケンスでの OFFSET 句はサポートされません。"},
{"R_limitEscapeSyntaxError","limit エスケープ構文にエラーがあります。クエリの解析に失敗しました。"},
{"R_featureNotSupported","{0} はサポートされません。"},
{"R_zoneOffsetError","ゾーンのオフセットの取得でエラーが発生しました。"},
{"R_invalidMaxRows","結果セットでサポートされる最大行数は Integer.MAX_VALUE です。"},
{"R_schemaMismatch","ソースと変換先のスキーマが一致しません。"},
{"R_invalidColumn","列 {0} が無効です。列マッピングを確認してください。"},
{"R_invalidDestinationTable","変換先のテーブル名がないか、または無効です。"},
{"R_unableRetrieveColMeta","列のメタデータを取得できません。"},
{"R_invalidDestConnection","変換先の接続は、Microsoft JDBC Driver for SQL Server からの接続である必要があります。"},
{"R_unableRetrieveSourceData","ソースからデータを取得できません。"},
{"R_ParsingError","{0} 型のデータの解析に失敗しました。"},
{"R_BulkTypeNotSupported","データ型 {0} は一括コピーではサポートされません。"},
{"R_BulkTypeNotSupportedDW","データ型 {0} は、Azure Data Warehouse に対する一括コピーではサポートされません。"},
{"R_invalidTransactionOption","UseInternalTransaction オプションは、Connection オブジェクトと共に使用する場合、TRUE に設定することはできません。"},
{"R_invalidNegativeArg","{0} 引数は負の数にできません。"},
{"R_BulkColumnMappingsIsEmpty","唯一のマッピングが ID 列であり、KeepIdentity が false に設定されている場合、一括コピー操作は実行できません。"},
{"R_DataSchemaMismatch","ソース データがソース スキーマと一致しません。"},
{"R_BulkDataDuplicateColumn","重複する列名は使用できません。"},
{"R_invalidColumnOrdinal","列 {0} が無効です。列番号は 0 より大きい数である必要があります。"},
{"R_unsupportedEncoding","エンコード {0} はサポートされていません。"},
{"R_UnexpectedDescribeParamFormat","内部エラー。sp_describe_parameter_encryption によって返された resultset の形式が正しくありません。resultset のいずれかがありません。"},
{"R_InvalidEncryptionKeyOridnal","内部エラー。参照先の列暗号化キーの序数 \"{0}\" が sp_describe_parameter_encryption によって返される暗号化メタデータにありません。最大序数は \"{1}\" です。"},
{"R_MissingParamEncryptionMetadata","内部エラー。ステートメントまたはプロシージャ \"{0}\" の一部のパラメーターのメタデータが、sp_describe_parameter_encryption によって返される resultset にありません。"},
{"R_UnableRetrieveParameterMetadata","パラメーターの暗号化メタデータを取得できません。"},
{"R_InvalidCipherTextSize","指定した暗号化テキストの {0} バイトというサイズは正しくありません。解読に必要な最小の {1} バイトを下回っています。"},
{"R_InvalidAlgorithmVersion","指定した暗号化テキストの暗号化アルゴリズムのバージョン {0} が、必要な暗号化アルゴリズムのバージョン {1} と一致しません。"},
{"R_InvalidAuthenticationTag","指定した暗号化テキストには、正しくない認証タグがあります。 "},
{"R_EncryptionFailed","暗号化中の内部エラー: {0} "},
{"R_DecryptionFailed","解読中の内部エラー: {0} "},
{"R_InvalidKeySize","列暗号化キーは正常に解読されましたが、その長さ {0} がアルゴリズム \"{2}\" の長さ {1} と一致しません。データベース内の列暗号化キーの暗号化された値をご確認ください。"},
{"R_InvalidEncryptionType","データベースの列に指定された暗号化の種類 {0} は正しくないか、壊れています。アルゴリズム {1} の正しい暗号化の種類は {2} です。"},
{"R_UnknownColumnEncryptionAlgorithm","アルゴリズム {0} は存在しません。ファクトリに登録されたアルゴリズムは {1} です。"},
{"R_KeyExtractionFailed","キーの抽出に失敗しました: {0}。"},
{"R_UntrustedKeyPath","サーバー {1} から受信した列マスター キーのパス {0} は信頼済みのキーのパスではありません。列マスター キーのパスが壊れている可能性があるか、または SQLServerConnection.setColumnEncryptionTrustedMasterKeyPaths() を使用して信頼済みのキーのパスとして {0} を設定する必要があります。"},
{"R_UnrecognizedKeyStoreProviderName","列暗号化キーの解読に失敗しました。正しくないキー ストア プロバイダー名: {0}。キー ストア プロバイダー名は、システム キー ストア プロバイダーまたは登録済みのカスタム キー ストア プロバイダーである必要があります。正しいシステム キー プロバイダー名は {1} です。正しい (現在登録されている) カスタム キー ストア プロバイダー名は {2} です。データベースの列マスター キー定義内のキー ストア プロバイダー情報を確認して、アプリケーションで使用されているすべてのカスタム キー ストア プロバイダーが正しく登録されているかご確認ください。"},
{"R_UnsupportedDataTypeAE","データ型 {0} の暗号化と解読はサポートされていません。"},
{"R_NormalizationErrorAE","データ型 {0} の解読に失敗しました。正規化のエラー。"},
{"R_UnsupportedNormalizationVersionAE","SQL Server から受信した正規化バージョン \"{0}\" は正しくないか、壊れています。正しい正規化バージョンは {1} です。"},
{"R_NullCipherTextAE","内部エラー。Ciphertext 値を null にすることはできません。"},
{"R_NullColumnEncryptionAlgorithmAE","内部エラーです。暗号化アルゴリズムを null にすることはできません。正しいアルゴリズムは {1} です。"},
{"R_CustomCipherAlgorithmNotSupportedAE","カスタム暗号アルゴリズムはサポートされていません。"},
{"R_PlainTextNullAE","内部エラー。Plaintext 値を null にすることはできません。"},
{"R_StreamingDataTypeAE","{0} を超える長さのデータは、暗号化された {1} 列ではサポートされていません。"},
{"R_AE_NotSupportedByServer","使用中の SQL Server インスタンスは列暗号化をサポートしていません。"},
{"R_InvalidAEVersionNumber","Always Encrypted の正しくないバージョン番号 \"{0}\" を受け取りました。"},
{"R_NullEncryptedColumnEncryptionKey","内部エラー。暗号化された列暗号化キーを null にすることはできません。"},
{"R_EmptyEncryptedColumnEncryptionKey","内部エラー。指定した暗号化された列暗号化キーが空です。"},
{"R_InvalidMasterKeyDetails","指定したマスター キーの詳細が正しくありません。"},
{"R_CertificateError","キーストア \"{1}\" からの証明書 \"{0}\" の取得中にエラーが発生しました。"},
{"R_ByteToShortConversion","列暗号化キーの解読中にエラーが発生しました。"},
{"R_InvalidCertificateSignature","指定した暗号化された列暗号化キーの署名が、\"{0}\" の列マスター キー (証明書) で計算された署名と一致しません。暗号化された列暗号化キーが壊れているか、指定したパスが正しくない可能性があります。"},
{"R_CEKDecryptionFailed","暗号化された列暗号化キーの解読中の例外:  {0} "},
{"R_NullKeyEncryptionAlgorithm","キー暗号化アルゴリズムを null にすることはできません。"},
{"R_NullKeyEncryptionAlgorithmInternal","内部エラー。キー暗号化アルゴリズムを null にすることはできません。"},
{"R_InvalidKeyEncryptionAlgorithm","指定したキー暗号化アルゴリズム {0} が正しくありません。必要な値: {1}。"},
{"R_InvalidKeyEncryptionAlgorithmInternal","内部エラー。指定したキー暗号化アルゴリズム {0} が正しくありません。必要な値: {1}。"},
{"R_NullColumnEncryptionKey","列暗号化キーを null にすることはできません。"},
{"R_EmptyColumnEncryptionKey","指定した列暗号化キーが空です。"},
{"R_CertificateNotFoundForAlias","{1} によって提供されたストアにエイリアスが {0} の証明書が見つかりません。証明書が証明書の場所/ストアに正しくインポートされていることをご確認ください。"},
{"R_UnrecoverableKeyAE","証明書の詳細 {0} を使用してキーストアから秘密キーを回復できません。インポートされた Always Encrypted 用証明書に秘密キーが含まれていて、かつ証明書用に提供されたパスワードが正しいことをご確認ください。"},
{"R_KeyStoreNotFound","指定されたパスにキー ストア ファイルが見つかりません。パスが正しいことと、アクセスするための適切なアクセス許可があることをご確認ください。"},
{"R_CustomKeyStoreProviderMapNull","列暗号化キー ストア プロバイダーのマップを null にすることはできません。null 以外の値が必要です。"},
{"R_EmptyCustomKeyStoreProviderName","指定したキー ストア プロバイダー名が正しくありません。キー ストア プロバイダー名を null または空にすることはできません。"},
{"R_InvalidCustomKeyStoreProviderName","正しくないキー ストア プロバイダー名 {0}。{1} プレフィックスはシステムのキー ストア プロバイダー用に予約済みです。"},
{"R_CustomKeyStoreProviderValueNull","キー ストア プロバイダー {0} 用に指定された null 参照。null 以外の値が必要です。"},
{"R_CustomKeyStoreProviderSetOnce","キー ストア プロバイダーを 2 回以上設定することはできません。"},
{"R_unknownColumnEncryptionType","正しくない列暗号化の種類 {0}。"},
{"R_unsupportedStmtColEncSetting","SQLServerStatementColumnEncryptionSetting を null にすることはできません。"},
{"R_unsupportedConversionAE","{0} から {1} への変換は暗号化された列ではサポートされていません。"},
{"R_InvalidDataForAE","データ ソースから与えられた型 {0} の値を、指定された対象の列の {1} 型に変換することはできません。"},
{"R_authenticationPropertyDescription","使用する認証。"},
{"R_accessTokenPropertyDescription","Azure Active Directory に使うアクセス トークン。"},
{"R_FedAuthRequiredPreLoginResponseInvalidValue","サーバーが FedAuthRequired PreLogin オプションの予期しない値を送信しました。値は {0} でした。"},
{"R_FedAuthInfoLengthTooShortForCountOfInfoIds","FedAuthInfo トークンには、情報 ID の番号を示す少なくとも 4 バイトが必要です。"},
{"R_FedAuthInfoInvalidOffset","FedAuthInfoDataOffset が正しくない場所を指しています。現在の dataOffset は {0} です。"},
{"R_FedAuthInfoFailedToReadData","FedAuthInfoData を読み取ることができませんでした。"},
{"R_FedAuthInfoLengthTooShortForData","FEDAUTHINFO トークン ストリームの長さは、要求するデータを格納するには不十分です ({0})。"},
{"R_FedAuthInfoDoesNotContainStsurlAndSpn","FEDAUTHINFO トークン ストリームに STSURL と SPN の両方が含まれていません。"},
{"R_ADALExecution","Active Directory (Authentication={1}) でユーザー {0} の認証に失敗しました。"},
{"R_UnrequestedFeatureAckReceived","要求されていない機能の確認を受信します。機能 ID: {0}。"},
{"R_FedAuthFeatureAckContainsExtraData","ADAL と Security Token に対するフェデレーション認証の機能拡張の ACK に余分なデータが含まれています。"},
{"R_FedAuthFeatureAckUnknownLibraryType","不明なフェデレーション認証ライブラリを使用しようとしています。ライブラリ ID: {0}。"},
{"R_UnknownFeatureAck","不明な機能の確認を受信します。"},
{"R_SetAuthenticationWhenIntegratedSecurityTrue","\"IntegratedSecurity\" を \"true\" に設定して \"Authentication\" を設定することはできません。"},
{"R_NtlmNoUserPasswordDomain","NTLM 認証では、\"User\" (または \"UserName\") と \"Password\" 接続プロパティを指定する必要があります。"},
{"R_SetAccesstokenWhenIntegratedSecurityTrue","\"IntegratedSecurity\" 接続文字列のキーワードが \"true\" に設定されている場合は、AccessToken プロパティを設定することはできません。"},
{"R_IntegratedAuthenticationWithUserPassword","\"User\"、\"UserName\" または \"Password\" の接続文字列のキーワードと一緒に \"Authentication=ActiveDirectoryIntegrated\" を使用することはできません。"},
{"R_MSIAuthenticationWithUserPassword","\"User\"、\"UserName\" または \"Password\" の接続文字列のキーワードと一緒に \"Authentication=ActiveDirectoryMSI\" を使用することはできません。"},
{"R_AccessTokenWithUserPassword","\"User\"、\"UserName\" または \"Password\" が接続文字列に指定されている場合は、AccessToken プロパティを設定できません。"},
{"R_AccessTokenCannotBeEmpty","AccesToken を空にすることはできません。"},
{"R_SetBothAuthenticationAndAccessToken","\"Authentication\" が接続文字列に指定されている場合は、AccessToken プロパティを設定することはできません。"},
{"R_NoUserPasswordForActivePassword","\"Authentication=ActiveDirectoryPassword\" の場合は、\"User\" (または \"UserName\") と \"Password\" の接続文字列キーワードを両方とも指定する必要があります。"},
{"R_NoUserPasswordForSqlPassword","\"Authentication=SqlPassword\" の場合、\"User\" (または \"UserName\") と \"Password\" の接続文字列キーワードを両方とも指定する必要があります。"},
{"R_ForceEncryptionTrue_HonorAEFalse","ステートメントまたはプロシージャ {1} の暗号化が有効でないため、パラメーター {0} に対して Force Encryption を true に設定することはできません。"},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn","パラメーター {1} に対して Force Encryption が true に設定されていますが、データベースはこのパラメーターがプレーンテキストとして送信されると予期しているため、ステートメントまたはプロシージャ {0} を実行できません。これは構成エラーが原因である可能性があります。"},
{"R_ForceEncryptionTrue_HonorAEFalseRS","ステートメントまたはプロシージャの暗号化が有効でないため、パラメーター {0} に対して Force Encryption を true に設定することはできません。"},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS","パラメーター {0} に対して Force Encryption が true に設定されていますが、データベースはこのパラメーターがプレーンテキストとして送信されると予期しているため、更新プログラムを実行できません。これは構成エラーが原因である可能性があります。"},
{"R_NullValue","{0} を null にすることはできません。"},
{"R_AKVPathNull","Azure Key Vault キーのパスを null にすることはできません。"},
{"R_AKVURLInvalid","指定した URL {0} が無効です。"},
{"R_AKVMasterKeyPathInvalid","指定した Azure Key Vault キーのパス {0} が正しくありません。"},
{"R_EmptyCEK","指定した列暗号化キーが空です。"},
{"R_EncryptedCEKNull","暗号化された列暗号化キーを null にすることはできません。"},
{"R_EmptyEncryptedCEK","暗号化された列暗号化キーの長さを 0 にすることはできません。"},
{"R_NonRSAKey","RSA 以外のキー {0} を使用することはできません。"},
{"R_GetAKVKeySize","Azure Key Vault 公開キーのサイズ (バイト単位) を取得できません。"},
{"R_InvalidEcryptionAlgorithmVersion","指定した暗号化された列暗号化キーに、正しくない暗号化アルゴリズムのバージョン {0} が含まれています。必要なバージョンは {1} です。"},
{"R_AKVKeyLengthError","指定した暗号化された列暗号化キーの ciphertext の長さ {0} が、{2} で列マスター キー (Azure Key Vault キー) を使用している時の ciphertext の長さ {1} と一致しません。暗号化された列暗号化キーが壊れているか、指定した Azure Key Vault キーのパスが正しくない可能性があります。"},
{"R_AKVSignatureLengthError","指定した暗号化された列暗号化キーの署名の長さ {0} が、{2} で列マスター キー (Azure Key Vault キー) を使用している時の署名の長さ {1} と一致しません。暗号化された列暗号化キーが壊れているか、指定した Azure Key Vault キーのパスが正しくない可能性があります。"},
{"R_HashNull","暗号化された列暗号化キーの解読中は、ハッシュは null であってはなりません。"},
{"R_NoSHA256Algorithm","SHA-256 アルゴリズムはサポートされていません。"},
{"R_VerifySignature","列暗号化キーの署名を確認できません。"},
{"R_CEKSignatureNotMatchCMK","指定した暗号化された列暗号化キーの署名が、{0} の列マスター キー (Azure Key Vault の非対称キー) で計算された署名と一致しません。暗号化された列暗号化キーが壊れているか、指定したパスが正しくない可能性があります。"},
{"R_DecryptCEKError","指定した Azure Key Vault キーを使用して列暗号化キーを解読できません。"},
{"R_EncryptCEKError","指定した Azure Key Vault キーを使用して列暗号化キーを暗号化できません。"},
{"R_CipherTextLengthNotMatchRSASize","CipherText の長さが RSA キーのサイズと一致しません。"},
{"R_GenerateSignature","指定した Azure Key Vault キーの URL を使用して署名を生成できません。"},
{"R_SignedHashLengthError","署名済みハッシュの長さが RSA キーのサイズと一致しません。"},
{"R_InvalidSignatureComputed","計算された暗号化済みの列暗号化キーの署名が正しくありません。"},
{"R_UnableLoadADALSqlDll","adalsql.dll を読み込むことができません。エラー コード: 0x{0}。詳細については、次をご覧ください。http://go.microsoft.com/fwlink/?LinkID=513072"},
{"R_ADALAuthenticationMiddleErrorMessage","エラー コード 0x{0}; 状態 {1}。"},
{"R_unsupportedDataTypeTVP","データ型 {0} は Table-Valued Parameter ではサポートされていません。"},
{"R_moreDataInRowThanColumnInTVP","入力アレイの長さがこのテーブルの列数を超えています。"},
{"R_invalidTVPName"," Table-Valued Parameter には正しい型名が必要です。"},
{"R_invalidThreePartName","TypeName の 3 部構成の名前形式が正しくありません。"},
{"R_unsupportedConversionTVP","{0} から {1} への変換は Table-Valued Parameter ではサポートされていません。"},
{"R_TVPMixedSource","列のメタデータを追加できません。この Table-Valued Parameter には、メタデータの派生元の ResultSet があります。"},
{"R_TVPEmptyMetadata","Structured 型に十分なフィールドがありません。Structured 型には、少なくとも 1 つのフィールドが必要です。"},
{"R_TVPInvalidValue","Table-Valued Parameter {0} に提供された値が正しくありません。サポートされるのは SQLServerDataTable、ResultSet、ISQLServerDataRecord オブジェクトのみです。"},
{"R_TVPInvalidColumnValue","入力データの形式が正しくありません。"},
{"R_TVPSortOrdinalGreaterThanFieldCount","フィールド {1} の並べ替えの序数 {0} がフィールドの総数を超えています。"},
{"R_TVPMissingSortOrderOrOrdinal","並べ替え順序と序数は、両方指定するか、どちらも指定しないようにする (SortOrder.Unspecified と -1 にする) 必要があります。指定された値: 順序 = {0}、序数 = {1}。"},
{"R_TVPDuplicateSortOrdinal","並べ替えの序数 {0} が 2 回指定されました。"},
{"R_TVPMissingSortOrdinal","並べ替えの序数 {0} が指定されませんでした。"},
{"R_TVPDuplicateColumnName","列名 {0} は既にこの SQLServerDataTable に属しています。"},
{"R_InvalidConnectionSetting","{0} 値 \"{1}\" は正しくありません。"},
{"R_InvalidWindowsCertificateStoreEncryption","Windows Certificate Store で列暗号化キーを暗号化できません。"},
{"R_AEKeypathEmpty","内部エラー。証明書のパスを null にすることはできません。\"証明書の場所/証明書ストア/証明書の拇印\" の形式を使用します。ここで \"証明書の場所\" は LocalMachine または CurrentUser のいずれかです。"},
{"R_AEWinApiErr","Windows API ネイティブ エラー。"},
{"R_AECertpathBad","内部エラー。証明書のパス {0} が正しくありません。\"証明書の場所/証明書ストア/証明書の拇印\" の形式を使用します。ここで \"証明書の場所\" は LocalMachine または CurrentUser のいずれかです。"},
{"R_AECertLocBad","内部エラー。証明書のパス {1} の証明書の場所 {0} が正しくありません。\"証明書の場所/証明書ストア/証明書の拇印\" の形式を使用します。ここで \"証明書の場所\" は LocalMachine または CurrentUser のいずれかです。"},
{"R_AECertStoreBad","内部エラー。証明書のパス {1} に指定されている証明書ストア {0} が正しくありません。必要な値: My。"},
{"R_AECertHashEmpty","内部エラー。証明書のパス {0} で指定した証明書の拇印が空です。"},
{"R_AECertNotFound","拇印 {2} を含む証明書が、証明書の場所 {0} の証明書ストア {1} に見つかりません。データベース内の列マスター キー定義の証明書パスが正しく、かつ証明書が証明書の場所/ストアに正しくインポートされていることをご確認ください。"},
{"R_AEMaloc","メモリの割り当てエラー。"},
{"R_AEKeypathLong","内部エラー。指定した証明書のパスの長さは {0} バイトです。これは最大の長さ {1} バイトを超えています。"},
{"R_AEECEKLenBad","指定した暗号化された列暗号化キーの ciphertext の長さ {0} が、\"{2}\" で列マスター キー (証明書) を使用している時の ciphertext の長さ {1} と一致しません。暗号化された列暗号化キーが壊れているか、指定した証明書のパスが正しくない可能性があります。"},
{"R_AEECEKSigLenBad","指定した暗号化された列暗号化キーの署名の長さ {0} が、{2} で列マスター キー (証明書) を使用している時の長さ {1} と一致しません。暗号化された列暗号化キーが壊れているか、指定した証明書のパスが正しくない可能性があります。"},
{"R_AEKeyPathEmptyOrReserved","証明書のパス \"{0}\" が正しくありません。空であるか、予約済みのディレクトリ名が含まれています。"},
{"R_AEKeyPathCurUser","CurrentUser がキーのパスに指定されましたが、現在のユーザーの初期の作業ディレクトリを取得中にエラーが発生しました。"},
{"R_AEKeyFileOpenError","証明書ファイル {0} を開くときにエラーが発生しました。"},
{"R_AEKeyFileReadError","証明書ファイル {0} の読み取りエラーです。"},
{"R_keyStoreAuthenticationPropertyDescription","キー ストアを識別する名前。"},
{"R_keyStoreSecretPropertyDescription","認証シークレット、またはシークレットの検索に必要な情報。"},
{"R_keyStoreLocationPropertyDescription","キー ストアの場所。"},
{"R_keyStoreAuthenticationNotSet","\"{0}\" が指定されている場合は、\"keyStoreAuthentication\" 接続文字列キーワードを指定する必要があります。"},
{"R_keyStoreSecretOrLocationNotSet","\"keyStoreAuthentication=JavaKeyStorePassword\" が接続文字列で指定されている場合、\"keyStoreSecret\" と \"keyStoreLocation\" の両方を設定する必要があります。"},
{"R_certificateStoreInvalidKeyword","\"keyStoreAuthentication=CertificateStore\" が接続文字列で指定されている場合、\"keyStoreSecret\" を設定できません。"},
{"R_certificateStoreLocationNotSet","\"keyStoreAuthentication=CertificateStore\" が接続文字列で指定されている場合、\"keyStoreLocation\" を指定する必要があります。"},
{"R_certificateStorePlatformInvalid","Windows オペレーティング システムでは \"keyStoreAuthentication=CertificateStore\" を設定することはできません。"},
{"R_invalidKeyStoreFile","\"{0}\" を解析できません。ファイル形式が正しくないか、パスワードが正しくありません。"},
{"R_invalidCEKCacheTtl","無効な列暗号化キー キャッシュの有効時間が指定されました。columnEncryptionKeyCacheTtl を負の値にすることはできません。timeUnit に指定できるのは、DAYS、HOURS、MINUTES、SECONDS のみです。"},
{"R_sendTimeAsDateTimeForAE","Always Encrypted で sendTimeAsDateTime=false を使用します。"},
{"R_TVPnotWorkWithSetObjectResultSet","ResultSet を含む setObject() はテーブル値パラメーターではサポートされていません。setStructured() を使用してください。"},
{"R_invalidQueryTimeout","queryTimeout {0} が無効です。"},
{"R_invalidSocketTimeout","socketTimeout {0} が無効です。"},
{"R_fipsPropertyDescription","FIPS モードを有効にするかどうかを決定します。"},
{"R_invalidFipsConfig","FIPS モードの設定を確認できません。"},
{"R_serverPreparedStatementDiscardThreshold","serverPreparedStatementDiscardThreshold {0} が無効です。"},
{"R_statementPoolingCacheSize","statementPoolingCacheSize {0} は無効です。"},
{"R_kerberosLoginFailedForUsername","Kerberos プリンシパル {0} でログインできません。資格情報を確認してください。{1}"},
{"R_kerberosLoginFailed","{1} ({2}) のため、Kerberos ログインに失敗しました: {0}"},
{"R_StoredProcedureNotFound","ストアド プロシージャ ''''{0}'''' が見つかりませんでした。"},
{"R_jaasConfigurationNamePropertyDescription","Kerberos 認証のログイン構成ファイル。"},
{"R_AKVKeyNotFound","キーが見つかりません: {0}"},
{"R_SQLVariantSupport","SQL_VARIANT は、SQL Server の 2008 より前のバージョンではサポートされていません。"},
{"R_invalidProbbytes","SQL_VARIANT: {0} 型では無効な probBytes です。"},
{"R_invalidStringValue","SQL_VARIANT は 8000 を超える長さの文字列値をサポートしていません。"},
{"R_invalidValueForTVPWithSQLVariant","null 値の sql_variant 列が含まれる TVP の使用はサポートされていません。"},
{"R_invalidDataTypeSupportForSQLVariant","SQL_VARIANT で TDS の型 ''''{0}'''' は予期されていませんでした。"},
{"R_sslProtocolPropertyDescription","TLSv1、TLS、TLSv1.1、TLSv1.2 の SSL プロトコル ラベルです。既定値は、TLS です。"},
{"R_invalidSSLProtocol","SSL プロトコル {0} ラベルが無効です。サポートされているのは、TLS、TLSv1、TLSv1.1、TLSv1.2 のみです。"},
{"R_cancelQueryTimeoutPropertyDescription","クエリ タイムアウトの送信をキャンセルするまでの待機時間 (秒数)。"},
{"R_invalidCancelQueryTimeout","キャンセルのタイムアウト値 {0} は無効です。"},
{"R_useBulkCopyForBatchInsertPropertyDescription","ドライバーがバッチ挿入の操作に一括コピー API を使用するかどうか"},
{"R_UnknownDataClsTokenNumber","データ分類の不明なトークン。"},
{"R_InvalidDataClsVersionNumber","データ分類の無効なバージョン番号 {0}。"},
{"R_unknownUTF8SupportValue","UTF8 サポートの不明な値。"},
{"R_illegalWKT","無効な Well-Known Text です。Well-Known Text が有効であることをご確認ください。"},
{"R_illegalTypeForGeometry","{0} は Geometry でサポートされていません。"},
{"R_illegalWKTposition","位置 {0} の Well-Known Text の無効な文字。"},
{"R_keyVaultProviderClientIdPropertyDescription","列暗号化マスター キーが格納されている Key Vault へのアクセスに使用するクライアント ID。"},
{"R_keyVaultProviderClientKeyPropertyDescription","列暗号化マスター キーが格納されている Key Vault へのアクセスに使用するクライアント キー。"},
{"R_ADALMissing","{0} 認証を実行するための ADAL4J Java ライブラリの読み込みに失敗しました。"},
{"R_DLLandADALMissing","{0} 認証を実行するための sqljdbc_auth.dll と ADAL4J Java ライブラリ両方の読み込みに失敗しました。どちらか 1 つをインストールして続行してください。"},
{"R_MSITokenFailureImds","MSI トークン エラー: IMDS からのアクセス トークンの取得に失敗しました"},
{"R_MSITokenFailureImdsClientId","MSI トークン エラー: IMDS からのアクセス トークンの取得に失敗しました。クライアント ID を確認してください。"},
{"R_MSITokenFailureUnexpected","MSI トークン エラー: IMDS からのアクセス トークンの取得に失敗しました。予期しないエラーが発生しました。"},
{"R_MSITokenFailureEndpoint","MSI トークン エラー: MSI エンドポイントからのトークンの取得に失敗しました"},
{"R_propertyNotSupported","Microsoft JDBC Driver for SQL Server は現在、このプロパティをサポートしていません: {0}"},
{"R_ntlmHmacMD5Error","NTLM 認証を初期化できません: HMAC-MD5 初期化エラー。"},
{"R_ntlmSignatureError","NTLM チャレンジ メッセージ署名エラー: {0}"},
{"R_ntlmMessageTypeError","NTLM チャレンジ メッセージ タイプ エラー: {0}"},
{"R_ntlmAuthenticateError","認証メッセージの構築中に NTLM エラーが発生しました: {0}"},
{"R_ntlmNoTargetInfo","NTLM チャレンジ メッセージに TargetInfo がありません。"},
{"R_ntlmUnknownValue","NTLM チャレンジ メッセージ TargetInfo エラー: 不明な値 \"{0}\""},
{"R_useFmtOnlyPropertyDescription","パラメーター メタデータを取得する SET FMTONLY の使用を有効にするか無効にするかを決定します。"},
{"R_invalidOpenqueryCall","無効な構文: OPENQUERY/OPENJSON/OPENDATASOURCE/OPENROWSET/OPENXML の前には丸かっこが必要です"},
{"R_invalidCTEFormat","無効な構文: AS の後には、共通テーブル式の丸かっこを指定する必要があります。"},
{"R_noTokensFoundInUserQuery","無効なクエリ: 指定された SQL から解析されたトークンはありません。"},
{"R_invalidUserSQL","ユーザー SQL を解析しようとしてエラーが発生しました。SQL 構文を確認してください。"},
{"R_invalidInsertValuesQuery","VALUES リストをテーブルの列と照合するときにエラーが発生しました。SQL 構文を確認してください。"},
{"R_invalidValuesList","VALUES リストの読み取り中にエラーが発生しました。SQL 構文を確認してください。"},
};
}
