/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolProxy;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class SQLServerPooledConnection
implements PooledConnection {
    private final Vector<ConnectionEventListener> listeners = new Vector();
    private SQLServerDataSource factoryDataSource;
    private SQLServerConnection physicalConnection;
    private SQLServerConnectionPoolProxy lastProxyConnection;
    private String factoryUser;
    private String factoryPassword;
    private Logger pcLogger = SQLServerDataSource.dsLogger;
    private static final AtomicInteger basePooledConnectionID = new AtomicInteger(0);
    private final String traceID;

    SQLServerPooledConnection(SQLServerDataSource ds, String user, String password) throws SQLException {
        this.factoryDataSource = ds;
        this.factoryUser = user;
        this.factoryPassword = password;
        if (this.pcLogger.isLoggable(Level.FINER)) {
            this.pcLogger.finer(this.toString() + " Start create new connection for pool.");
        }
        this.physicalConnection = this.createNewConnection();
        String nameL = this.getClass().getName();
        this.traceID = nameL.substring(1 + nameL.lastIndexOf(46)) + ":" + SQLServerPooledConnection.nextPooledConnectionID();
        if (this.pcLogger.isLoggable(Level.FINE)) {
            this.pcLogger.fine(this.toString() + " created by (" + ds.toString() + ") Physical connection " + this.safeCID() + ", End create new connection for pool");
        }
    }

    public String toString() {
        return this.traceID;
    }

    private SQLServerConnection createNewConnection() throws SQLException {
        return this.factoryDataSource.getConnectionInternal(this.factoryUser, this.factoryPassword, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.pcLogger.isLoggable(Level.FINER)) {
            this.pcLogger.finer(this.toString() + " user:(default).");
        }
        SQLServerPooledConnection sQLServerPooledConnection = this;
        synchronized (sQLServerPooledConnection) {
            if (this.physicalConnection == null) {
                SQLServerException.makeFromDriverError(null, this, SQLServerException.getErrString("R_physicalConnectionIsClosed"), "", true);
            }
            this.physicalConnection.doSecurityCheck();
            if (this.pcLogger.isLoggable(Level.FINE)) {
                this.pcLogger.fine(this.toString() + " Physical connection, " + this.safeCID());
            }
            if (null != this.physicalConnection.getAuthenticationResult() && Util.checkIfNeedNewAccessToken(this.physicalConnection)) {
                this.physicalConnection = this.createNewConnection();
            }
            if (null != this.lastProxyConnection) {
                this.physicalConnection.resetPooledConnection();
                if (this.pcLogger.isLoggable(Level.FINE) && !this.lastProxyConnection.isClosed()) {
                    this.pcLogger.fine(this.toString() + "proxy " + this.lastProxyConnection.toString() + " is not closed before getting the connection.");
                }
                this.lastProxyConnection.internalClose();
            }
            this.lastProxyConnection = new SQLServerConnectionPoolProxy(this.physicalConnection);
            if (this.pcLogger.isLoggable(Level.FINE) && !this.lastProxyConnection.isClosed()) {
                this.pcLogger.fine(this.toString() + " proxy " + this.lastProxyConnection.toString() + " is returned.");
            }
            return this.lastProxyConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEvent(SQLServerException e) {
        Object object;
        if (this.pcLogger.isLoggable(Level.FINER)) {
            this.pcLogger.finer(this.toString() + " Exception:" + e + this.safeCID());
        }
        if (null != e) {
            object = this;
            synchronized (object) {
                if (null != this.lastProxyConnection) {
                    this.lastProxyConnection.internalClose();
                    this.lastProxyConnection = null;
                }
            }
        }
        object = this.listeners;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener listener = this.listeners.elementAt(i);
                if (listener == null) continue;
                ConnectionEvent ev = new ConnectionEvent(this, e);
                if (null == e) {
                    if (this.pcLogger.isLoggable(Level.FINER)) {
                        this.pcLogger.finer(this.toString() + " notifyEvent:connectionClosed " + this.safeCID());
                    }
                    listener.connectionClosed(ev);
                    continue;
                }
                if (this.pcLogger.isLoggable(Level.FINER)) {
                    this.pcLogger.finer(this.toString() + " notifyEvent:connectionErrorOccurred " + this.safeCID());
                }
                listener.connectionErrorOccurred(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.pcLogger.isLoggable(Level.FINER)) {
            this.pcLogger.finer(this.toString() + this.safeCID());
        }
        Vector<ConnectionEventListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.pcLogger.isLoggable(Level.FINER)) {
            this.pcLogger.finer(this.toString() + " Closing physical connection, " + this.safeCID());
        }
        Object object = this;
        synchronized (object) {
            if (null != this.lastProxyConnection) {
                this.lastProxyConnection.internalClose();
            }
            if (null != this.physicalConnection) {
                this.physicalConnection.DetachFromPool();
                this.physicalConnection.close();
            }
            this.physicalConnection = null;
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.pcLogger.isLoggable(Level.FINER)) {
            this.pcLogger.finer(this.toString() + this.safeCID());
        }
        Vector<ConnectionEventListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new UnsupportedOperationException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new UnsupportedOperationException(SQLServerException.getErrString("R_notSupported"));
    }

    SQLServerConnection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private static int nextPooledConnectionID() {
        return basePooledConnectionID.incrementAndGet();
    }

    private String safeCID() {
        if (null == this.physicalConnection) {
            return " ConnectionID:(null)";
        }
        return this.physicalConnection.toString();
    }
}

