package com.microsoft.sqlserver.jdbc;
import java.util.*;
public final class SQLServerResource_pt_BR extends ListResourceBundle
				  {
protected Object[][]  getContents()
{
return contents;
}


static final Object[][] contents =
{
{"R_timedOutBeforeRouting","O tempo limite expirou antes de conectar ao destino de roteamento."},
{"R_invalidRoutingInfo","Informações inesperadas de roteamento recebidas. Verifique as propriedades de conexão e a configuração do SQL Server."},
{"R_multipleRedirections","Dois ou mais redirecionamentos ocorreram. É permitido somente um redirecionamento por logon."},
{"R_dbMirroringWithMultiSubnetFailover","Não há suporte para a conexão de uma instância espelhada do SQL Server que usa a propriedade de conexão multiSubnetFailover."},
{"R_dbMirroringWithReadOnlyIntent","Não há suporte para a conexão de uma instância espelhada do SQL Server que usa a propriedade de conexão ApplicationIntent ReadOnly."},
{"R_ipAddressLimitWithMultiSubnetFailover","Não há suporte para a conexão da propriedade de conexão multiSubnetFailover a uma instância do SQL Server configurada com mais de {0} endereços IP."},
{"R_connectionTimedOut","Tempo limite da conexão expirado: não há informações adicionais."},
{"R_invalidPositionIndex","O índice de posição {0} não é válido."},
{"R_invalidLength","O comprimento {0} não é válido."},
{"R_unknownSSType","Tipo de dados SQL Server {0} inválido."},
{"R_unknownJDBCType","Tipo de dados JDBC {0} inválido."},
{"R_notSQLServer","O driver recebeu uma resposta de pré-logon inesperada. Verifique as propriedades da conexão, se uma instância do SQL Server está sendo executada no host e se está aceitando conexões TCP/IP na porta. Esse driver pode ser usado somente com o SQL Server 2005 ou posterior."},
{"R_tcpOpenFailed","{0}. Verifique as propriedades da conexão. Verifique se uma instância do SQL Server está sendo executada no host e se está aceitando conexões TCP/IP na porta. Verifique se as conexões TCP na porta não foram bloqueadas por um firewall."},
{"R_unsupportedServerVersion","O SQL Server versão {0} não tem suporte nesse driver."},
{"R_noServerResponse","O SQL Server não retornou uma resposta. A conexão foi fechada."},
{"R_truncatedServerResponse","O SQL Server retornou uma resposta incompleta. A conexão foi fechada."},
{"R_queryTimedOut","O tempo limite da consulta foi atingido."},
{"R_queryCanceled","A consulta foi cancelada."},
{"R_errorReadingStream","Erro ao ler o valor do objeto de fluxo. Erro: \"{0}\""},
{"R_read","A operação de leitura do fluxo retornou um valor inválido para a quantidade de dados lidos."},
{"R_streamReadReturnedInvalidValue","A operação de leitura do fluxo retornou um valor inválido para a quantidade de dados lidos."},
{"R_mismatchedStreamLength","O valor do fluxo não é o comprimento especificado. O comprimento especificado era {0} e o real é {1}."},
{"R_notSupported","Essa operação não tem suporte."},
{"R_invalidOutputParameter","O índice {0} do parâmetro de saída não é válido."},
{"R_outputParameterNotRegisteredForOutput","O parâmetro de saída {0} não foi registrado para saída."},
{"R_parameterNotDefinedForProcedure","O parâmetro {0} não foi definido para o procedimento armazenado {1}."},
{"R_connectionIsClosed","A conexão está fechada."},
{"R_invalidBooleanValue","A propriedade {0} não contém um valor booliano válido. Apenas true ou false podem ser usados."},
{"R_propertyMaximumExceedsChars","A propriedade {0} excede o número máximo de {1} caracteres."},
{"R_invalidPortNumber","O número de porta {0} não é válido."},
{"R_invalidTimeOut","O timeout {0} não é válido."},
{"R_invalidLockTimeOut","O lockTimeOut {0} não é válido."},
{"R_invalidAuthenticationScheme","authenticationScheme {0} não é válido."},
{"R_invalidPacketSize","O packetSize {0} não é válido."},
{"R_packetSizeTooBigForSSL","A criptografia SSL não pode ser usada com um tamanho de pacote de rede maior que {0} bytes. Verifique as propriedades da conexão e a configuração do SQL Server."},
{"R_redirectedFrom","{0} (redirecionado de {1})"},
{"R_tcpipConnectionFailed","Falha na conexão TCP/IP com o host {0}, porta {1}. Erro: \"{2}\"."},
{"R_invalidTransactionLevel","O nível de transação {0} não é válido."},
{"R_cantInvokeRollback","Não é possível chamar uma operação de reversão quando o modo AutoCommit está definido como \"true\"."},
{"R_cantSetSavepoint","Não é possível definir um ponto de salvamento quando o modo AutoCommit está definido como \"true\"."},
{"R_sqlServerHoldability","O SQL Server dá suporte à suspensão apenas no nível de conexão. Use o método connection.setHoldability()."},
{"R_invalidHoldability","O valor de suspensão {0} não é válido."},
{"R_invalidColumnArrayLength","A matriz de colunas não é válida. Seu comprimento deve ser 1."},
{"R_valueNotSetForParameter","O valor não está definido para o número de parâmetro {0}."},
{"R_sqlBrowserFailed","Falha na conexão com o host {0} e a instância nomeada {1}. Erro: \"{2}\". Verifique os nomes do servidor e da instância e confira se não há nenhum firewall bloqueando o tráfego de UDP para a porta 1434. Para o SQL Server 2005 ou posterior, verifique se o Serviço SQL Server Browser está em execução no host."},
{"R_notConfiguredToListentcpip","O servidor {0} não está configurado para ouvir com TCP/IP."},
{"R_cantIdentifyTableMetadata","Não é possível identificar a tabela {0} para os metadados."},
{"R_metaDataErrorForParameter","Erro de metadados para o parâmetro {0}."},
{"R_invalidParameterNumber","O número de parâmetro {0} não é válido."},
{"R_noMetadata","Não há metadados."},
{"R_resultsetClosed","O conjunto de resultados está fechado."},
{"R_transactionsNotSupported","'@@TRANCOUNT' não tem suporte."},
{"R_invalidColumnName","O nome de coluna {0} não é válido."},
{"R_resultsetNotUpdatable","O conjunto de resultados não é atualizável."},
{"R_indexOutOfRange","O índice {0} está fora do intervalo."},
{"R_savepointNotNamed","O savepoint não foi nomeado."},
{"R_savepointNamed","O savepoint {0} está nomeado."},
{"R_resultsetNoCurrentRow","O conjunto de resultados não tem linha atual."},
{"R_mustBeOnInsertRow","O cursor não está na linha de inserção."},
{"R_mustNotBeOnInsertRow","A operação solicitada não é válida na linha de inserção."},
{"R_cantUpdateDeletedRow","Uma linha excluída não pode ser atualizada."},
{"R_noResultset","A instrução não retornou um conjunto de resultados."},
{"R_resultsetGeneratedForUpdate","Um conjunto de resultados foi gerado para atualização."},
{"R_statementIsClosed","A instrução está fechada."},
{"R_invalidRowcount","A contagem máxima de linhas {0} para um conjunto de resultados deve ser não negativa."},
{"R_invalidQueryTimeOutValue","O valor de tempo limite da consulta {0} não é válido."},
{"R_invalidFetchDirection","A direção de busca {0} não é válida."},
{"R_invalidFetchSize","O tamanho da busca não pode ser negativo."},
{"R_noColumnParameterValue","Nenhum valor de parâmetro de coluna foi especificado para atualizar a linha."},
{"R_statementMustBeExecuted","A instrução deve ser executada antes que qualquer resultado seja obtido."},
{"R_modeSuppliedNotValid","O modo fornecido não é válido."},
{"R_errorConnectionString","A cadeia de conexão contém um nome ou valor formado incorretamente."},
{"R_errorServerName","O valor da propriedade de conexão serverName {0} está mal formado."},
{"R_errorProcessingComplexQuery","Erro ao processar a consulta complexa."},
{"R_invalidOffset","O deslocamento {0} não é válido."},
{"R_nullConnection","A URL de conexão é nula."},
{"R_invalidConnection","A URL de conexão é inválida."},
{"R_cannotTakeArgumentsPreparedOrCallable","O método {0} não pode ter argumentos em uma PreparedStatement ou CallableStatement."},
{"R_unsupportedConversionFromTo","A conversão de {0} em {1} não tem suporte."},
{"R_unsupportedConversionTo","A conversão para {0} não é compatível."},
{"R_errorConvertingValue","Erro ao converter o valor {0} em tipo de dados JDBC {1}."},
{"R_streamIsClosed","O fluxo está fechado."},
{"R_invalidTDS","O fluxo do protocolo TDS não é válido."},
{"R_unexpectedToken"," Token inesperado {0}."},
{"R_selectNotPermittedinBatch","A instrução SELECT não é permitida em um lote."},
{"R_failedToCreateXAConnection","Falha ao criar a conexão do controle XA. Erro: \"{0}\""},
{"R_codePageNotSupported","A página de código {0} não tem suporte no ambiente Java."},
{"R_unknownSortId","A ordenação {0} do SQL Server não tem suporte nesse driver."},
{"R_unknownLCID","A ordenação {0} do Windows não tem suporte nesse driver."},
{"R_encodingErrorWritingTDS","Erro de codificação ao gravar uma cadeia de caracteres no buffer TDS. Erro: \"{0}\""},
{"R_processingError","Erro de processamento \"{0}\"."},
{"R_requestedOpNotSupportedOnForward","A operação solicitada não tem suporte em conjuntos de resultados somente de encaminhamento."},
{"R_unsupportedCursor","Tipo de cursor sem suporte."},
{"R_unsupportedCursorOperation","A operação solicitada não tem suporte com esse tipo de cursor."},
{"R_unsupportedConcurrency","A simultaneidade não tem suporte."},
{"R_unsupportedCursorAndConcurrency","A combinação de tipo/simultaneidade do cursor não tem suporte."},
{"R_stringReadError","Erro de leitura de cadeia de caracteres no deslocamento:{0}."},
{"R_stringWriteError","Erro de gravação de uma cadeia de caracteres no deslocamento:{0}."},
{"R_stringNotInHex","O formato hexadecimal da cadeia de caracteres não é válido."},
{"R_unknownType","O tipo Java {0} não tem suporte."},
{"R_physicalConnectionIsClosed","A conexão física está fechada para essa conexão em pool."},
{"R_invalidDataSourceReference","Referência a DataSource inválida."},
{"R_cantGetColumnValueFromDeletedRow","Não é possível obter um valor de uma linha excluída."},
{"R_cantGetUpdatedColumnValue","Não é possível acessar as colunas atualizadas até que updateRow() ou cancelRowUpdates() seja chamado."},
{"R_cantUpdateColumn","O valor da coluna não pode ser atualizado."},
{"R_positionedUpdatesNotSupported","Não há suporte para atualizações e exclusões posicionadas."},
{"R_invalidAutoGeneratedKeys","O valor do parâmetro autoGeneratedKeys {0} não é válido. Somente os valores Statement.RETURN_GENERATED_KEYS e Statement.NO_GENERATED_KEYS podem ser usados."},
{"R_notConfiguredForIntegrated","Esse driver não está configurado para autenticação integrada."},
{"R_failoverPartnerWithoutDB","databaseName é necessário ao usar a propriedade de conexão failoverPartner."},
{"R_invalidPartnerConfiguration","O banco de dados {0} no servidor {1} não está configurado para espelhamento de banco de dados."},
{"R_invaliddisableStatementPooling","O valor de disableStatementPooling {0} não é válido."},
{"R_invalidselectMethod","O selectMethod {0} não é válido."},
{"R_invalidpropertyValue","O tipo de dados da propriedade de conexão {0} não é válido. Todas as propriedades dessa conexão devem ser do tipo String."},
{"R_invalidArgument","O argumento {0} não é válido."},
{"R_streamWasNotMarkedBefore","O fluxo não foi marcado."},
{"R_invalidresponseBuffering","A propriedade de conexão responseBuffering {0} não é válida."},
{"R_invalidapplicationIntent","A propriedade de conexão applicationIntent {0} não é válida."},
{"R_invalidDatetimeType","A propriedade de conexão datetimeType {0} não é válida."},
{"R_dataAlreadyAccessed","Os dados foram acessados e não estão disponíveis para essa coluna ou esse parâmetro."},
{"R_outParamsNotPermittedinBatch","Os parâmetros OUT e INOUT não são permitidos em um lote."},
{"R_colNotMatchTable","O número de colunas {0} fornecidas não corresponde à definição de tabela {1}."},
{"R_invalidSQL","Consulta SQL inválida {0}."},
{"R_multipleQueriesNotAllowed","Não são permitidas várias consultas."},
{"R_endOfQueryDetected","Fim da consulta detectada antes dos VALORES serem encontrados."},
{"R_onlyFullParamAllowed","No momento somente consultas totalmente parametrizadas são permitidas para usar a API de Cópia em Massa para inserção em lote."},
{"R_sslRequiredNoServerSupport","O driver não pôde estabelecer uma conexão segura com o SQL Server usando a criptografia SSL. O aplicativo solicitou a criptografia, mas o servidor não está configurado para dar suporte a SSL."},
{"R_sslRequiredByServer","O logon do SQL Server requer uma conexão criptografada que usa SSL."},
{"R_sslFailed","A propriedade \"encrypt\" está definida como \"{0}\" e a propriedade \"trustServerCertificate\" está definida como \"{1}\", mas o driver não pôde estabelecer uma conexão segura com o SQL Server usando a criptografia do protocolo SSL (SSL): Erro: {2}."},
{"R_certNameFailed","Falha ao validar o nome do servidor “{0}\" em um certificado durante a inicialização do protocolo SSL (Secure Sockets Layer). Nome no certificado “{1}”"},
{"R_failedToInitializeXA","Falha ao inicializar o procedimento armazenado xp_sqljdbc_xa_init. Status: {0}. Erro: \"{1}\""},
{"R_failedFunctionXA","Falha na função {0}. Status: {1}. Erro: \"{2}\""},
{"R_noTransactionCookie","Falha na função {0}. Nenhum cookie de transação foi retornado."},
{"R_failedToEnlist","Falha ao inscrever. Erro: \"{0}\""},
{"R_failedToUnEnlist","Falha ao cancelar inscrição. Erro: \"{0}\""},
{"R_failedToReadRecoveryXIDs","Falha ao ler XIDs (IDs de transação) de ramificação XA de recuperação. Erro: \"{0}\""},
{"R_userPropertyDescription","O usuário do banco de dados."},
{"R_passwordPropertyDescription","A senha do banco de dados."},
{"R_databaseNamePropertyDescription","O nome do banco de dados ao qual conectar."},
{"R_domainPropertyDescription","O domínio do Windows no qual a autenticação será realizada usando NTLM."},
{"R_serverNamePropertyDescription","O computador que está executando o SQL Server."},
{"R_iPAddressPreferencePropertyDescription","O tipo preferido de endereço IP."},
{"R_portNumberPropertyDescription","A porta TCP na qual uma instância do SQL Server está escutando."},
{"R_realmPropertyDescription","O realm para autenticação Kerberos."},
{"R_serverSpnPropertyDescription","SPN do SQL Server."},
{"R_columnEncryptionSettingPropertyDescription","A configuração de criptografia de coluna."},
{"R_enclaveAttestationUrlPropertyDescription","A URL do atestado do enclave."},
{"R_enclaveAttestationProtocolPropertyDescription","O protocolo do atestado do enclave."},
{"R_serverNameAsACEPropertyDescription","Converte o serverName de Unicode para ASCII Compatible Encoding (ACE), conforme a definição da operação ToASCII do RFC 3490."},
{"R_sendStringParametersAsUnicodePropertyDescription","Determina se os parâmetros de cadeia de caracteres são enviados para o servidor como Unicode ou o conjunto de caracteres do banco de dados."},
{"R_multiSubnetFailoverPropertyDescription","Indica que o aplicativo está se conectando ao Availability Group Listener de um Availability Group ou Instância de Cluster de Failover."},
{"R_applicationNamePropertyDescription","O nome do aplicativo para as ferramentas de criação de perfil e log do SQL Server."},
{"R_lastUpdateCountPropertyDescription","Garante que apenas a última contagem de atualização seja retornada de uma instrução SQL passada para o servidor."},
{"R_disableStatementPoolingPropertyDescription","Desabilita o recurso de pooling da instrução."},
{"R_integratedSecurityPropertyDescription","Indica se a autenticação do Windows será usada para estabelecer conexão com o SQL Server."},
{"R_useDefaultGSSCredentialPropertyDescription","Indica se o GSSCredential será criado usando a GSS-API nativa."},
{"R_authenticationSchemePropertyDescription","O esquema de autenticação a ser usado para a autenticação integrada."},
{"R_lockTimeoutPropertyDescription","O número de milissegundos de espera antes que o banco de dados relate um tempo limite de bloqueio."},
{"R_connectRetryCountPropertyDescription","O número de tentativas de reconexão se houver uma falha de conexão."},
{"R_connectRetryIntervalPropertyDescription","O número de segundos entre cada nova tentativa de conexão."},
{"R_loginTimeoutPropertyDescription","O número de segundos que o driver deve aguardar antes que o tempo limite de uma conexão com falha expire."},
{"R_instanceNamePropertyDescription","O nome da instância do SQL Server à qual conectar."},
{"R_xopenStatesPropertyDescription","Determina se o driver retorna códigos de estado SQL compatíveis com  XOPEN em exceções."},
{"R_selectMethodPropertyDescription","Permite que o aplicativo use cursores de servidor para processar conjuntos de resultados somente de encaminhamento, somente leitura."},
{"R_responseBufferingPropertyDescription","Controla o comportamento de buffer adaptável para permitir que o aplicativo processe grandes conjuntos de resultados sem a necessidade de cursores de servidor."},
{"R_applicationIntentPropertyDescription","Declara o tipo de carga de trabalho do aplicativo ao conectar a um servidor. Os valores possíveis são ReadOnly e ReadWrite."},
{"R_workstationIDPropertyDescription","O nome do host da estação de trabalho."},
{"R_failoverPartnerPropertyDescription","O nome do servidor de failover usado em uma configuração de espelhamento de banco de dados."},
{"R_packetSizePropertyDescription","O tamanho do pacote de rede usado para comunicação com o SQL Server."},
{"R_encryptPropertyDescription","Determina se a criptografia SSL deve ser usada entre o cliente e o servidor."},
{"R_serverCertificatePropertyDescription","O caminho até o arquivo de certificado do servidor."},
{"R_prepareMethodPropertyDescription","Determina o método de preparação utilizado no driver."},
{"R_socketFactoryClassPropertyDescription","A classe cuja instância deve ser criada como o SocketFactory das conexões"},
{"R_socketFactoryConstructorArgPropertyDescription","O argumento opcional a ser passado para o construtor especificado por socketFactoryClass"},
{"R_trustServerCertificatePropertyDescription","Determina se o driver deve validar o certificado SSL (Secure Sockets Layer) do SQL Server."},
{"R_trustStoreTypePropertyDescription","Tipo de KeyStore."},
{"R_trustStorePropertyDescription","O caminho para o arquivo TrustStore de certificado."},
{"R_trustStorePasswordPropertyDescription","A senha usada para verificar a integridade dos dados do repositório de confiança."},
{"R_trustManagerClassPropertyDescription","A classe para instanciar como TrustManager para conexões SSL."},
{"R_trustManagerConstructorArgPropertyDescription","O argumento opcional para passar para o construtor especificado por trustManagerClass."},
{"R_hostNameInCertificatePropertyDescription","O nome do host a ser usado ao validar o certificado do protocolo SSL (Secure Sockets Layer) do SQL Server."},
{"R_replicationPropertyDescription","Esta configuração informa ao servidor se a conexão é utilizada para replicação."},
{"R_sendTimeAsDatetimePropertyDescription","Determina o uso do tipo de dados datetime do SQL Server para enviar valores java.sql.Time ao banco de dados."},
{"R_datetimeParameterTypePropertyDescription","Determina o tipo de dados a ser usado para valores datetime e carimbo de data/hora. As opções válidas são: datetime, datetime2 ou datetimeoffset"},
{"R_TransparentNetworkIPResolutionPropertyDescription","Determina se o recurso Resolução de IP de Rede Transparente deve ser usado."},
{"R_queryTimeoutPropertyDescription","O número de segundos de espera antes que o banco de dados relate um tempo limite de consulta."},
{"R_socketTimeoutPropertyDescription","O número de milissegundos a ser esperado antes que o java.net.SocketTimeoutException seja elevado."},
{"R_serverPreparedStatementDiscardThresholdPropertyDescription","O limite para quando fechar instruções de preparação descartadas no servidor (chamando um lote de sp_unprepares). Um valor de 1 ou menos fará com que sp_unprepare seja chamado imediatamente no fechamento do PreparedStatment."},
{"R_enablePrepareOnFirstPreparedStatementCallPropertyDescription","Essa configuração especifica se uma instrução preparada está preparada (sp_prepexec) no primeiro uso (property=true) ou no segundo após primeiro chamar sp_executesql (property=false)."},
{"R_cacheBulkCopyMetadataPropertyDescription","Essa configuração especifica se o driver armazena em cache os metadados usados para uma cópia em massa no caso de inserções em lote."},
{"R_statementPoolingCacheSizePropertyDescription","A configuração especifica o tamanho do cache de instrução preparado para uma conexão. Um valor menor que 1 significa que não há cache."},
{"R_gsscredentialPropertyDescription","Credencial GSS representada para acessar o SQL Server."},
{"R_msiClientIdPropertyDescription","ID de Cliente da Identidade Gerenciada Atribuída pelo Usuário a ser usada para geração de token de acesso para a Autenticação da MSI do Azure AD"},
{"R_clientCertificatePropertyDescription","Caminho do certificado do cliente."},
{"R_clientKeyPropertyDescription","Caminho do arquivo de chave privada para o certificado do cliente."},
{"R_clientKeyPasswordPropertyDescription","Senha da chave privada quando a chave privada é protegida por senha."},
{"R_sendTemporalDataTypesAsStringForBulkCopyPropertyDescription","Sinalizador para indicar se o driver enviará tipos de dados temporais como o valor de Cadeia de caracteres ao servidor para cópia em massa."},
{"R_delayLoadingLobsPropertyDescription","Sinalizador booliano que indica se o driver carregará os tipos de dados LOB na memória."},
{"R_AADSecurePrincipalIdPropertyDescription","A ID do Aplicativo de um aplicativo registrado que recebeu permissão para o banco de dados conectado."},
{"R_AADSecurePrincipalSecretPropertyDescription","Um Segredo definido para um aplicativo registrado que recebeu permissão para o banco de dados conectado."},
{"R_accessTokenCallbackClassPropertyDescription","A classe a ser instanciada como SQLServerAccessTokenCallback para aquisição de tokens."},
{"R_accessTokenCallbackPropertyDescription","Um objeto SQLServerAccessTokenCallback que é usado para chamar um método de retorno de chamada para retornar um token de acesso."},
{"R_noParserSupport","Erro ao criar uma instância do analisador necessário. Erro: \"{0}\""},
{"R_writeOnlyXML","Não é possível ler nessa instância do SQLXML. Essa instância é somente para gravar dados."},
{"R_dataHasBeenReadXML","Não é possível ler nessa instância do SQLXML. Os dados já foram lidos."},
{"R_readOnlyXML","Não é possível gravar nessa instância do SQLXML. Essa instância é somente para leitura de dados."},
{"R_dataHasBeenSetXML","Não é possível gravar nessa instância do SQLXML. Os dados já foram definidos."},
{"R_noDataXML","Nenhum dado foi definido nessa instância do SQLXML."},
{"R_cantSetNull","Não é possível definir um valor nulo."},
{"R_failedToParseXML","Falha ao analisar o XML. Erro: \"{0}\""},
{"R_isFreed","Esse objeto {0} foi liberado e não pode mais ser acessado."},
{"R_invalidProperty","Essa propriedade não tem suporte: {0}."},
{"R_referencingFailedTSP","A senha DataSource trustStore precisa ser definida."},
{"R_valueOutOfRange","Um ou mais valores estão fora do intervalo de valores para o tipo de dados {0} do SQL Server."},
{"R_valueOutOfRangeSQLType","Um ou mais valores estão fora do intervalo de valores para o tipo SQL {0}."},
{"R_integratedAuthenticationFailed","Falha na autenticação integrada."},
{"R_permissionDenied","Violação de segurança. Permissão para destino \"{0}\" negada."},
{"R_getSchemaError","Erro ao obter o nome de esquema padrão."},
{"R_setSchemaWarning","Aviso: setSchema é inoperante nesta versão do driver."},
{"R_updateCountOutofRange","O valor da contagem de atualizações está fora do intervalo."},
{"R_limitOffsetNotSupported","Não há suporte para a cláusula OFFSET na sequência de escape limite."},
{"R_limitEscapeSyntaxError","Erro na sintaxe de escape limite. Falha ao analisar consulta."},
{"R_featureNotSupported","Não há suporte para {0}."},
{"R_zoneOffsetError","Erro ao recuperar deslocamento de fuso."},
{"R_invalidMaxRows","A contagem máxima de linhas suportada para um conjunto de resultados definido é deInteger.MAX_VALUE ou menos."},
{"R_schemaMismatch","Os esquemas de origem e destino não correspondem."},
{"R_invalidColumn","A coluna {0} á inválida. Verifique os mapeamentos de colunas."},
{"R_invalidDestinationTable","O nome da tabela de destino está ausente ou é inválido."},
{"R_unableRetrieveColMeta","Impossível recuperar metadados da coluna."},
{"R_invalidDestConnection","A conexão de destino deve ser uma conexão do Microsoft JDBC Driver for SQL Server."},
{"R_unableRetrieveSourceData","Impossível recuperar dados da origem."},
{"R_ParsingError","Falha ao analisar dados para o tipo {0}."},
{"R_ParsingDataError","Falha ao analisar os dados {0} do tipo {1}."},
{"R_BulkTypeNotSupported","Não há suporte para o tipo de dados {0} em cópia em massa."},
{"R_BulkTypeNotSupportedDW","Não há suporte para o tipo de dados {0} em cópia em massa em relação ao Data Warehouse do Azure."},
{"R_invalidTransactionOption","A opção UseInternalTransaction não pode ser definida como TRUE quando usada com um objeto Connection."},
{"R_invalidNegativeArg","O argumento {0} não pode ser negativo."},
{"R_BulkColumnMappingsIsEmpty","Não é possível realizar operação de cópia em massa se o único mapeamento for uma coluna de identidade e KeepIdentity estiver definido como false."},
{"R_DataSchemaMismatch","Os dados da origem não correspondem ao esquema da origem."},
{"R_BulkDataDuplicateColumn","Nomes de coluna duplicados não são permitidos."},
{"R_invalidColumnOrdinal","A coluna {0} é inválida. O número de colunas deve ser maior que zero."},
{"R_unsupportedEncoding","A codificação {0} não tem suporte."},
{"R_UnexpectedDescribeParamFormat","Erro interno. O formato do conjunto de resultados retornado por sp_describe_parameter_encryption é inválido. Está faltando um dos conjuntos de resultados."},
{"R_InvalidEncryptionKeyOrdinal","Erro interno. O ordinal referenciado \"{0}\" da chave de criptografia da coluna está faltando nos metadados de criptografia retornados por sp_describe_parameter_encryption. O ordinal máximo é \"{1}\"."},
{"R_MissingParamEncryptionMetadata","Erro interno. Os metadados de alguns parâmetros na instrução ou no procedimento \"{0}\" estão faltando no conjunto de resultados retornado por sp_describe_parameter_encryption."},
{"R_UnableRetrieveParameterMetadata","Não é possível recuperar os metadados de criptografia do parâmetro."},
{"R_InvalidCipherTextSize","O texto cifrado especificado tem um tamanho inválido de {0} bytes, que está abaixo do mínimo de {1} bytes necessário para descriptografia."},
{"R_InvalidAlgorithmVersion","A versão especificada {0} do algoritmo de criptografia do texto cifrado não corresponde à versão esperada {1} do algoritmo de criptografia."},
{"R_InvalidAuthenticationTag","O texto cifrado especificado tem uma marcação de autenticação inválida. "},
{"R_EncryptionFailed","Erro interno durante a criptografia:  {0} "},
{"R_DecryptionFailed","Erro interno durante a descriptografia:  {0} "},
{"R_InvalidKeySize","A chave de criptografia de coluna foi descriptografada com êxito, mas seu tamanho: {0} não corresponde ao tamanho: {1} para o algoritmo \"{2}\". Verifique o valor criptografado da chave de criptografia de coluna no banco de dados."},
{"R_InvalidEncryptionType","O tipo de criptografia {0} especificado para a coluna no banco de dados é inválido ou está corrompido. Os tipos de criptografia válidos para o algoritmo {1} são: {2}."},
{"R_UnknownColumnEncryptionAlgorithm","O Algoritmo {0} não existe. Os algoritmos registrados na fábrica são {1}."},
{"R_KeyExtractionFailed","Falha ao extrair chave: {0}."},
{"R_UntrustedKeyPath","O caminho {0} da chave mestre da coluna recebido do servidor {1} não é um caminho de chave confiável. O caminho da chave mestre da coluna pode estar corrompido ou você deve definir {0} como um caminho de chave confiável usando SQLServerConnection.setColumnEncryptionTrustedMasterKeyPaths()."},
{"R_UnrecognizedKeyStoreProviderName","Falha ao descriptografar uma chave de criptografia de coluna. Nome do provedor de repositório de chaves inválido: {0}. Um nome de provedor de repositório de chaves deve indicar um provedor de repositório de chaves do sistema ou um provedor de repositório de chaves personalizado registrado. Nomes válidos de provedor de chave do sistema são: {1}. Nomes válidos (atualmente registrados) de provedor de repositório de chaves personalizado são: {2}. Verifique as informações do provedor de repositório de chaves em definições de chave mestra de coluna no banco de dados e verifique se todos os provedores de repositório de chaves personalizados usados no aplicativo estão registrados corretamente."},
{"R_UnrecognizedConnectionKeyStoreProviderName","Falha ao descriptografar uma chave de criptografia de coluna. Nome do provedor de repositório de chaves inválido: {0}. Um nome de provedor de repositório de chaves deve indicar um provedor de repositório de chaves registrado. Os nomes de provedores de repositório de chaves registrados nesta conexão são: {1}. Verifique as informações do provedor de repositório de chaves em definições de chave mestra de coluna no banco de dados e verifique se todos os provedores de repositório de chaves usados no aplicativo estão registrados corretamente."},
{"R_UnrecognizedStatementKeyStoreProviderName","Falha ao descriptografar uma chave de criptografia de coluna. Nome do provedor de repositório de chaves inválido: {0}. Um nome de provedor de repositório de chaves deve indicar um provedor de repositório de chaves registrado. Os nomes de provedores de repositório de chaves registrados nesta instrução são: {1}. Verifique as informações do provedor de repositório de chaves em definições de chave mestra de coluna no banco de dados e verifique se todos os provedores de repositório de chaves usados no aplicativo estão registrados corretamente."},
{"R_UnsupportedDataTypeAE","Não há suporte para criptografia e descriptografia do tipo de dados {0}."},
{"R_NormalizationErrorAE","A descriptografia do tipo de dados {0} falhou. Erro de normalização."},
{"R_UnsupportedNormalizationVersionAE","A versão de normalização \"{0}\" recebida do SQL Server é inválida ou está corrompida. Versões de normalização válidas são: {1}."},
{"R_NullCipherTextAE","Erro interno. O valor de Ciphertext não pode ser nulo."},
{"R_NullColumnEncryptionAlgorithmAE","Erro interno. O algoritmo de criptografia não pode ser nulo. Algoritmos válidos são: {1}."},
{"R_CustomCipherAlgorithmNotSupportedAE","Não há suporte para o algoritmo de criptografia personalizado."},
{"R_PlainTextNullAE","Erro interno. O valor de Plaintext não pode ser nulo."},
{"R_StreamingDataTypeAE","Não há suporte para dados com tamanho maior que {0} na coluna criptografada {1}."},
{"R_AE_NotSupportedByServer","O SQL Server em uso não oferece suporte à criptografia de coluna."},
{"R_InvalidAEVersionNumber","Recebido o número de versão inválido \"{0}\" para Always Encrypted."},
{"R_NullEncryptedColumnEncryptionKey","Erro interno. A chave de criptografia da coluna criptografada não pode ser nula."},
{"R_EmptyEncryptedColumnEncryptionKey","Erro interno. Especificada chave de criptografia vazia da coluna criptografada."},
{"R_InvalidMasterKeyDetails","Detalhes da chave mestra especificados inválidos."},
{"R_CertificateError","Ocorreu um erro ao recuperar o certificado \"{0}\" do repositório de chaves \"{1}\"."},
{"R_ByteToShortConversion","Ocorreu um erro ao descriptografar a chave de criptografia da coluna."},
{"R_InvalidCertificateSignature","A assinatura da chave de criptografia da coluna criptografada especificada não corresponde à assinatura calculada com a chave mestra da coluna (certificado) em \"{0}\". A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho especificado pode estar incorreto."},
{"R_CEKDecryptionFailed","Exceção ao descriptografar a chave de criptografia da coluna criptografada: {0} "},
{"R_CryptoCacheInaccessible","{0} erro ao tentar realizar operações de cache criptográfico de sessão: {1} "},
{"R_NullKeyEncryptionAlgorithm","O algoritmo de criptografia de chave não pode ser nulo."},
{"R_NullKeyEncryptionAlgorithmInternal","Erro interno. O algoritmo de criptografia de chave não pode ser nulo."},
{"R_InvalidKeyEncryptionAlgorithm","Algoritmo de criptografia de chave inválido especificado: {0}. Valor esperado: {1}."},
{"R_InvalidKeyEncryptionAlgorithmInternal","Erro interno. Algoritmo de criptografia de chave inválido especificado: {0}. Valor esperado: {1}."},
{"R_NullColumnEncryptionKey","A chave de criptografia de coluna não pode ser nula."},
{"R_EmptyColumnEncryptionKey","Chave de criptografia de coluna vazia especificada."},
{"R_CertificateNotFoundForAlias","O certificado com alias {0} não foi encontrado no repositório fornecido por {1}. Verifique se o certificado foi importado corretamente para o local/repositório de certificados."},
{"R_UnrecoverableKeyAE","Não é possível recuperar a chave privada do repositório de chaves com os detalhes do certificado {0}. Verifique se o certificado do Always Encrypted importado contém a chave privada e a senha corretas fornecidas para o certificado."},
{"R_KeyStoreNotFound","O sistema não pode localizar o arquivo de repositório de chaves no caminho especificado. Verifique se o caminho está correto e se você tem as permissões apropriadas para acessá-lo."},
{"R_CustomKeyStoreProviderMapNull","O mapa do provedor de repositório de chaves de criptografia de coluna não pode ser nulo. Esperado um valor não nulo."},
{"R_EmptyCustomKeyStoreProviderName","Nome do provedor de repositório de chaves inválido especificado. Nomes de provedores de repositório de chaves não podem ser nulos ou vazios."},
{"R_InvalidCustomKeyStoreProviderName","Nome do provedor de repositório de chaves inválido {0}. O prefixo {1} é reservado para provedores de repositório de chaves do sistema."},
{"R_CustomKeyStoreProviderValueNull","Referência nula especificada para o provedor de repositório de chaves {0}. Esperando um valor não nulo."},
{"R_CustomKeyStoreProviderSetOnce","Provedores de repositório de chaves não podem ser definidos mais de uma vez."},
{"R_unknownColumnEncryptionType","Tipo de criptografia de coluna inválido {0}."},
{"R_unsupportedStmtColEncSetting","SQLServerStatementColumnEncryptionSetting não pode ser nulo."},
{"R_unsupportedConversionAE","Não há suporte para conversão de {0} em {1} para a coluna criptografada."},
{"R_InvalidDataForAE","O tipo de valor fornecido {0} da origem de dados não pode ser convertido para o tipo {1} da coluna de destino especificada {2}."},
{"R_authenticationPropertyDescription","A autenticação para usar."},
{"R_accessTokenPropertyDescription","O token de acesso a ser usado para o Azure Active Directory."},
{"R_FedAuthRequiredPreLoginResponseInvalidValue","O servidor enviou um valor inesperado para a Opção FedAuthRequired PreLogin. O valor era {0}."},
{"R_FedAuthInfoLengthTooShortForCountOfInfoIds","O token FedAuthInfo deve conter, no mínimo, 4 bytes indicando o número de IDs de informações."},
{"R_FedAuthInfoInvalidOffset","FedAuthInfoDataOffset aponta para uma localização inválida. O dataOffset atual é {0}."},
{"R_FedAuthInfoFailedToReadData","Falha ao ler FedAuthInfoData."},
{"R_FedAuthInfoLengthTooShortForData","O fluxo de tokens FEDAUTHINFO não é longo o suficiente ({0}) para conter os dados que necessita."},
{"R_FedAuthInfoDoesNotContainStsurlAndSpn","O fluxo de tokens FEDAUTHINFO não contém STSURL e SPN."},
{"R_MSALExecution","Falha ao autenticar o usuário {0} no Active Directory (Authentication={1})."},
{"R_MSALAuthComplete","Autenticação concluída. Você pode fechar o navegador e retornar ao aplicativo."},
{"R_UnrequestedFeatureAckReceived","Reconhecimento de recurso não solicitado recebido. ID do recurso: {0}."},
{"R_FedAuthFeatureAckContainsExtraData","A extensão ack do recurso de autenticação federada para ADAL e Security Token inclui dados extras."},
{"R_FedAuthFeatureAckUnknownLibraryType","Tentando usar a biblioteca de autenticação federada desconhecida. ID da biblioteca: {0}."},
{"R_UnknownFeatureAck","Um reconhecimento de recurso desconhecido foi recebido."},
{"R_SetAuthenticationWhenIntegratedSecurityTrue","Não é possível definir \"Authentication\" com \"IntegratedSecurity\" definido como \"true\"."},
{"R_NtlmNoUserPasswordDomain","As propriedades de conexão \"User\" (ou \"UserName\") e \"Password\" precisam ser especificadas para a autenticação NTLM."},
{"R_SetAccesstokenWhenIntegratedSecurityTrue","Não será possível definir a propriedade AccessToken se a palavra-chave da cadeia de conexão \"IntegratedSecurity\" tiver sido definida como \"true\"."},
{"R_IntegratedAuthenticationWithUserPassword","Não é possível usar \"Authentication=ActiveDirectoryIntegrated\" com as palavras-chave das cadeias de conexão \"User\", \"UserName\" ou \"Password\"."},
{"R_ManagedIdentityAuthenticationWithPassword","Não é possível usar \"Authentication={0}\" com a palavra-chave de cadeia de conexão \"Password\"."},
{"R_AccessTokenWithUserPassword","Não será possível definir a propriedade AccessToken se \"User\", \"UserName\" ou \"Password\" tiver sido especificado na cadeia de conexão."},
{"R_AccessTokenCallbackWithUserPassword","Não é possível definir o retorno de chamada do token de acesso se \"User\", \"UserName\" ou \"Password\" tiver sido definido."},
{"R_AccessTokenCannotBeEmpty","AccessToken não pode estar vazio."},
{"R_SetBothAuthenticationAndAccessToken","Não será possível definir a propriedade AccessToken se \"Authentication\" tiver sido especificado na cadeia de conexão."},
{"R_NoUserPasswordForActivePassword","As palavras-chave da cadeia de conexão \"User\" (ou \"UserName\") e \"Password\" deverão ser especificadas, se \"Authentication=ActiveDirectoryPassword\"."},
{"R_NoUserPasswordForActiveServicePrincipal","As palavras-chave da cadeia de conexão \"UserName\" e “Password” deverão ser especificadas, se \"Authentication=ActiveDirectoryServicePrincipal\"."},
{"R_NoUserOrCertForActiveServicePrincipalCertificate","\"As palavras-chave da cadeia de conexão \"UserName\" e \"clientCertificate\" devem ser especificadas, se \"Authentication=ActiveDirectoryServicePrincipalCertificate\"."},
{"R_NoUserPasswordForSqlPassword","As palavras-chave da cadeia de conexão \"User\" (ou \"UserName\") e \"Password\" deverão ser especificadas, se \"Authentication=SqlPassword\"."},
{"R_BothUserPasswordandDeprecated","As palavras-chave de cadeia de conexão \"User\" (ou \"UserName\"), \"Password\" e \"AADSecurePrincipalId\", \"AADSecurePrincipalSecret\" são especificadas. Use apenas \"User\" (ou \"UserName\"), \"Password\"."},
{"R_ForceEncryptionTrue_HonorAEFalse","Não é possível definir Forçar Criptografia como true para o parâmetro {0} porque a criptografia não está habilitada para a instrução ou o procedimento {1}."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn","Não é possível executar a instrução ou o procedimento {0} porque Forçar Criptografia foi definido como true para o parâmetro {1} e o banco de dados espera que esse parâmetro seja enviado como texto não criptografado. O motivo pode ser um erro de configuração."},
{"R_ForceEncryptionTrue_HonorAEFalseRS","Não é possível definir Forçar Criptografia como true para o parâmetro {0} porque a criptografia não está habilitada para a instrução ou o procedimento."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS","Não é possível executar a atualização porque Forçar Criptografia foi definido como true para o parâmetro {0} e o banco de dados espera que esse parâmetro seja enviado como texto não criptografado. O motivo pode ser um erro de configuração."},
{"R_NullValue","{0} não pode ser nulo."},
{"R_PathInvalid","Caminho inválido especificado: {0}."},
{"R_URLInvalid","URL inválida especificada: {0}."},
{"R_AKVPathNull","O caminho da chave do Azure Key Vault não pode ser nulo."},
{"R_AKVMasterKeyPathInvalid","Caminho da chave do Azure Key Vault especificado inválido: {0}."},
{"R_ManagedIdentityInitFail","Falha ao inicializar o pacote para obter o token de Identidade Gerenciada do Azure Key Vault."},
{"R_EmptyCEK","Chave de criptografia de coluna vazia especificada."},
{"R_EncryptedCEKNull","A chave de criptografia da coluna criptografada não pode ser nula."},
{"R_EmptyEncryptedCEK","O tamanho da Chave de Criptografia da Coluna Criptografada não pode ser zero."},
{"R_NonRSAKey","Não é possível usar uma chave que não seja RSA: {0}."},
{"R_GetAKVKeySize","Não é possível obter o tamanho da chave pública do Azure Key Vault em bytes."},
{"R_InvalidEcryptionAlgorithmVersion","A chave de criptografia da coluna criptografada especificada contém a versão inválida {0} do algoritmo de criptografia. A versão esperada é {1}."},
{"R_AKVKeyLengthError","O tamanho especificado do ciphertext da chave de criptografia da coluna criptografada: {0} não corresponde ao tamanho do texto cifrado: {1} ao usar a chave mestra da coluna (chave do Azure Key Vault) em {2}. A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho da chave do Azure Key Vault especificado pode estar incorreto."},
{"R_AKVSignatureLengthError","O tamanho especificado da assinatura da chave de criptografia da coluna criptografada: {0} não corresponde ao tamanho da assinatura: {1} ao usar a chave mestra da coluna (chave do Azure Key Vault) em {2}. A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho da chave do Azure Key Vault especificado pode estar incorreto."},
{"R_HashNull","O hash não pode ser nulo ao descriptografar a chave de criptografia da coluna criptografada."},
{"R_NoSHA256Algorithm","Não há suporte para o Algoritmo SHA-256."},
{"R_VerifySignatureFailed","Não foi possível verificar a assinatura da chave de criptografia da coluna."},
{"R_SignatureNotMatch","A assinatura da chave de criptografia da coluna criptografada especificada \"{0}\" não corresponde à assinatura \"{1}\" calculada com a chave mestra da coluna (certificado) em \"{2}\". A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho especificado pode estar incorreto. {3}"},
{"R_CEKSignatureNotMatchCMK","A assinatura da chave de criptografia de coluna criptografada especificada \"{0}\" não corresponde à assinatura calculada com a chave mestra da coluna (chave assimétrica no Azure Key Vault) em {1}. A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho especificado pode estar incorreto."},
{"R_DecryptCEKError","Não é possível descriptografar a chave de criptografia da coluna usando a chave do Azure Key Vault especificada."},
{"R_EncryptCEKError","Não é possível criptografar a chave de criptografia da coluna usando a chave do Azure Key Vault especificada."},
{"R_CipherTextLengthNotMatchRSASize","O tamanho do CipherText não corresponde ao tamanho da chave RSA."},
{"R_GenerateSignature","Não é possível gerar assinatura usando uma URL de Chave do Azure Key Vault especificada."},
{"R_SignedHashLengthError","O tamanho do hash assinado não corresponde ao tamanho da chave RSA."},
{"R_InvalidSignatureComputed","Assinatura inválida da chave de criptografia da coluna criptografada calculada."},
{"R_UnableLoadADALSqlDll","Não é possível carregar adalsql.dll. Código de erro: 0x{0}. Para obter detalhes, consulte: http://go.microsoft.com/fwlink/?LinkID=513072"},
{"R_ADALAuthenticationMiddleErrorMessage","Código de erro 0x{0}; estado {1}."},
{"R_unsupportedDataTypeTVP","Não há suporte para o tipo de dados {0} em Table-Valued Parameter."},
{"R_moreDataInRowThanColumnInTVP","A matriz de entrada é maior que o número de colunas nesta tabela."},
{"R_invalidTVPName"," O Table-Valued Parameter deve ter um nome de tipo válido."},
{"R_invalidThreePartName","Formato inválido de nome de três partes para TypeName."},
{"R_unsupportedConversionTVP","Não há suporte para conversão de {0} em {1} para Table-Valued Parameter."},
{"R_TVPMixedSource","Não é possível adicionar metadados de coluna. Esse Table-Valued Parameter tem um ResultSet do qual os metadados serão derivados."},
{"R_TVPEmptyMetadata","Não há campos suficientes no tipo Estruturado. Os tipos Estruturados devem ter pelo menos um campo."},
{"R_TVPInvalidValue","O valor {0} fornecido para Table-Valued Parameter não é válido. Somente os objetos SQLServerDataTable, ResultSet e ISQLServerDataRecord têm suporte."},
{"R_TVPInvalidColumnValue","Os dados de entrada não estão no formato correto."},
{"R_TVPSortOrdinalGreaterThanFieldCount","O ordinal de classificação {0} no campo {1} excede o número total de campos."},
{"R_TVPMissingSortOrderOrOrdinal","Tanto a ordem de classificação quanto o ordinal devem ser especificados, ou nenhum deles deve ser especificado (SortOrder.Unspecified e -1). Os valores fornecidos foram: ordem = {0}, ordinal = {1}."},
{"R_TVPDuplicateSortOrdinal","O ordinal de classificação {0} foi especificado duas vezes."},
{"R_TVPMissingSortOrdinal","O ordinal de classificação {0} não foi especificado."},
{"R_TVPDuplicateColumnName","Um nome de coluna {0} já pertence a esta SQLServerDataTable."},
{"R_InvalidConnectionSetting","O valor de {0} \"{1}\" não é válido."},
{"R_InvalidWindowsCertificateStoreEncryption","Não é possível criptografar uma chave de criptografia de coluna com o Windows Certificate Store."},
{"R_InvalidWindowsCertificateStoreSignCMK","Não é possível assinar metadados de chave mestra de coluna com o Windows Certificate Store."},
{"R_AEKeypathEmpty","Erro interno. O caminho do certificado não pode ser nulo. Use o seguinte formato: \"local do certificado/repositório de certificados/impressão digital do certificado\", em que \"local do certificado\" é LocalMachine ou CurrentUser."},
{"R_AEWinApiErr","Erro nativo de API do Windows."},
{"R_AECertpathBad","Erro interno. Caminho do certificado inválido: {0}. Use o seguinte formato: \"local do certificado/repositório de certificados/impressão digital do certificado\", em que \"local do certificado\" é LocalMachine ou CurrentUser."},
{"R_AECertLocBad","Erro interno. Local do certificado inválido: {0} no caminho do certificado {1}. Use o seguinte formato: \"local do certificado/repositório de certificados/impressão digital do certificado\", em que \"local do certificado\" é LocalMachine ou CurrentUser."},
{"R_AECertStoreBad","Erro interno. Repositório de certificados inválido {0} especificado no caminho do certificado {1}. Valor esperado: My."},
{"R_AECertHashEmpty","Erro interno. Impressão digital do certificado vazia especificada no caminho do certificado {0}."},
{"R_AECertNotFound","O certificado com a impressão digital {2} não foi encontrado no repositório de certificados {1} no local do certificado {0}. Verifique se o caminho do certificado na definição da chave mestre de coluna no banco de dados está correto e se o certificado foi importado corretamente para o local/repositório de certificados."},
{"R_AEMaloc","Falhas de alocação de memória."},
{"R_InvalidAccessTokenCallbackClass","AccessTokenCallbackClass inválido: {0}"},
{"R_AEKeypathLong","Erro interno. O caminho do certificado especificado tem {0} bytes, que excede o tamanho máximo de {1} bytes."},
{"R_AEECEKLenBad","O tamanho especificado do ciphertext da chave de criptografia da coluna criptografada: {0} não corresponde ao tamanho do texto cifrado: {1} ao usar a chave mestra da coluna (certificado) em \"{2}\". A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho de certificado especificado pode estar incorreto."},
{"R_AEECEKSigLenBad","O tamanho especificado da assinatura da chave de criptografia da coluna criptografada {0} não corresponde ao tamanho {1} ao usar a chave mestra da coluna (certificado) em \"{2}\". A chave de criptografia da coluna criptografada pode estar corrompida ou o caminho do certificado especificado pode estar incorreto."},
{"R_AEKeyPathEmptyOrReserved","O caminho do certificado \"{0}\" é inválido, está vazio ou contém nomes de diretório reservados."},
{"R_AEKeyPathCurUser","CurrentUser foi especificado no caminho da chave, mas ocorreu um erro ao obter o diretório de trabalho inicial do usuário atual."},
{"R_AEKeyFileOpenError","Erro ao abrir o arquivo de certificado {0}."},
{"R_AEKeyFileReadError","Erro ao ler o arquivo de certificado {0}."},
{"R_keyStoreAuthenticationPropertyDescription","O nome que identifica um repositório de chaves."},
{"R_keyStoreSecretPropertyDescription","O segredo de autenticação ou as informações necessárias para localizar o segredo."},
{"R_keyStoreLocationPropertyDescription","O local de armazenamento de chaves."},
{"R_keyStoreAuthenticationNotSet","A palavra-chave da cadeia de conexão \"keyStoreAuthentication\" deverá ser especificada se \"{0}\" for especificado."},
{"R_keyStoreSecretOrLocationNotSet","Ambos \"keyStoreSecret\" e \"keyStoreLocation\" devem ser definidos, se \"keyStoreAuthentication=JavaKeyStorePassword\" tiver sido especificado na cadeia de conexão."},
{"R_keyStoreSecretNotSet","\"keyStoreSecret\" precisará ser definido se \"keyStoreAuthentication=KeyVaultClientSecret\" tiver sido especificado na cadeia de conexão."},
{"R_keyVaultProviderClientKeyNotSet","\"keyVaultProviderClientKey\" deve estar definido, se \"keyVaultProviderClientId\" tiver sido especificado na cadeia de conexão."},
{"R_keyVaultProviderNotSupportedWithKeyStoreAuthentication","\"keyStoreAuthentication\" não pode ser utilizado com \"keyVaultProviderClientId\" ou \"keyVaultProviderClientKey\" na cadeia de conexão."},
{"R_certificateStoreInvalidKeyword","Não é possível definir \"keyStoreSecret\", se \"keyStoreAuthentication=CertificateStore\" for especificado na cadeia de conexão."},
{"R_certificateStoreLocationNotSet","\"keyStoreLocation\"deve ser especificado, se \"keyStoreAuthentication=CertificateStore\" tiver sido especificado na cadeia de conexão."},
{"R_certificateStorePlatformInvalid","Não é possível definir \"keyStoreAuthentication=CertificateStore\" em um sistema operacional Windows."},
{"R_invalidKeyStoreFile","Não é possível analisar \"{0}\". O formato de arquivo não é válido ou a senha não está correta."},
{"R_invalidCEKCacheTtl","Vida útil do cache da chave de criptografia de coluna especificada inválida. O valor columnEncryptionKeyCacheTtl não pode ser negativo e timeUnit só pode ser DAYS, HOURS, MINUTES ou SECONDS."},
{"R_sendTimeAsDateTimeForAE","Use sendTimeAsDateTime=false com Always Encrypted."},
{"R_TVPnotWorkWithSetObjectResultSet","O setObject() com ResultSet não é compatível com o Parâmetro com Valor de Tabela. Use setStructured()."},
{"R_invalidQueryTimeout","O queryTimeout {0} não é válido."},
{"R_invalidSocketTimeout","O socketTimeout {0} não é válido."},
{"R_fipsPropertyDescription","Determina se o modo FIPS está habilitado."},
{"R_invalidFipsConfig","Não é possível verificar as configurações do modo FIPS."},
{"R_serverPreparedStatementDiscardThreshold","O serverPreparedStatementDiscardThreshold {0} não é válido."},
{"R_statementPoolingCacheSize","O statementPoolingCacheSize {0} é inválido."},
{"R_kerberosLoginFailedForUsername","Não é possível efetuar logon na entidade de segurança do Kerberos {0}, verifique suas credenciais. {1}"},
{"R_kerberosLoginFailed","Falha no logon do Kerberos: {0} devido ao {1} ({2})"},
{"R_StoredProcedureNotFound","Não foi possível encontrar o procedimento armazenado ''''{0}''''."},
{"R_jaasConfigurationNamePropertyDescription","Nome de configuração de logon para autenticação Kerberos."},
{"R_useDefaultJaasConfigPropertyDescription","Use a configuração padrão de JAAS para autenticação Kerberos."},
{"R_AKVKeyNotFound","Chave de configuração não encontrada: {0}"},
{"R_SQLVariantSupport","SQL_VARIANT não é compatível com versões do SQL Server anteriores a 2008."},
{"R_invalidProbbytes","SQL_VARIANT: probBytes inválido para tipo {0}."},
{"R_invalidStringValue","SQL_VARIANT não é compatível com valores de sequência de caracteres maiores que 8000."},
{"R_invalidValueForTVPWithSQLVariant","O uso de TVPs contendo colunas sql_variant nulas não é compatível."},
{"R_invalidDataTypeSupportForSQLVariant","Tipo TDS inesperado '' ''{0}'' '' em SQL_VARIANT."},
{"R_sslProtocolPropertyDescription","Rótulo do protocolo SSL de TLS, TLSv1, TLSv1.1 e TLSv1.2. O padrão é TLS."},
{"R_invalidSSLProtocol","O rótulo {0} do protocolo SSL não é válido. Apenas TLS, TLSv1, TLSv1.1 e TLSv1.2 são compatíveis."},
{"R_cancelQueryTimeoutPropertyDescription","O número de segundos de espera para cancelar o envio de um tempo limite de consulta."},
{"R_invalidCancelQueryTimeout","O valor de tempo limite de cancelamento {0} não é válido."},
{"R_useBulkCopyForBatchInsertPropertyDescription","Determina se o driver usará a API de cópia em massa para operações de inserção em lote."},
{"R_bulkCopyForBatchInsertBatchSizePropertyDescription","O tamanho padrão do lote para operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_bulkCopyForBatchInsertCheckConstraintsPropertyDescription","Determina se as restrições devem marcar durante operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_bulkCopyForBatchInsertFireTriggersPropertyDescription","Determina se os gatilhos devem ser disparados durante operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_bulkCopyForBatchInsertKeepIdentityPropertyDescription","Determina se os valores de identidade devem ser mantidos durante operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_bulkCopyForBatchInsertKeepNullsPropertyDescription","Determina se valores nulos devem ser mantidos durante operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_bulkCopyForBatchInsertTableLockPropertyDescription","Determina se o bloqueio de tabela deve ser usado durante operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_bulkCopyForBatchInsertAllowEncryptedValueModificationsPropertyDescription","Determina se as modificações de valor criptografado devem ser permitidas durante operações de cópia em massa criadas a partir de operações de inserção em lotes."},
{"R_UnknownDataClsTokenNumber","Token desconhecido para a Classificação de Dados."},
{"R_InvalidDataClsVersionNumber","Número de versão inválido {0} para a Classificação de Dados."},
{"R_unknownUTF8SupportValue","Valor desconhecido para o suporte de UTF8."},
{"R_unknownAzureSQLDNSCachingValue","Valor desconhecido do Cache do DNS do SQL do Azure."},
{"R_illegalWKT","Well-Known text ilícito. Verifique se o Well-Known text é válido."},
{"R_illegalTypeForGeometry","{0} não tem suporte para Geometry."},
{"R_illegalWKTposition","Caractere ilícito no Well-Known text na posição {0}."},
{"R_keyVaultProviderClientIdPropertyDescription","A ID do cliente usada para acessar o Key Vault no qual a chave mestra de criptografia de coluna está armazenada."},
{"R_keyVaultProviderClientKeyPropertyDescription","A chave do cliente usada para acessar o Key Vault no qual a chave mestra de criptografia de coluna está armazenada."},
{"R_keyStorePrincipalIdPropertyDescription","ID da entidade de segurança do Azure Active Directory."},
{"R_MSALMissing","Falha ao carregar a biblioteca Java MSAL4J para a realização da autenticação de {0}."},
{"R_DLLandMSALMissing","Falha ao carregar a {0} e a biblioteca Java MSAL4J para a realização da autenticação de {1}. Instale uma dessas opções para continuar."},
{"R_MSITokenFailureEndpoint","Falha de Token de MSI: falha ao adquirir o token do Ponto de Extremidade de MSI"},
{"R_propertyNotSupported","No momento, o Microsoft JDBC Driver para SQL Server não oferece suporte à propriedade: {0}"},
{"R_ntlmHmacMD5Error","Não é possível inicializar a autenticação NTLM: erro de inicialização HMAC-MD5."},
{"R_ntlmSignatureError","Erro de assinatura da Mensagem de Desafio NTLM: {0}"},
{"R_ntlmMessageTypeError","Erro de tipo de Mensagem de Desafio de NTLM: {0}"},
{"R_ntlmAuthenticateError","Erro de NTLM ao construir a Mensagem de Autenticação: {0}"},
{"R_ntlmNoTargetInfo","TargetInfo está ausente da Mensagem de Desafio de NTLM."},
{"R_ntlmUnknownValue","Erro de TargetInfo da Mensagem de Desafio de NTLM: valor desconhecido \"{0}\""},
{"R_useFmtOnlyPropertyDescription","Determina se o uso de SET FMTONLY deve ser habilitado/desabilitado para recuperar os metadados do parâmetro."},
{"R_invalidOpenqueryCall","Sintaxe inválida: OPENQUERY/OPENJSON/OPENDATASOURCE/OPENROWSET/OPENXML precisa ser precedido por parênteses"},
{"R_invalidCTEFormat","Sintaxe inválida: AS precisa ser seguido por parênteses nas Expressões de Tabela Comuns."},
{"R_noTokensFoundInUserQuery","Consulta inválida: não foi analisado nenhum token do SQL fornecido."},
{"R_invalidUserSQL","Erro ao tentar analisar o SQL do usuário. Verifique a sintaxe SQL."},
{"R_invalidInsertValuesQuery","Erro ao corresponder a lista VALUES às colunas da tabela. Verifique a sintaxe SQL."},
{"R_invalidValuesList","Erro ao ler a lista VALUES. Verifique a sintaxe SQL."},
{"R_enclaveNotSupported","O SQL Server não oferece suporte a cálculos baseados em enclave - confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_enclavePropertiesError","A propriedade de conexão \"columnEncryptionSetting\" deve estar ativada, junto com as propriedades de conexão \"enclaveAttestationUrl\" e \"enclaveAttestationProtocol\" válidas ao ativar o Always Encrypted com enclaves seguros, confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_enclaveInvalidAttestationProtocol","O \"enclaveAttestationProtocol\" é inválido, confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_enclaveTypeInvalid","O tipo de enclave {0} é inválido ou não é compatível com a unidade - confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_attestationUrlInvalid","Não é possível atestar o enclave especificado por {0} confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_EnclaveResponseLengthError","Mais bytes do servidor foram recebidos do que o esperado ao analisar a resposta de atestado do enclave, confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_EnclavePackageLengthError","Mais bytes do servidor foram recebidos do que o esperado ao analisar o pacote do enclave, confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_EnclavePKLengthError","Mais bytes do servidor foram recebidos do que o esperado ao analisar a chave pública do enclave, confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_MalformedECDHPublicKey","A chave pública ECDH do servidor precisa ter 104 bits."},
{"R_MalformedECDHHeader","Valores inesperados para o cabeçalho de chave pública ECDH do servidor."},
{"R_HealthCertError","O atestado do enclave falhou, não foi possível recuperar os certificados do relatório de integridade fornecidos no enclave: {0} - confira https://go.microsoft.com/fwlink/?linkid=2160553 para mais detalhes."},
{"R_InvalidHealthCert","O atestado do enclave falhou, o certificado do relatório de integridade fornecido no enclave não foi assinado pelo HGS, confira https://go.microsoft.com/fwlink/?linkid=2160553 para mais detalhes."},
{"R_InvalidSignedStatement","O atestado do enclave falhou, os bytes de instrução não foram assinados pelo certificado de integridade - confira https://go.microsoft.com/fwlink/?linkid=2160553 para mais detalhes."},
{"R_InvalidDHKeySignature","O atestado do enclave falhou, a assinatura da chave pública DH não pode ser verificada com a chave pública do enclave - confira https://go.microsoft.com/fwlink/?linkid=2157649 para mais detalhes."},
{"R_AasJWTError","Erro ao recuperar e validar o Token Web JSON."},
{"R_AasEhdError","A solicitação de aas-ehd do JWT não correspondeu à chave pública do enclave."},
{"R_VbsRpDataError","A solicitação de rp_data do JWT não correspondeu ao nonce do cliente."},
{"R_pvkParseError","Não foi possível ler a Chave Privada do PVK. Verifique a senha fornecida."},
{"R_pvkHeaderError","Não é possível analisar o PVK. O arquivo PVK não contém o cabeçalho correto."},
{"R_readCertError","Erro ao ler o certificado, verifique a localização do certificado."},
{"R_unassignableError","A classe especificada pela propriedade {0} precisa ser atribuível a {1}."},
{"R_InvalidCSVQuotes","Falha ao analisar o arquivo CSV. Verifique se os campos estão corretamente inseridos entre aspas duplas."},
{"R_TokenRequireUrl","As credenciais de token exigem uma URL que use o esquema de protocolo HTTPS."},
{"R_calcBigDecimalPrecisionPropertyDescription","Indica se o driver deve calcular a precisão para grandes valores decimais."},
{"R_retryExecPropertyDescription","Lista de regras de repetição de instruções a serem seguidas para a lógica de repetição configurável."},
{"R_retryConnPropertyDescription","Lista de regras de repetição de conexão a serem seguidas para a lógica de repetição configurável."},
{"R_maxResultBufferPropertyDescription","Determina a quantidade máxima de bytes que podem ser lidos durante a recuperação do conjunto de resultados"},
{"R_maxResultBufferInvalidSyntax","Sintaxe inválida: {0} no parâmetro maxResultBuffer."},
{"R_maxResultBufferNegativeParameterValue","MaxResultBuffer precisa ter um valor positivo: {0}."},
{"R_maxResultBufferPropertyExceeded","Propriedade MaxResultBuffer excedida: {0}. O MaxResultBuffer foi definido para: {1}."},
{"R_invalidConnectRetryCount","A contagem de novas tentativas de conexão {0} não é válida."},
{"R_connectRetryCountPropertyDescription","O número máximo de tentativas para restabelecer uma conexão interrompida."},
{"R_invalidConnectRetryInterval","O intervalo de repetição da conexão {0} não é válido."},
{"R_connectRetryIntervalPropertyDescription","O intervalo, em segundos, entre as tentativas de restabelecer uma conexão."},
{"R_crClientAllRecoveryAttemptsFailed","A conexão foi desfeita e a recuperação não é possível. O driver do cliente tentou recuperar a conexão uma ou mais vezes e todas as tentativas falharam. Aumente o valor de ConnectRetryCount para aumentar o número de tentativas de recuperação."},
{"R_crClientNoRecoveryAckFromLogin","O servidor não reconheceu uma tentativa de recuperação; a recuperação da conexão não é possível."},
{"R_crServerSessionStateNotRecoverable","A conexão foi desfeita e a recuperação não é possível. A conexão está marcada pelo servidor como não recuperável. Não houve nenhuma tentativa de restaurar a conexão."},
{"R_crClientUnrecoverable","A conexão foi desfeita e a recuperação não é possível. A conexão está marcada pelo driver do cliente como não recuperável. Não houve nenhuma tentativa de restaurar a conexão."},
{"R_crClientSSLStateNotRecoverable","O servidor não preservou a criptografia SSL durante uma tentativa de recuperação; a recuperação da conexão não é possível."},
{"R_crCommandCannotTimeOut","A solicitação não atingiu o tempo limite e SQLServerConnection não existe"},
{"R_InvalidIPAddressPreference","A preferência de endereço IP {0} não é válida."},
{"R_UnableLoadAuthDll","Não é possível carregar a autenticação DLL {0}"},
{"R_illegalArgumentTrustManager","Erro interno. A cadeia de certificados de pares ou o algoritmo de troca de chaves não pode ser nulo ou vazio."},
{"R_serverCertExpired","O certificado do servidor expirou: {0}: {1}"},
{"R_serverCertNotYetValid","O certificado do servidor ainda não é válido: {0}: {1}"},
{"R_serverCertError","Erro ao validar o certificado do servidor: {0}: \n{1}:\n{2}."},
{"R_SecureStringInitFailed","Falha ao inicializar o SecureStringUtil para armazenar cadeias de caracteres seguras"},
{"R_ALPNFailed","Falha ao negociar o Protocolo Camada do Aplicativo {0}. Servidor retornado: {1}."},
{"R_serverError","Ocorreu um erro durante o comando atual (Status concluído {0}). {1}"},
{"R_ManagedIdentityTokenAcquisitionFail","Falha ao adquirir token de identidade gerenciada. A solicitação para o token foi bem-sucedida, mas nenhum token foi retornado. O token é nulo."},
{"R_AmbiguousRowUpdate","Falha ao executar updateRow(). A atualização está tentando uma atualização ambígua nas tabelas \"{0}\" e \"{1}\". Certifique-se de que todas as colunas que estão sendo atualizadas antes da chamada updateRow() pertençam à mesma tabela."},
{"R_InvalidSqlQuery","Consulta SQL inválida: {0}"},
{"R_InvalidScale","A escala do valor de entrada é maior que o máximo permitido pelo SQL Server."},
{"R_colCountNotMatchColTypeCount","O número de colunas fornecidas {0} não corresponde à definição dos tipos de dados de coluna {1}."},
{"R_InvalidRuleFormat","Número incorreto de parâmetros fornecidos à regra. Número de parâmetros: {0}, esperado: 2 ou 3."},
{"R_InvalidRetryInterval","O intervalo de repetição atual: {0}, é maior que o queryTimeout: {1}."},
{"R_UnableToFindClass","Não é possível localizar a classe especificada: {0}"},
{"R_ibmModuleNotFound","o módulo com.ibm.security.auth.module.Krb5LoginModule não foi encontrado."},
{"R_moduleNotFound","Nem com.sun.security.auth.module.Krb5LoginModule nem com.ibm.security.auth.module.Krb5LoginModule foi encontrado."},
};
}
