/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum KeyStoreAuthentication {
    JavaKeyStorePassword,
    KeyVaultClientSecret,
    KeyVaultManagedIdentity;


    static KeyStoreAuthentication valueOfString(String value) throws SQLServerException {
        KeyStoreAuthentication method = null;
        if (value.toLowerCase(Locale.US).equalsIgnoreCase(JavaKeyStorePassword.toString())) {
            method = JavaKeyStorePassword;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(KeyVaultClientSecret.toString())) {
            method = KeyVaultClientSecret;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(KeyVaultManagedIdentity.toString())) {
            method = KeyVaultManagedIdentity;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidConnectionSetting"));
            Object[] msgArgs = new Object[]{"keyStoreAuthentication", value};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        return method;
    }
}

