/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.sharepoint.Credentials;
import com.microsoft.services.sharepoint.DiscoveryInformation;
import com.microsoft.services.sharepoint.LogLevel;
import com.microsoft.services.sharepoint.Logger;
import com.microsoft.services.sharepoint.Platform;
import com.microsoft.services.sharepoint.Query;
import com.microsoft.services.sharepoint.http.HttpConnection;
import com.microsoft.services.sharepoint.http.Request;
import com.microsoft.services.sharepoint.http.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class OfficeClient {
    Credentials mCredentials;
    Logger mLogger;

    public OfficeClient(Credentials credentials) {
        this(credentials, null);
    }

    public OfficeClient(Credentials credentials, Logger logger) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials must not be null");
        }
        this.mLogger = logger == null ? new Logger(){

            @Override
            public void log(String message, LogLevel level) {
            }
        } : logger;
        this.mCredentials = credentials;
    }

    protected void log(String message, LogLevel level) {
        this.getLogger().log(message, level);
    }

    protected void log(Throwable error) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        String stackTrace = sw.toString();
        this.getLogger().log(error.toString() + "\nStack Trace: " + stackTrace, LogLevel.Critical);
    }

    protected Logger getLogger() {
        return this.mLogger;
    }

    protected Credentials getCredentials() {
        return this.mCredentials;
    }

    protected String generateODataQueryString(Query query) {
        StringBuilder sb = new StringBuilder();
        if (query != null) {
            query.ensureIdProperty();
            sb.append("$filter=");
            sb.append(this.queryEncode(query.toString()));
            String rowSetModifiers = query.getRowSetModifiers().trim();
            if (!rowSetModifiers.equals("")) {
                if (!rowSetModifiers.startsWith("&")) {
                    sb.append("&");
                }
                sb.append(rowSetModifiers);
            }
        }
        return sb.toString();
    }

    protected ListenableFuture<byte[]> executeRequest(String url, String method) {
        return this.executeRequest(url, method, null, null);
    }

    protected ListenableFuture<byte[]> executeRequest(String url, String method, Map<String, String> headers, byte[] payload) {
        HttpConnection connection = Platform.createHttpConnection();
        Request request = new Request(method);
        if (headers != null) {
            for (String key : headers.keySet()) {
                request.addHeader(key, headers.get(key));
            }
        }
        request.setUrl(url);
        request.setContent(payload);
        this.prepareRequest(request);
        this.log("Generate request for " + url, LogLevel.Verbose);
        request.log(this.getLogger());
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<Response> future = connection.execute(request);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Response>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(Response response) {
                try {
                    int statusCode = response.getStatus();
                    if (OfficeClient.isValidStatus(statusCode)) {
                        byte[] responseContentBytes = response.readAllBytes();
                        result.set((Object)responseContentBytes);
                    } else {
                        result.setException((Throwable)new Exception("Invalid status code " + statusCode + ": " + response.readToEnd()));
                    }
                }
                catch (IOException e) {
                    OfficeClient.this.log(e);
                }
            }
        });
        return result;
    }

    protected ListenableFuture<JSONObject> executeRequestJson(String url, String method) {
        return this.executeRequestJson(url, method, null, null);
    }

    protected ListenableFuture<JSONObject> executeRequestJson(String url, String method, Map<String, String> headers, byte[] payload) {
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<byte[]> request = this.executeRequest(url, method, headers, payload);
        Futures.addCallback(request, (FutureCallback)new FutureCallback<byte[]>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(byte[] b) {
                try {
                    String string = new String(b, "UTF-8");
                    if (string.length() == 0) {
                        result.set(null);
                    } else {
                        JSONObject json = new JSONObject(string);
                        result.set((Object)json);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }

    public ListenableFuture<List<DiscoveryInformation>> getDiscoveryInfo() {
        return this.getDiscoveryInfo("https://api.office.com/discovery/me/services");
    }

    public ListenableFuture<List<DiscoveryInformation>> getDiscoveryInfo(String discoveryEndpoint) {
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<JSONObject> request = this.executeRequestJson(discoveryEndpoint, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    List<DiscoveryInformation> discoveryInfo = DiscoveryInformation.listFromJson(json, DiscoveryInformation.class);
                    result.set(discoveryInfo);
                }
                catch (JSONException e) {
                    OfficeClient.this.log(e.getMessage(), LogLevel.Critical);
                }
            }
        });
        return result;
    }

    protected void prepareRequest(Request request) {
        request.addHeader("Accept", "application/json;odata=verbose");
        request.addHeader("X-ClientService-ClientTag", "SDK-JAVA");
        int contentLength = 0;
        if (request.getContent() != null) {
            contentLength = request.getContent().length;
        }
        request.addHeader("Content-Length", String.valueOf(contentLength));
        this.mCredentials.prepareRequest(request);
    }

    protected static boolean isValidStatus(int status) {
        return status >= 200 && status <= 299;
    }

    protected String queryEncode(String query) {
        String encoded;
        try {
            encoded = query.replaceAll("\\s", "+");
        }
        catch (Exception e) {
            encoded = query;
        }
        return encoded;
    }

    protected String urlEncode(String str) {
        String encoded;
        try {
            encoded = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encoded = str;
        }
        encoded = encoded.replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        return encoded;
    }

    protected String UUIDtoString(UUID id) {
        return id.toString().replace("-", "");
    }
}

