/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.sharepoint.Credentials;
import com.microsoft.services.sharepoint.FileSystemItem;
import com.microsoft.services.sharepoint.Logger;
import com.microsoft.services.sharepoint.SharePointClient;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class DocLibClient
extends SharePointClient {
    public DocLibClient(String serverUrl, String siteRelativeUrl, Credentials credentials) {
        super(serverUrl, siteRelativeUrl, credentials);
    }

    public DocLibClient(String serverUrl, String siteRelativeUrl, Credentials credentials, Logger logger) {
        super(serverUrl, siteRelativeUrl, credentials, logger);
    }

    public ListenableFuture<List<FileSystemItem>> getFileSystemItems() {
        return this.getFileSystemItems(null, null);
    }

    public ListenableFuture<List<FileSystemItem>> getFileSystemItems(String path, String library) {
        final SettableFuture result = SettableFuture.create();
        String getPath = library == null ? (path == null || path.length() == 0 ? this.getSiteUrl() + "_api/Files" : this.getSiteUrl() + String.format("_api/Files('%s')/children", this.urlEncode(path))) : (path == null || path.length() == 0 ? this.getSiteUrl() + String.format("_api/web/lists/GetByTitle('%s')/files", this.urlEncode(library)) : this.getSiteUrl() + String.format("_api/web/lists/GetByTitle('%s')/files('%s')/children", this.urlEncode(library), this.urlEncode(path)));
        ListenableFuture<JSONObject> request = this.executeRequestJson(getPath, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    List<FileSystemItem> item = FileSystemItem.listFrom(json);
                    result.set(item);
                }
                catch (Throwable e) {
                    result.setException(e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<FileSystemItem> getFileSystemItem(String path) {
        return this.getFileSystemItem(path, null);
    }

    public ListenableFuture<FileSystemItem> getFileSystemItem(String path, String library) {
        String getFilesUrl;
        final SettableFuture files = SettableFuture.create();
        if (library != null) {
            getFilesUrl = this.getSiteUrl() + "_api/web/lists/GetByTitle('%s')/files(%s)";
            getFilesUrl = String.format(getFilesUrl, this.urlEncode(library), this.getUrlPath(path));
        } else {
            getFilesUrl = this.getSiteUrl() + String.format("_api/files(%s)", this.getUrlPath(path));
        }
        try {
            ListenableFuture<JSONObject> request = this.executeRequestJson(getFilesUrl, "GET");
            Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

                public void onFailure(Throwable t) {
                    files.setException(t);
                }

                public void onSuccess(JSONObject json) {
                    try {
                        FileSystemItem item = new FileSystemItem();
                        item.loadFromJson(json);
                        files.set((Object)item);
                    }
                    catch (Throwable e) {
                        files.setException(e);
                    }
                }
            });
        }
        catch (Throwable t) {
            files.setException(t);
        }
        return files;
    }

    public ListenableFuture<Object> getProperty(final String property, String path, String library) {
        String getPropertyUrl;
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        if (property == null || property.length() == 0) {
            throw new IllegalArgumentException("Property cannot be null or empty");
        }
        if (library == null) {
            getPropertyUrl = this.getSiteUrl() + String.format("_api/files('%s')/%s", this.urlEncode(path), property);
        } else {
            String url = this.getSiteUrl() + "_api/web/Lists/GetByTitle('%s')/files('%s')/%s";
            getPropertyUrl = String.format(url, this.urlEncode(library.trim()), this.urlEncode(path), property);
        }
        final SettableFuture result = SettableFuture.create();
        ListenableFuture<JSONObject> request = this.executeRequestJson(getPropertyUrl, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    Object propertyResult = json.getJSONObject("d").get(property);
                    result.set(propertyResult);
                }
                catch (JSONException e) {
                    result.setException((Throwable)e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<Object> getProperty(String property, String path) {
        return this.getProperty(property, path, null);
    }

    public ListenableFuture<byte[]> getFile(String path) {
        return this.getFile(path, null);
    }

    public ListenableFuture<byte[]> getFile(String path, String library) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        String getFileUrl = library == null ? this.getSiteUrl() + String.format("_api/files('%s')/$value", this.urlEncode(path)) : this.getSiteUrl() + String.format("_api/web/Lists/GetByTitle('%s')/files('%s')/$value", this.urlEncode(library), this.urlEncode(path));
        return this.executeRequest(getFileUrl, "GET");
    }

    public ListenableFuture<FileSystemItem> createFolder(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        ListenableFuture<FileSystemItem> fileMetadata = this.createEmpty(path, null, "{ '__metadata': { 'type': 'MS.FileServices.Folder' }, Name : '%s'}");
        return fileMetadata;
    }

    public ListenableFuture<FileSystemItem> createFolder(String path, String library) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        if (library == null || library.length() == 0) {
            throw new IllegalArgumentException("library name cannot be null or empty");
        }
        ListenableFuture<FileSystemItem> fileMetadata = this.createEmpty(path, library, "{ '__metadata': { 'type': 'MS.FileServices.Folder' }, Name : '%s'}");
        return fileMetadata;
    }

    public ListenableFuture<FileSystemItem> createFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("fileName cannot be null or empty");
        }
        ListenableFuture<FileSystemItem> fileMetadata = this.createEmpty(fileName, null, "{ '__metadata': { 'type': 'MS.FileServices.File' }, Name : '%s'}");
        return fileMetadata;
    }

    public ListenableFuture<FileSystemItem> createFile(String fileName, String library) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("fileName cannot be null or empty");
        }
        if (library == null || fileName.length() == 0) {
            throw new IllegalArgumentException("libraryName cannot be null or empty");
        }
        ListenableFuture<FileSystemItem> fileMetadata = this.createEmpty(fileName, library, "{ '__metadata': { 'type': 'MS.FileServices.File' }, Name : '%s'}");
        return fileMetadata;
    }

    public ListenableFuture<FileSystemItem> createFile(String fileName, String library, boolean overwrite, byte[] content) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("fileName cannot be null or empty");
        }
        String urlPart = this.urlEncode(String.format("Add(name='%s', overwrite='%s')", fileName, Boolean.toString(overwrite)));
        String url = library == null || library.length() == 0 ? this.getSiteUrl() + "_api/files/" + urlPart : this.getSiteUrl() + String.format("_api/web/lists/getbytitle('%s')/files/", this.urlEncode(library)) + urlPart;
        final SettableFuture result = SettableFuture.create();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        ListenableFuture<JSONObject> request = this.executeRequestJsonWithDigest(url, "POST", headers, content);
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                FileSystemItem item = new FileSystemItem();
                item.loadFromJson(json, true);
                result.set((Object)item);
            }
        });
        return result;
    }

    public ListenableFuture<FileSystemItem> createFile(String fileName, boolean overwrite, byte[] content) {
        return this.createFile(fileName, null, overwrite, content);
    }

    public ListenableFuture<Void> delete(String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        return this.delete(path, null);
    }

    public ListenableFuture<Void> delete(String path, String library) {
        final SettableFuture result = SettableFuture.create();
        String deleteUrl = library == null ? this.getSiteUrl() + String.format("_api/Files('%s')", this.urlEncode(path)) : this.getSiteUrl() + String.format("_api/web/Lists/GetByTitle('%s')/files('%s')", this.urlEncode(library), this.urlEncode(path));
        ListenableFuture<JSONObject> request = this.executeRequestJson(deleteUrl, "DELETE");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                result.set(null);
            }
        });
        return result;
    }

    public ListenableFuture<Void> move(String sourcePath, String destinationPath, boolean overwrite) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("sourcePath cannot be null or empty");
        }
        if (destinationPath == null) {
            throw new IllegalArgumentException("destinationPath cannot be null or empty");
        }
        ListenableFuture<Void> result = this.fileOp("MoveTo", sourcePath, destinationPath, overwrite, null);
        return result;
    }

    public ListenableFuture<Void> move(String sourcePath, String destinationPath, boolean overwrite, String library) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("sourcePath cannot be null or empty");
        }
        if (destinationPath == null) {
            throw new IllegalArgumentException("destinationPath cannot be null or empty");
        }
        ListenableFuture<Void> result = this.fileOp("MoveTo", sourcePath, destinationPath, overwrite, library);
        return result;
    }

    public ListenableFuture<Void> copy(String sourcePath, String destinationPath, boolean overwrite) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("sourcePath cannot be null or empty");
        }
        if (destinationPath == null) {
            throw new IllegalArgumentException("destinationPath cannot be null or empty");
        }
        ListenableFuture<Void> result = this.fileOp("CopyTo", sourcePath, destinationPath, overwrite, null);
        return result;
    }

    public ListenableFuture<Void> copy(String sourcePath, String destinationPath, boolean overwrite, String library) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("sourcePath cannot be null or empty");
        }
        if (destinationPath == null) {
            throw new IllegalArgumentException("destinationPath cannot be null or empty");
        }
        ListenableFuture<Void> result = this.fileOp("CopyTo", sourcePath, destinationPath, overwrite, library);
        return result;
    }

    private ListenableFuture<FileSystemItem> createEmpty(String path, String library, String metadata) {
        final SettableFuture result = SettableFuture.create();
        String postUrl = null;
        postUrl = library == null ? this.getSiteUrl() + "_api/files" : this.getSiteUrl() + String.format("_api/web/lists/GetByTitle('%s')/files", this.urlEncode(library));
        byte[] payload = null;
        try {
            String completeMetada = String.format(metadata, path);
            payload = completeMetada.getBytes("UTF-8");
            ListenableFuture<JSONObject> request = this.executeRequestJsonWithDigest(postUrl, "POST", null, payload);
            Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

                public void onFailure(Throwable t) {
                    result.setException(t);
                }

                public void onSuccess(JSONObject json) {
                    FileSystemItem item = new FileSystemItem();
                    item.loadFromJson(json, true);
                    result.set((Object)item);
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            result.setException((Throwable)e);
        }
        return result;
    }

    private ListenableFuture<Void> fileOp(String operation, String source, String destination, boolean overwrite, String library) {
        final SettableFuture result = SettableFuture.create();
        String targetEncoded = this.urlEncode("target='" + destination + "', overwrite=" + Boolean.toString(overwrite));
        String url = library == null || library.length() == 0 ? this.getSiteUrl() + String.format("_api/files('%s')/%s(%s)", this.urlEncode(source), operation, targetEncoded) : this.getSiteUrl() + String.format("_api/web/lists/getbytitle('%s')/files('%s')/%s(%s)", this.urlEncode(library), this.urlEncode(source), operation, targetEncoded);
        ListenableFuture<JSONObject> request = this.executeRequestJsonWithDigest(url, "POST", null, null);
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                result.set(null);
            }
        });
        return result;
    }

    private String getUrlPath(String path) {
        if (path == null) {
            path = "";
        }
        String urlPath = path.length() == 0 ? "" : String.format("'%s'", this.urlEncode(path));
        return urlPath;
    }
}

