/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.MediaEntityInputStream;
import com.microsoft.services.orc.core.ODataBaseEntity;
import com.microsoft.services.orc.core.OrcEntityFetcher;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.core.OrcOperations;
import com.microsoft.services.orc.core.Readable;
import com.microsoft.services.orc.http.HttpVerb;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;
import java.io.InputStream;

public abstract class OrcMediaEntityFetcher<TEntity extends ODataBaseEntity, TOperations extends OrcOperations>
extends OrcEntityFetcher<TEntity, TOperations>
implements Readable<TEntity> {
    public OrcMediaEntityFetcher(String urlComponent, OrcExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz, operationClazz);
    }

    public ListenableFuture<byte[]> getContent() {
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        OrcURL url = request.getUrl();
        url.appendPathComponent("$value");
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<OrcResponse, byte[]>(){

            public ListenableFuture<byte[]> apply(OrcResponse response) throws Exception {
                SettableFuture result = SettableFuture.create();
                result.set((Object)response.getPayload());
                return result;
            }
        });
    }

    public ListenableFuture<InputStream> getStreamedContent() {
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        request.addOption("MUST_STREAM_RESPONSE_CONTENT", "true");
        OrcURL url = request.getUrl();
        url.appendPathComponent("$value");
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<OrcResponse, InputStream>(){

            public ListenableFuture<InputStream> apply(OrcResponse response) throws Exception {
                SettableFuture result = SettableFuture.create();
                result.set((Object)new MediaEntityInputStream(response.openStreamedResponse(), response));
                return result;
            }
        });
    }

    public ListenableFuture<Void> putContent(byte[] content) {
        Request request = this.getResolver().createRequest();
        request.setContent(content);
        request.setVerb(HttpVerb.PUT);
        OrcURL url = request.getUrl();
        url.appendPathComponent("$value");
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToVoidListenableFuture(future);
    }

    public ListenableFuture<Void> putContent(InputStream stream, long streamSize) {
        Request request = this.getResolver().createRequest();
        request.setStreamedContent(stream, streamSize);
        request.setVerb(HttpVerb.PUT);
        OrcURL url = request.getUrl();
        url.appendPathComponent("$value");
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToVoidListenableFuture(future);
    }
}

