/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.services.orc.core.BaseOrcContainer;
import com.microsoft.services.orc.core.Constants;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.OrcEntityFetcher;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.core.OrcFetcher;
import com.microsoft.services.orc.core.OrcList;
import com.microsoft.services.orc.core.OrcOperations;
import com.microsoft.services.orc.core.Readable;
import com.microsoft.services.orc.http.HttpVerb;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;
import java.util.UUID;

public class OrcCollectionFetcher<TEntity, TFetcher extends OrcEntityFetcher, TOperations extends OrcOperations>
extends OrcFetcher<TEntity>
implements Readable<OrcList<TEntity>> {
    private int top = -1;
    private int skip = -1;
    private String selectedId = null;
    private TOperations operations;
    private String select = null;
    private String expand = null;
    private String filter = null;
    private String orderBy = null;

    public OrcCollectionFetcher(String urlComponent, OrcExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz);
        this.reset();
        try {
            this.operations = (OrcOperations)operationClazz.getConstructor(String.class, OrcExecutable.class).newInstance("", this);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    public void reset() {
        this.top = -1;
        this.skip = -1;
        this.selectedId = null;
        this.select = null;
        this.expand = null;
        this.filter = null;
        this.orderBy = null;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> top(int top) {
        this.top = top;
        return this;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> select(String select) {
        this.select = select;
        return this;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> expand(String expand) {
        this.expand = expand;
        return this;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> filter(String filter) {
        this.filter = filter;
        return this;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public TFetcher getById(String id) {
        this.selectedId = "('" + id + "')";
        return this.getFetcher();
    }

    public TFetcher getById(Object id) {
        if (id instanceof UUID) {
            this.selectedId = "(" + id + ")";
        } else if (id instanceof String) {
            this.selectedId = "('" + id + "')";
        }
        return this.getFetcher();
    }

    private TFetcher getFetcher() {
        String packageName = this.operations.getClass().getPackage().getName();
        String[] classNameParts = (this.clazz.getCanonicalName() + "Fetcher").split("\\.");
        String className = packageName + "." + classNameParts[classNameParts.length - 1];
        try {
            Class<?> entityQueryClass = Class.forName(className);
            OrcEntityFetcher odataEntityQuery = (OrcEntityFetcher)entityQueryClass.getConstructor(String.class, OrcExecutable.class).newInstance("", this);
            return (TFetcher)odataEntityQuery;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ListenableFuture<OrcResponse> oDataExecute(Request request) {
        if (this.selectedId == null) {
            this.setPathForCollections(request.getUrl(), this.urlComponent, this.top, this.skip, this.select, this.expand, this.filter, this.orderBy);
        } else {
            this.setSelectorUrl(request.getUrl(), this.urlComponent, this.selectedId);
        }
        Helpers.addCustomParametersToRequest(request, this.getParameters(), this.getHeaders());
        return this.parent.oDataExecute(request);
    }

    @Override
    public ListenableFuture<OrcList<TEntity>> read() {
        return Helpers.transformToEntityListListenableFuture(this.readRaw(), this.clazz, this.getResolver(), this.getParentOrcContainer());
    }

    private BaseOrcContainer getParentOrcContainer() {
        OrcExecutable current = this.parent;
        while (current != null && current instanceof OrcFetcher && !(current instanceof BaseOrcContainer)) {
            OrcFetcher fetcher = (OrcFetcher)current;
            current = fetcher.parent;
        }
        return (BaseOrcContainer)current;
    }

    @Override
    public ListenableFuture<String> readRaw() {
        return super.readRaw();
    }

    public ListenableFuture<TEntity> add(TEntity entity) {
        ListenableFuture<String> future = this.addRaw(this.getResolver().getJsonSerializer().serialize(entity));
        return Helpers.transformToEntityListenableFuture(future, this.clazz, this.getResolver());
    }

    public ListenableFuture<String> addRaw(String payload) {
        byte[] payloadBytes = payload.getBytes(Constants.UTF8);
        Request request = this.getResolver().createRequest();
        request.setContent(payloadBytes);
        request.setVerb(HttpVerb.POST);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture(future);
    }

    public TOperations getOperations() {
        return this.operations;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    public OrcCollectionFetcher<TEntity, TFetcher, TOperations> addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    protected void setPathForCollections(OrcURL url, String urlComponent, int top, int skip, String select, String expand, String filter, String orderBy) {
        if (top > -1) {
            url.addQueryStringParameter("$top", Integer.valueOf(top).toString());
        }
        if (skip > -1) {
            url.addQueryStringParameter("$skip", Integer.valueOf(skip).toString());
        }
        if (select != null) {
            url.addQueryStringParameter("$select", select);
        }
        if (expand != null) {
            url.addQueryStringParameter("$expand", expand);
        }
        if (filter != null) {
            url.addQueryStringParameter("$filter", filter);
        }
        if (orderBy != null) {
            url.addQueryStringParameter("$orderby", orderBy);
        }
        url.prependPathComponent(urlComponent);
    }
}

