/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.primitives.Bytes;
import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.MultiPartElement;
import com.microsoft.services.orc.core.OrcCollectionFetcher;
import com.microsoft.services.orc.core.OrcEntityFetcher;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.core.OrcOperations;
import com.microsoft.services.orc.http.HttpVerb;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MultipartCollectionFetcher<TEntity, TFetcher extends OrcEntityFetcher, TOperations extends OrcOperations>
extends OrcCollectionFetcher<TEntity, TFetcher, TOperations> {
    public MultipartCollectionFetcher(String urlComponent, OrcExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz, operationClazz);
    }

    @Override
    public ListenableFuture<Void> add(List<MultiPartElement> multiPartElements) {
        String random = UUID.randomUUID().toString();
        Request request = this.getResolver().createRequest();
        byte[][] content = new byte[multiPartElements.size()][];
        for (int i = 0; i < multiPartElements.size(); ++i) {
            MultiPartElement element = multiPartElements.get(i);
            ArrayList<Byte> header = new ArrayList<Byte>();
            String line = "--MultiPartBoundary" + random + "\r\n";
            line = line + "Content-Disposition:form-data; name=" + element.getName() + "\r\n";
            line = line + "Content-type:" + element.getContentType() + "\r\n" + "\r\n";
            for (byte b : line.getBytes()) {
                header.add(b);
            }
            content[i] = Bytes.concat((byte[][])new byte[][]{Bytes.toArray(header), element.getContent(), "\r\n".getBytes()});
        }
        String closeLine = "\r\n--MultiPartBoundary" + random + "--";
        request.addHeader("Content-Type", "multipart/form-data; boundary=MultiPartBoundary" + random);
        request.setContent(Bytes.concat((byte[][])new byte[][]{Bytes.concat((byte[][])content), closeLine.getBytes()}));
        request.setVerb(HttpVerb.POST);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToVoidListenableFuture(future);
    }
}

