/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.core.BaseOrcContainer;
import com.microsoft.services.orc.core.Constants;
import com.microsoft.services.orc.core.DependencyResolver;
import com.microsoft.services.orc.core.OrcList;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;
import com.microsoft.services.orc.serialization.impl.CalendarSerializer;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helpers {
    static final Logger logger = LoggerFactory.getLogger(Helpers.class);
    private static final String ENCODE_EXCEPTIONS = "!$&'()*+,;=:@";
    private static final HashSet<String> reservedNames = new HashSet();

    public static HashSet<String> getReservedNames() {
        return reservedNames;
    }

    public static void addCustomParametersToRequest(Request request, Map<String, Object> parameters, Map<String, String> headers) {
        OrcURL url = request.getUrl();
        Set<String> parameterKeys = parameters.keySet();
        for (String name : parameterKeys) {
            Object val = parameters.get(name);
            url.addQueryStringParameter(name, Helpers.toODataURLValue(val));
        }
        Set<String> headerKeys = headers.keySet();
        for (String name : headerKeys) {
            String val = headers.get(name);
            request.addHeader(name, val);
        }
    }

    public static String getFunctionParameters(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(key);
            sb.append("=");
            String odataValue = Helpers.toODataURLValue(map.get(key));
            sb.append(odataValue);
        }
        return sb.toString();
    }

    public static String appendFunctionComponent(String functionName, Map<String, Object> arguments) {
        String result;
        if (!arguments.isEmpty()) {
            result = "('";
            for (Map.Entry<String, Object> entrySet : arguments.entrySet()) {
                result = result + String.format("%s,%s", entrySet.getKey(), entrySet.getValue());
            }
            result = result + "')";
        } else {
            result = "()";
        }
        return functionName + result;
    }

    private static String toODataURLValue(Object o) {
        if (o instanceof String) {
            return "'" + o + "'";
        }
        if (o instanceof Calendar) {
            return CalendarSerializer.serialize((Calendar)o);
        }
        return o.toString();
    }

    public static String urlEncode(String string) {
        return Helpers.percentEncode(string, ENCODE_EXCEPTIONS);
    }

    private static String percentEncode(String s, String reserved) {
        if (s == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(s.length());
        int escapeStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || "-._~".indexOf(c) != -1 || reserved.indexOf(c) != -1) {
                if (escapeStart != -1) {
                    Helpers.appendHex(builder, s.substring(escapeStart, i));
                    escapeStart = -1;
                }
                builder.append(c);
                continue;
            }
            if (escapeStart != -1) continue;
            escapeStart = i;
        }
        if (escapeStart != -1) {
            Helpers.appendHex(builder, s.substring(escapeStart, s.length()));
        }
        return builder.toString();
    }

    private static void appendHex(StringBuilder builder, String s) {
        try {
            for (byte b : s.getBytes("UTF-8")) {
                Helpers.appendHex(builder, b);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void appendHex(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(String.format("%02X", b));
    }

    public static byte[] serializeToJsonByteArray(Object entity, DependencyResolver resolver) {
        String payload = resolver.getJsonSerializer().serialize(entity);
        return payload.getBytes(Constants.UTF8);
    }

    public static ListenableFuture<String> transformToStringListenableFuture(ListenableFuture<OrcResponse> future) {
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<OrcResponse, String>(){

            public ListenableFuture<String> apply(OrcResponse response) throws Exception {
                SettableFuture result = SettableFuture.create();
                result.set((Object)new String(response.getPayload(), "UTF-8"));
                return result;
            }
        });
    }

    public static <TEntity> ListenableFuture<TEntity> transformToEntityListenableFuture(ListenableFuture<String> future, final Class<TEntity> clazz, final DependencyResolver resolver) {
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<String, TEntity>(){

            public ListenableFuture<TEntity> apply(String payload) throws Exception {
                SettableFuture result = SettableFuture.create();
                Object entity = null;
                try {
                    logger.info("Entity Deserialization Started");
                    entity = resolver.getJsonSerializer().deserialize(payload, clazz);
                    logger.info("Entity Deserialization Finished");
                }
                catch (Throwable throwable) {
                    logger.error("Error in deserialization", throwable);
                    result.setException(throwable);
                }
                result.set(entity);
                return result;
            }
        });
    }

    public static <TEntity> ListenableFuture<OrcList<TEntity>> transformToEntityListListenableFuture(ListenableFuture<String> future, final Class<TEntity> clazz, final DependencyResolver resolver, final BaseOrcContainer baseOrcContainer) {
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<String, OrcList<TEntity>>(){

            public ListenableFuture<OrcList<TEntity>> apply(String payload) throws Exception {
                SettableFuture result = SettableFuture.create();
                try {
                    logger.info("Entity collection Deserialization Started");
                    OrcList list = resolver.getJsonSerializer().deserializeList(payload, clazz, baseOrcContainer);
                    logger.info("Entity collection Deserialization Finished");
                    result.set(list);
                }
                catch (Throwable throwable) {
                    logger.error("Error in deserialization", throwable);
                    result.setException(throwable);
                }
                return result;
            }
        });
    }

    public static ListenableFuture<Void> transformToVoidListenableFuture(ListenableFuture<OrcResponse> future) {
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<OrcResponse, Void>(){

            public ListenableFuture<Void> apply(OrcResponse input) throws Exception {
                SettableFuture result = SettableFuture.create();
                result.set(null);
                return result;
            }
        });
    }

    public static ListenableFuture<byte[]> transformToByteArrayListenableFuture(ListenableFuture<OrcResponse> future) {
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<OrcResponse, byte[]>(){

            public ListenableFuture<byte[]> apply(OrcResponse response) throws Exception {
                SettableFuture result = SettableFuture.create();
                result.set((Object)response.getPayload());
                return result;
            }
        });
    }

    static {
        reservedNames.add("abstract");
        reservedNames.add("assert");
        reservedNames.add("boolean");
        reservedNames.add("break");
        reservedNames.add("byte");
        reservedNames.add("case");
        reservedNames.add("catch");
        reservedNames.add("char");
        reservedNames.add("class");
        reservedNames.add("const");
        reservedNames.add("continue");
        reservedNames.add("default");
        reservedNames.add("do");
        reservedNames.add("double");
        reservedNames.add("else");
        reservedNames.add("enum");
        reservedNames.add("extends");
        reservedNames.add("final");
        reservedNames.add("finally");
        reservedNames.add("float");
        reservedNames.add("for");
        reservedNames.add("if");
        reservedNames.add("goto");
        reservedNames.add("implements");
        reservedNames.add("import");
        reservedNames.add("instanceof");
        reservedNames.add("int");
        reservedNames.add("interface");
        reservedNames.add("long");
        reservedNames.add("native");
        reservedNames.add("new");
        reservedNames.add("package");
        reservedNames.add("private");
        reservedNames.add("protected");
        reservedNames.add("public");
        reservedNames.add("return");
        reservedNames.add("short");
        reservedNames.add("static");
        reservedNames.add("strictfp");
        reservedNames.add("super");
        reservedNames.add("switch");
        reservedNames.add("synchronized");
        reservedNames.add("this");
        reservedNames.add("throw");
        reservedNames.add("throws");
        reservedNames.add("transient");
        reservedNames.add("try");
        reservedNames.add("void");
        reservedNames.add("volatile");
        reservedNames.add("while");
    }
}

