/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.microsoft.services.orc.auth.AuthenticationCredentials;
import com.microsoft.services.orc.core.AbstractDependencyResolver;
import com.microsoft.services.orc.http.Credentials;
import com.microsoft.services.orc.http.HttpTransport;
import com.microsoft.services.orc.serialization.JsonSerializer;

public class DependencyResolver
extends AbstractDependencyResolver {
    public DependencyResolver(Builder builder) {
        super(builder);
    }

    public DependencyResolver(HttpTransport transport, JsonSerializer serializer, AuthenticationCredentials auth) {
        this(new Builder(transport, serializer, auth));
    }

    public Credentials getCredentials() {
        return super.getAuth().getCredentials();
    }

    public static class Builder
    extends AbstractDependencyResolver.Builder {
        public Builder(HttpTransport transport, JsonSerializer serializer, AuthenticationCredentials auth) {
            super(transport, serializer, auth);
        }

        @Override
        public Builder setHttpTransport(HttpTransport transport) {
            return (Builder)super.setHttpTransport(transport);
        }

        @Override
        public Builder setJsonSerializer(JsonSerializer jsonSerializer) {
            return (Builder)super.setJsonSerializer(jsonSerializer);
        }

        @Override
        public Builder setAuth(AuthenticationCredentials auth) {
            return (Builder)super.setAuth(auth);
        }

        @Override
        public DependencyResolver build() {
            DependencyResolver resolver = new DependencyResolver(this);
            resolver.getJsonSerializer().setDependencyResolver(resolver);
            return resolver;
        }
    }
}

