/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.http.impl;

import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.http.NetworkRunnable;
import com.microsoft.services.orc.http.Request;
import com.microsoft.services.orc.http.Response;
import com.microsoft.services.orc.http.impl.EmptyResponse;
import com.microsoft.services.orc.http.impl.LoggingInterceptor;
import com.microsoft.services.orc.http.impl.ResponseImpl;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okio.BufferedSink;

public class OkHttpNetworkRunnable
extends NetworkRunnable {
    public OkHttpNetworkRunnable(Request request, SettableFuture<Response> future) {
        super(request, future);
    }

    @Override
    public void run() {
        try {
            OkHttpClient client = new OkHttpClient();
            client.networkInterceptors().add(new LoggingInterceptor());
            StreamedRequest requestBody = null;
            MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
            if (this.mRequest.getStreamedContent() != null) {
                requestBody = new StreamedRequest(mediaType, this.mRequest);
            } else if (this.mRequest.getContent() != null) {
                requestBody = RequestBody.create((MediaType)mediaType, (byte[])this.mRequest.getContent());
            }
            if (requestBody == null && (this.mRequest.getVerb().toString().equals("POST") || this.mRequest.getVerb().toString().equals("PUT"))) {
                requestBody = RequestBody.create(null, (byte[])new byte[0]);
            }
            com.squareup.okhttp.Request request = new Request.Builder().url(this.mRequest.getUrl().toString()).method(this.mRequest.getVerb().toString(), (RequestBody)requestBody).headers(Headers.of(this.mRequest.getHeaders())).build();
            com.squareup.okhttp.Response okResponse = client.newCall(request).execute();
            int status = okResponse.code();
            final ResponseBody responseBody = okResponse.body();
            InputStream stream = null;
            if (responseBody != null) {
                stream = responseBody.byteStream();
            }
            if (stream != null) {
                Closeable closeable = new Closeable(){

                    @Override
                    public void close() throws IOException {
                        responseBody.close();
                    }
                };
                ResponseImpl response = new ResponseImpl(stream, status, okResponse.headers().toMultimap(), closeable);
                this.mFuture.set((Object)response);
            } else {
                responseBody.close();
                this.mFuture.set((Object)new EmptyResponse(status, okResponse.headers().toMultimap()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.mFuture.setException(t);
        }
    }

    private class StreamedRequest
    extends RequestBody {
        private MediaType mediaType;
        private Request request;

        public StreamedRequest(MediaType mediaType, Request request) {
            this.mediaType = mediaType;
            this.request = request;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.buffer().readFrom(this.request.getStreamedContent(), this.request.getStreamedContentSize());
        }
    }
}

