/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.core.DependencyResolver;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.http.HttpVerb;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;

public abstract class OrcFetcher<TEntity>
extends OrcExecutable {
    protected Class<TEntity> clazz;
    protected String urlComponent;
    protected OrcExecutable parent;

    public OrcFetcher(String urlComponent, OrcExecutable parent, Class<TEntity> clazz) {
        this.clazz = clazz;
        this.urlComponent = urlComponent;
        this.parent = parent;
    }

    @Override
    protected DependencyResolver getResolver() {
        return this.parent.getResolver();
    }

    protected ListenableFuture<String> readRaw() {
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture(future);
    }

    protected void addByteArrayResultCallback(final SettableFuture<byte[]> result, ListenableFuture<byte[]> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<byte[]>(){

            public void onSuccess(byte[] payload) {
                try {
                    result.set((Object)payload);
                }
                catch (Throwable e) {
                    result.setException(e);
                }
            }

            public void onFailure(Throwable throwable) {
                result.setException(throwable);
            }
        });
    }

    protected void setSelectorUrl(OrcURL url, String urlComponent, String selectedId) {
        String selector = "('" + selectedId + "')";
        url.prependPathComponent(urlComponent + selector);
    }
}

