/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OrcResponseImpl
implements OrcResponse {
    private Response response;
    private byte[] payload = null;

    public OrcResponseImpl(Response response) {
        this.response = response;
    }

    @Override
    public byte[] getPayload() throws IOException {
        if (this.payload == null) {
            this.payload = OrcResponseImpl.readAllBytes(this.response.getStream());
        }
        return this.payload;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public InputStream openStreamedResponse() {
        return this.response.getStream();
    }

    @Override
    public void closeStreamedResponse() throws IOException {
        this.response.close();
    }

    private static byte[] readAllBytes(InputStream stream) throws IOException {
        int nRead;
        if (stream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            os.write(data, 0, nRead);
        }
        return os.toByteArray();
    }
}

