/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.core.DependencyResolver;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.ODataStream;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.http.HttpVerb;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;
import java.io.InputStream;

public class OrcODataStreamFetcher {
    private String urlComponent;
    private OrcExecutable parent;
    private DependencyResolver dependencyResolver;

    public OrcODataStreamFetcher(String urlComponent, OrcExecutable parent, DependencyResolver dependencyResolver) {
        this.urlComponent = urlComponent;
        this.parent = parent;
        this.dependencyResolver = dependencyResolver;
    }

    public ListenableFuture<InputStream> getStream() {
        Request request = this.dependencyResolver.createRequest();
        request.setVerb(HttpVerb.GET);
        request.addOption("MUST_STREAM_RESPONSE_CONTENT", "true");
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<OrcResponse, InputStream>(){

            public ListenableFuture<InputStream> apply(OrcResponse response) throws Exception {
                SettableFuture result = SettableFuture.create();
                result.set((Object)new ODataStream(response.openStreamedResponse(), response));
                return result;
            }
        });
    }

    public ListenableFuture<Void> putContent(byte[] content) {
        Request request = this.getResolver().createRequest();
        request.setContent(content);
        request.setVerb(HttpVerb.PUT);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToVoidListenableFuture(future);
    }

    public ListenableFuture<Void> putContent(InputStream stream, long streamSize) {
        Request request = this.getResolver().createRequest();
        request.setStreamedContent(stream, streamSize);
        request.setVerb(HttpVerb.PUT);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToVoidListenableFuture(future);
    }

    protected ListenableFuture<OrcResponse> oDataExecute(Request request) {
        OrcURL orcURL = request.getUrl();
        orcURL.prependPathComponent(this.urlComponent);
        return this.parent.oDataExecute(request);
    }

    protected DependencyResolver getResolver() {
        return this.dependencyResolver;
    }
}

