/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.core.DependencyResolver;
import com.microsoft.services.orc.core.OrcException;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.core.OrcResponseImpl;
import com.microsoft.services.orc.http.Credentials;
import com.microsoft.services.orc.http.HttpTransport;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.Request;
import com.microsoft.services.orc.http.Response;
import com.squareup.okhttp.HttpUrl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOrcContainer
extends OrcExecutable {
    Logger logger = LoggerFactory.getLogger(BaseOrcContainer.class);
    private String url;
    private DependencyResolver resolver;

    public BaseOrcContainer(String url, DependencyResolver resolver) {
        this.url = url;
        this.resolver = resolver;
    }

    @Override
    protected ListenableFuture<OrcResponse> oDataExecute(final Request request) {
        final SettableFuture result = SettableFuture.create();
        try {
            if (request.getUrl().getBaseUrl() == null) {
                request.getUrl().setBaseUrl(this.url);
            }
            String rawUrl = request.getUrl().toString();
            String fullUrl = HttpUrl.parse((String)rawUrl).toString();
            String executionInfo = String.format("URL: %s - HTTP VERB: %s", new Object[]{fullUrl, request.getVerb()});
            this.logger.info("Start preparing OData execution for " + executionInfo);
            if (request.getContent() != null) {
                this.logger.info("With " + request.getContent().length + " bytes of payload");
                this.logger.info("Payload: " + new String(request.getContent()));
            } else if (request.getStreamedContent() != null) {
                this.logger.info("With stream of bytes for payload");
            }
            HttpTransport httpTransport = this.resolver.getHttpTransport();
            String userAgent = this.resolver.getPlatformUserAgent(this.getClass().getCanonicalName());
            request.addHeader("User-Agent", userAgent);
            request.addHeader("X-ClientService-ClientTag", userAgent);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/json");
            }
            request.addHeader("Accept", "application/json");
            request.addHeader("OData-Version", "4.0");
            request.addHeader("OData-MaxVersion", "4.0");
            if (request.getHeaders() != null) {
                for (String key : request.getHeaders().keySet()) {
                    request.addHeader(key, request.getHeaders().get(key));
                }
            }
            boolean credentialsSet = false;
            Credentials cred = this.resolver.getCredentials();
            if (cred != null) {
                cred.prepareRequest(request);
                credentialsSet = true;
            }
            if (!credentialsSet) {
                this.logger.info("Executing request without setting credentials");
            }
            this.logger.info("Request Headers: ");
            for (String key : request.getHeaders().keySet()) {
                this.logger.info(key + " : " + request.getHeaders().get(key));
            }
            ListenableFuture<Response> future = httpTransport.execute(request);
            this.logger.info("OData request executed");
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Response>(){

                public void onSuccess(Response response) {
                    boolean readBytes = true;
                    if (request.getOptions().get("MUST_STREAM_RESPONSE_CONTENT") != null) {
                        readBytes = false;
                    }
                    OrcResponseImpl orcResponse = new OrcResponseImpl(response);
                    try {
                        BaseOrcContainer.this.logger.info("OData response received");
                        int status = response.getStatus();
                        BaseOrcContainer.this.logger.info("Response Status Code: " + status);
                        if (readBytes) {
                            BaseOrcContainer.this.logger.info("Reading response data...");
                            byte[] data = orcResponse.getPayload();
                            BaseOrcContainer.this.logger.info(data.length + " bytes read from response");
                            BaseOrcContainer.this.logger.info("Response Payload:" + new String(data));
                            try {
                                BaseOrcContainer.this.logger.info("Closing response");
                                response.close();
                            }
                            catch (Throwable t) {
                                BaseOrcContainer.this.logger.info("Error closing response: " + t.toString());
                                result.setException(t);
                                return;
                            }
                        }
                        if (status < 200 || status > 299) {
                            BaseOrcContainer.this.logger.info("Invalid status code. Processing response content as String");
                            String responseData = new String(orcResponse.getPayload(), "UTF-8");
                            String message = "Response status: " + response.getStatus() + "\n" + "Response content: " + responseData;
                            BaseOrcContainer.this.logger.info(message);
                            result.setException((Throwable)new OrcException((OrcResponse)orcResponse, message));
                            return;
                        }
                        result.set((Object)orcResponse);
                    }
                    catch (Throwable t) {
                        BaseOrcContainer.this.logger.info("Unexpected error: " + t.toString());
                        result.setException((Throwable)new OrcException((OrcResponse)orcResponse, t));
                    }
                }

                public void onFailure(Throwable throwable) {
                    result.setException(throwable);
                }
            });
        }
        catch (Throwable t) {
            result.setException(t);
        }
        return result;
    }

    public static String generateParametersPayload(Map<String, Object> parameters, DependencyResolver resolver) {
        return resolver.getJsonSerializer().serialize(parameters);
    }

    @Override
    protected DependencyResolver getResolver() {
        return this.resolver;
    }
}

