/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import android.os.Build;
import com.microsoft.services.orc.auth.AuthenticationCredentials;
import com.microsoft.services.orc.http.HttpTransport;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;
import com.microsoft.services.orc.http.impl.OrcURLImpl;
import com.microsoft.services.orc.http.impl.RequestImpl;
import com.microsoft.services.orc.serialization.JsonSerializer;

public abstract class AbstractDependencyResolver {
    private Builder builder;

    protected AbstractDependencyResolver(Builder builder) {
        this.builder = builder;
    }

    public HttpTransport getHttpTransport() {
        return this.builder.transport;
    }

    public JsonSerializer getJsonSerializer() {
        return this.builder.jsonSerializer;
    }

    public Request createRequest() {
        return new RequestImpl();
    }

    public OrcURL getOrcURL() {
        return new OrcURLImpl();
    }

    public Request getRequest() {
        return new RequestImpl();
    }

    public AuthenticationCredentials getAuth() {
        return this.builder.auth;
    }

    public String getPlatformUserAgent(String productName) {
        return String.format("%s/1.0 (lang=%s; os=%s; os_version=%s; arch=%s; version=%s)", productName, "Java", "Android", Build.VERSION.RELEASE, Build.CPU_ABI, "1.2.0");
    }

    static abstract class Builder {
        private HttpTransport transport;
        private JsonSerializer jsonSerializer;
        private AuthenticationCredentials auth;

        protected Builder(HttpTransport transport, JsonSerializer serializer, AuthenticationCredentials auth) {
            this.transport = transport;
            this.jsonSerializer = serializer;
            this.auth = auth;
        }

        public abstract AbstractDependencyResolver build();

        public Builder setHttpTransport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }

        public Builder setJsonSerializer(JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
            return this;
        }

        public Builder setAuth(AuthenticationCredentials auth) {
            this.auth = auth;
            return this;
        }
    }
}

