/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.http.impl;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.logging.Logger;

public class LoggingInterceptor
implements Interceptor {
    static Logger logger = Logger.getLogger(LoggingInterceptor.class.getName());

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        logger.info(String.format("Sending request %s %s on %s%n%s", request.method(), request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        logger.info(String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

