/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.http.impl;

import android.net.http.AndroidHttpClient;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.http.NetworkRunnable;
import com.microsoft.services.orc.http.Request;
import com.microsoft.services.orc.http.Response;
import com.microsoft.services.orc.http.impl.EmptyResponse;
import com.microsoft.services.orc.http.impl.ResponseImpl;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

public class AndroidNetworkRunnable
extends NetworkRunnable {
    public AndroidNetworkRunnable(Request request, SettableFuture<Response> future) {
        super(request, future);
    }

    @Override
    public void run() {
        AndroidHttpClient client = null;
        try {
            String userAgent = this.mRequest.getHeaders().get("User-Agent");
            if (userAgent == null) {
                userAgent = "";
            }
            client = AndroidHttpClient.newInstance((String)userAgent);
            BasicHttpEntityEnclosingRequest realRequest = new BasicHttpEntityEnclosingRequest(this.mRequest.getVerb().toString(), this.mRequest.getUrl().toString());
            EntityEnclosingRequestWrapper wrapper = new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)realRequest);
            Map<String, String> headers = this.mRequest.getHeaders();
            for (String key : headers.keySet()) {
                wrapper.addHeader(key, headers.get(key));
            }
            if (this.mRequest.getContent() != null) {
                ByteArrayEntity entity = new ByteArrayEntity(this.mRequest.getContent());
                wrapper.setEntity((HttpEntity)entity);
            } else if (this.mRequest.getStreamedContent() != null) {
                InputStream stream = this.mRequest.getStreamedContent();
                InputStreamEntity entity = new InputStreamEntity(stream, this.mRequest.getStreamedContentSize());
                wrapper.setEntity((HttpEntity)entity);
            }
            HttpResponse realResponse = client.execute((HttpUriRequest)wrapper);
            int status = realResponse.getStatusLine().getStatusCode();
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            for (Header header : realResponse.getAllHeaders()) {
                ArrayList<String> headerValues = new ArrayList<String>();
                for (HeaderElement element : header.getElements()) {
                    headerValues.add(element.getValue());
                }
                responseHeaders.put(header.getName(), headerValues);
            }
            HttpEntity entity = realResponse.getEntity();
            InputStream stream = null;
            if (entity != null) {
                stream = entity.getContent();
            }
            if (stream != null) {
                final AndroidHttpClient finalClient = client;
                Closeable closeable = new Closeable(){

                    @Override
                    public void close() throws IOException {
                        finalClient.close();
                    }
                };
                ResponseImpl response = new ResponseImpl(stream, status, responseHeaders, closeable);
                this.mFuture.set((Object)response);
            } else {
                client.close();
                this.mFuture.set((Object)new EmptyResponse(status, responseHeaders));
            }
        }
        catch (Throwable t) {
            if (client != null) {
                client.close();
            }
            this.mFuture.setException(t);
        }
    }
}

