/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.orc.core.DependencyResolver;
import com.microsoft.services.orc.core.OrcException;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.core.OrcResponseImpl;
import com.microsoft.services.orc.http.Credentials;
import com.microsoft.services.orc.http.HttpTransport;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.Request;
import com.microsoft.services.orc.http.Response;
import com.microsoft.services.orc.log.LogLevel;
import com.microsoft.services.orc.log.LoggerBase;
import java.util.Map;

public abstract class BaseOrcContainer
extends OrcExecutable {
    private String url;
    private DependencyResolver resolver;

    public BaseOrcContainer(String url, DependencyResolver resolver) {
        this.url = url;
        this.resolver = resolver;
    }

    @Override
    protected ListenableFuture<OrcResponse> oDataExecute(final Request request) {
        final SettableFuture result = SettableFuture.create();
        final LoggerBase logger = this.resolver.getLogger();
        try {
            request.getUrl().setBaseUrl(this.url);
            String fullUrl = request.getUrl().toString();
            String executionInfo = String.format("URL: %s - HTTP VERB: %s", new Object[]{fullUrl, request.getVerb()});
            logger.log("Start preparing OData execution for " + executionInfo, LogLevel.INFO);
            if (request.getContent() != null) {
                logger.log("With " + request.getContent().length + " bytes of payload", LogLevel.INFO);
            } else if (request.getStreamedContent() != null) {
                logger.log("With stream of bytes for payload", LogLevel.INFO);
            }
            HttpTransport httpTransport = this.resolver.getHttpTransport();
            String userAgent = this.resolver.getPlatformUserAgent(this.getClass().getCanonicalName());
            request.addHeader("User-Agent", userAgent);
            request.addHeader("X-ClientService-ClientTag", userAgent);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/json");
            }
            request.addHeader("Accept", "application/json");
            request.addHeader("OData-Version", "4.0");
            request.addHeader("OData-MaxVersion", "4.0");
            if (request.getHeaders() != null) {
                for (String key : request.getHeaders().keySet()) {
                    request.addHeader(key, request.getHeaders().get(key));
                }
            }
            boolean credentialsSet = false;
            Credentials cred = this.resolver.getCredentials();
            if (cred != null) {
                cred.prepareRequest(request);
                credentialsSet = true;
            }
            if (!credentialsSet) {
                logger.log("Executing request without setting credentials", LogLevel.WARNING);
            }
            logger.log("Request Headers: ", LogLevel.VERBOSE);
            for (String key : request.getHeaders().keySet()) {
                logger.log(key + " : " + request.getHeaders().get(key), LogLevel.VERBOSE);
            }
            ListenableFuture<Response> future = httpTransport.execute(request);
            logger.log("OData request executed", LogLevel.INFO);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Response>(){

                public void onSuccess(Response response) {
                    boolean readBytes = true;
                    if (request.getOptions().get("MUST_STREAM_RESPONSE_CONTENT") != null) {
                        readBytes = false;
                    }
                    OrcResponseImpl orcResponse = new OrcResponseImpl(response);
                    try {
                        logger.log("OData response received", LogLevel.INFO);
                        int status = response.getStatus();
                        logger.log("Response Status Code: " + status, LogLevel.INFO);
                        if (readBytes) {
                            logger.log("Reading response data...", LogLevel.VERBOSE);
                            byte[] data = orcResponse.getPayload();
                            logger.log(data.length + " bytes read from response", LogLevel.VERBOSE);
                            try {
                                logger.log("Closing response", LogLevel.VERBOSE);
                                response.close();
                            }
                            catch (Throwable t) {
                                logger.log("Error closing response: " + t.toString(), LogLevel.ERROR);
                                result.setException(t);
                                return;
                            }
                        }
                        if (status < 200 || status > 299) {
                            logger.log("Invalid status code. Processing response content as String", LogLevel.VERBOSE);
                            String responseData = new String(orcResponse.getPayload(), "UTF-8");
                            String message = "Response status: " + response.getStatus() + "\n" + "Response content: " + responseData;
                            logger.log(message, LogLevel.ERROR);
                            result.setException((Throwable)new OrcException((OrcResponse)orcResponse, message));
                            return;
                        }
                        result.set((Object)orcResponse);
                    }
                    catch (Throwable t) {
                        logger.log("Unexpected error: " + t.toString(), LogLevel.ERROR);
                        result.setException((Throwable)new OrcException((OrcResponse)orcResponse, t));
                    }
                }

                public void onFailure(Throwable throwable) {
                    result.setException(throwable);
                }
            });
        }
        catch (Throwable t) {
            result.setException(t);
        }
        return result;
    }

    public static String generateParametersPayload(Map<String, Object> parameters, DependencyResolver resolver) {
        return resolver.getJsonSerializer().serialize(parameters);
    }

    @Override
    protected DependencyResolver getResolver() {
        return this.resolver;
    }
}

