/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.serialization.impl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.ODataBaseEntity;
import com.microsoft.services.orc.serialization.ByteArrayTypeAdapterBase;
import com.microsoft.services.orc.serialization.JsonSerializer;
import com.microsoft.services.orc.serialization.impl.CalendarTypeAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GsonSerializerBase
implements JsonSerializer {
    private static Map<String, Class<?>> cachedClassesFromOData = new ConcurrentHashMap();

    private Gson createGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).registerTypeAdapter(Calendar.class, (Object)new CalendarTypeAdapter()).registerTypeAdapter(GregorianCalendar.class, (Object)new CalendarTypeAdapter()).registerTypeAdapter(byte[].class, (Object)this.getByteArrayTypeAdapter()).create();
    }

    protected abstract ByteArrayTypeAdapterBase getByteArrayTypeAdapter();

    @Override
    public String serialize(Object objectToSerialize) {
        Gson serializer = this.createGson();
        JsonElement json = serializer.toJsonTree(objectToSerialize);
        this.sanitizePostSerialization(json);
        return json.toString();
    }

    @Override
    public <E> E deserialize(String payload, Class<E> clazz) {
        Gson serializer = this.createGson();
        JsonParser parser = new JsonParser();
        JsonElement json = parser.parse(payload);
        this.sanitizeForDeserialization(json);
        Package pkg = clazz.getPackage();
        Class overridenClass = this.getClassFromJson(json, pkg);
        if (overridenClass != null) {
            clazz = overridenClass;
        }
        Object odataEntity = serializer.fromJson(json, clazz);
        this.referenceParents(odataEntity, null, null);
        return (E)odataEntity;
    }

    private void referenceParents(Object objToAnalyze, ODataBaseEntity parent, String referenceProperty) {
        block10: {
            Class<?> objClass;
            block9: {
                List list;
                if (objToAnalyze == null) {
                    return;
                }
                objClass = objToAnalyze.getClass();
                if (objToAnalyze instanceof ParentReferencedList) {
                    list = (ParentReferencedList)objToAnalyze;
                    for (Object e : list) {
                        this.referenceParents(e, parent, referenceProperty);
                    }
                }
                if (!(objToAnalyze instanceof List)) break block9;
                list = (List)objToAnalyze;
                for (Object e : list) {
                    this.referenceParents(e, parent, referenceProperty);
                }
                break block10;
            }
            if (!(objToAnalyze instanceof ODataBaseEntity)) break block10;
            ODataBaseEntity entity = (ODataBaseEntity)objToAnalyze;
            if (parent != null) {
                entity.setParent(parent, referenceProperty);
            }
            for (Field field : this.getAllFields(objClass, ODataBaseEntity.class)) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(objToAnalyze);
                    if (fieldValue instanceof List && !(fieldValue instanceof ParentReferencedList)) {
                        List originalList = (List)fieldValue;
                        ParentReferencedList wrapperList = new ParentReferencedList(originalList, entity, field.getName());
                        field.set(entity, wrapperList);
                        this.referenceParents(wrapperList, wrapperList, null);
                        continue;
                    }
                    this.referenceParents(fieldValue, entity, field.getName());
                }
                catch (IllegalAccessException e) {}
            }
        }
    }

    private Iterable<? extends Field> getAllFields(Class clazz, Class topClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != topClass) {
            for (Field f : clazz.getDeclaredFields()) {
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    protected Class getClassFromJson(JsonElement json, Package pkg) {
        try {
            JsonObject jsonObject;
            if (json.isJsonObject() && (jsonObject = json.getAsJsonObject()).has("$$__ODataType")) {
                String dataType = jsonObject.get("$$__ODataType").getAsString();
                if (cachedClassesFromOData.containsKey(dataType)) {
                    return cachedClassesFromOData.get(dataType);
                }
                String[] parts = dataType.split("\\.");
                String className = parts[parts.length - 1];
                String classFullName = pkg.getName() + "." + className;
                Class<?> derivedClass = Class.forName(classFullName);
                ODataBaseEntity instance = (ODataBaseEntity)derivedClass.newInstance();
                Field field = ODataBaseEntity.class.getDeclaredField("$$__ODataType");
                if (field != null) {
                    field.setAccessible(true);
                    String val = (String)field.get(instance);
                    if (val.equals(dataType)) {
                        cachedClassesFromOData.put(dataType, derivedClass);
                        return derivedClass;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <E> List<E> deserializeList(String payload, Class<E> clazz) {
        Gson serializer = this.createGson();
        JsonParser parser = new JsonParser();
        JsonObject json = (JsonObject)parser.parse(payload);
        JsonElement jsonArray = json.get("value");
        this.sanitizeForDeserialization(jsonArray);
        Package pkg = clazz.getPackage();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (JsonElement item : jsonArray.getAsJsonArray()) {
            Class currentClass = clazz;
            Class overridenClass = this.getClassFromJson(item, pkg);
            if (overridenClass != null) {
                currentClass = overridenClass;
            }
            Object deserializedItem = serializer.fromJson(item, currentClass);
            arrayList.add(deserializedItem);
        }
        return arrayList;
    }

    private void sanitizePostSerialization(JsonElement json) {
        block8: {
            block7: {
                if (!json.isJsonArray()) break block7;
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement subElement : jsonArray) {
                    this.sanitizePostSerialization(subElement);
                }
                break block8;
            }
            if (!json.isJsonObject()) break block8;
            JsonObject jsonObject = json.getAsJsonObject();
            HashSet entries = new HashSet(jsonObject.entrySet());
            for (Map.Entry entry : entries) {
                String propertyName = (String)entry.getKey();
                JsonElement subElement = (JsonElement)entry.getValue();
                if (propertyName.startsWith("$$$__$$$")) {
                    jsonObject.remove(propertyName);
                    continue;
                }
                String newName = propertyName;
                if (newName.startsWith("$$__$$")) {
                    newName = newName.substring("$$__$$".length());
                    if (Helpers.getReservedNames().contains(newName)) {
                        jsonObject.remove(newName);
                        jsonObject.add(propertyName, subElement);
                    }
                } else if (propertyName.equals("$$__ODataType")) {
                    jsonObject.remove("$$__ODataType");
                    jsonObject.add("@odata.type", subElement);
                }
                this.sanitizePostSerialization(subElement);
            }
        }
    }

    private void sanitizeForDeserialization(JsonElement json) {
        block6: {
            block5: {
                if (!json.isJsonArray()) break block5;
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement subElement : jsonArray) {
                    this.sanitizeForDeserialization(subElement);
                }
                break block6;
            }
            if (!json.isJsonObject()) break block6;
            JsonObject jsonObject = json.getAsJsonObject();
            HashSet entries = new HashSet(jsonObject.entrySet());
            for (Map.Entry entry : entries) {
                String propertyName = (String)entry.getKey();
                JsonElement subElement = (JsonElement)entry.getValue();
                String newName = "$$__$$" + propertyName;
                if (Helpers.getReservedNames().contains(propertyName)) {
                    jsonObject.remove(propertyName);
                    jsonObject.add(newName, subElement);
                } else {
                    String oDataTypeName = "$$__ODataType";
                    if (propertyName.equals("@odata.type")) {
                        jsonObject.remove(propertyName);
                        jsonObject.add(oDataTypeName, subElement);
                    }
                }
                this.sanitizePostSerialization(subElement);
            }
        }
    }

    @Override
    public String jsonObjectFromJsonMap(Map<String, String> map) {
        JsonObject object = new JsonObject();
        JsonParser parser = new JsonParser();
        for (String key : map.keySet()) {
            String jsonString = map.get(key);
            JsonElement element = parser.parse(jsonString);
            object.add(key, element);
        }
        return object.toString();
    }

    private class ParentReferencedList<E>
    extends ODataBaseEntity
    implements List<E> {
        List<E> wrappedList;
        ODataBaseEntity parent;
        String referenceProperty;

        public ParentReferencedList(List<E> wrappedlist, ODataBaseEntity parent, String referenceProperty) {
            this.wrappedList = wrappedlist;
            this.parent = parent;
            this.referenceProperty = referenceProperty;
        }

        @Override
        public void valueChanged(String property, Object payload) {
            this.valueChanged();
        }

        void valueChanged() {
            this.parent.valueChanged(this.referenceProperty, this);
        }

        @Override
        public int size() {
            return this.wrappedList.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrappedList.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrappedList.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.wrappedList.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.wrappedList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.wrappedList.toArray(a);
        }

        @Override
        public boolean add(E e) {
            boolean ret = this.wrappedList.add(e);
            this.valueChanged();
            return ret;
        }

        @Override
        public boolean remove(Object o) {
            boolean ret = this.wrappedList.remove(o);
            this.valueChanged();
            return ret;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.wrappedList.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean ret = this.wrappedList.addAll(c);
            this.valueChanged();
            return ret;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            boolean ret = this.wrappedList.addAll(c);
            this.valueChanged();
            return ret;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean ret = this.wrappedList.removeAll(c);
            this.valueChanged();
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean ret = this.wrappedList.retainAll(c);
            this.valueChanged();
            return ret;
        }

        @Override
        public void clear() {
            this.wrappedList.clear();
            this.valueChanged();
        }

        @Override
        public E get(int index) {
            return this.wrappedList.get(index);
        }

        @Override
        public E set(int index, E element) {
            E ret = this.wrappedList.set(index, element);
            this.valueChanged();
            return ret;
        }

        @Override
        public void add(int index, E element) {
            this.wrappedList.add(index, element);
            this.valueChanged();
        }

        @Override
        public E remove(int index) {
            E ret = this.wrappedList.remove(index);
            this.valueChanged();
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            return this.wrappedList.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.wrappedList.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.wrappedList.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.wrappedList.listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return this.wrappedList.subList(fromIndex, toIndex);
        }
    }
}

