/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.resolvers;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.msa.LiveAuthClient;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.LiveAuthListener;
import com.microsoft.services.msa.LiveConnectSession;
import com.microsoft.services.msa.LiveStatus;
import com.microsoft.services.orc.http.Credentials;
import com.microsoft.services.orc.http.impl.OAuthCredentials;
import com.microsoft.services.orc.log.LogLevel;
import com.microsoft.services.orc.resolvers.DefaultDependencyResolver;
import java.util.concurrent.ExecutionException;

public class MSAAuthDependencyResolver
extends DefaultDependencyResolver {
    private static final String TAG = "MSAAuthDepResolver";
    private LiveAuthClient liveAuthClient;
    private Context mContext;

    public MSAAuthDependencyResolver(LiveAuthClient theAuthClient) {
        super("");
        this.liveAuthClient = theAuthClient;
    }

    public SettableFuture<Boolean> interactiveInitialize(final Activity contextActivity) throws ExecutionException, InterruptedException {
        final SettableFuture signal = SettableFuture.create();
        this.getLogger().log("Initializing MSAAuthDependencyResolver. If cached refresh token is available it will be used.", LogLevel.INFO);
        contextActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MSAAuthDependencyResolver.this.liveAuthClient.login(contextActivity, new LiveAuthListener(){

                    public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                        if (status == LiveStatus.CONNECTED) {
                            MSAAuthDependencyResolver.this.getLogger().log("Successfully refreshed tokens with refresh token.", LogLevel.INFO);
                            signal.set((Object)true);
                        }
                    }

                    public void onAuthError(LiveAuthException exception, Object userState) {
                        signal.setException((Throwable)exception);
                    }
                });
            }
        });
        return signal;
    }

    @Override
    public Credentials getCredentials() {
        final SettableFuture credentialsFuture = SettableFuture.create();
        this.liveAuthClient.loginSilent(new LiveAuthListener(){

            public void onAuthError(LiveAuthException exception, Object userState) {
                credentialsFuture.setException((Throwable)exception);
            }

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                if (status == LiveStatus.CONNECTED) {
                    OAuthCredentials credentials = new OAuthCredentials(session.getAccessToken());
                    credentialsFuture.set((Object)credentials);
                } else {
                    credentialsFuture.setException((Throwable)new LiveAuthException("Couldn't initialize MSAAuthClient, perform UI Login."));
                }
            }
        });
        try {
            return (Credentials)credentialsFuture.get();
        }
        catch (LiveAuthException e) {
            throw e;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)t.getMessage());
            throw new RuntimeException(t);
        }
    }

    public void logout() {
        final SettableFuture logoutFuture = SettableFuture.create();
        this.liveAuthClient.logout(new LiveAuthListener(){

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                logoutFuture.set((Object)true);
            }

            public void onAuthError(LiveAuthException exception, Object userState) {
                logoutFuture.setException((Throwable)exception);
            }
        });
        try {
            logoutFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

