/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.orc.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.services.orc.core.Constants;
import com.microsoft.services.orc.core.Helpers;
import com.microsoft.services.orc.core.ODataBaseEntity;
import com.microsoft.services.orc.core.OrcExecutable;
import com.microsoft.services.orc.core.OrcFetcher;
import com.microsoft.services.orc.core.OrcOperations;
import com.microsoft.services.orc.core.Readable;
import com.microsoft.services.orc.http.HttpVerb;
import com.microsoft.services.orc.http.OrcResponse;
import com.microsoft.services.orc.http.OrcURL;
import com.microsoft.services.orc.http.Request;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OrcEntityFetcher<TEntity extends ODataBaseEntity, TOperations extends OrcOperations>
extends OrcFetcher<TEntity>
implements Readable<TEntity> {
    private TOperations operations;
    private String select;
    private String expand;

    public OrcEntityFetcher(String urlComponent, OrcExecutable parent, Class<TEntity> clazz, Class<TOperations> operationClazz) {
        super(urlComponent, parent, clazz);
        try {
            this.operations = (OrcOperations)operationClazz.getConstructor(String.class, OrcExecutable.class).newInstance("", this);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
    }

    @Override
    protected ListenableFuture<OrcResponse> oDataExecute(Request request) {
        OrcURL orcURL = request.getUrl();
        if (this.select != null) {
            orcURL.addQueryStringParameter("$select", this.select);
        }
        if (this.expand != null) {
            orcURL.addQueryStringParameter("$expand", this.expand);
        }
        orcURL.prependPathComponent(this.urlComponent);
        Helpers.addCustomParametersToRequest(request, this.getParameters(), this.getHeaders());
        return this.parent.oDataExecute(request);
    }

    public ListenableFuture<TEntity> update(TEntity updatedEntity) {
        return this.update(updatedEntity, true);
    }

    public ListenableFuture<TEntity> update(TEntity updatedEntity, boolean update) {
        ConcurrentHashMap<String, Object> updatedValues = ((ODataBaseEntity)updatedEntity).getUpdatedValues();
        if (!update) {
            updatedValues = updatedEntity;
        }
        ListenableFuture<String> future = this.updateRaw(this.getResolver().getJsonSerializer().serialize(updatedValues), update);
        return Helpers.transformToEntityListenableFuture(future, this.clazz, this.getResolver());
    }

    public ListenableFuture<String> updateRaw(String payload, boolean update) {
        HttpVerb verb = HttpVerb.PUT;
        if (update) {
            verb = HttpVerb.PATCH;
        }
        byte[] payloadBytes = payload.getBytes(Constants.UTF8);
        Request request = this.getResolver().createRequest();
        request.setContent(payloadBytes);
        request.setVerb(verb);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture(future);
    }

    public ListenableFuture delete() {
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.DELETE);
        ListenableFuture<OrcResponse> future = this.oDataExecute(request);
        return Helpers.transformToVoidListenableFuture(future);
    }

    @Override
    public ListenableFuture<TEntity> read() {
        return Helpers.transformToEntityListenableFuture(this.readRaw(), this.clazz, this.getResolver());
    }

    @Override
    public ListenableFuture<String> readRaw() {
        return super.readRaw();
    }

    public OrcEntityFetcher<TEntity, TOperations> select(String select) {
        this.select = select;
        return this;
    }

    public OrcEntityFetcher<TEntity, TOperations> expand(String expand) {
        this.expand = expand;
        return this;
    }

    public TOperations getOperations() {
        return this.operations;
    }
}

