/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.text.TextUtils;
import com.microsoft.services.msa.OAuth;
import com.microsoft.services.msa.OAuthConfig;
import com.microsoft.services.msa.TokenRequest;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicNameValuePair;

class RefreshAccessTokenRequest
extends TokenRequest {
    private final OAuth.GrantType grantType = OAuth.GrantType.REFRESH_TOKEN;
    private final String refreshToken;
    private final String scope;

    public RefreshAccessTokenRequest(HttpClient client, String clientId, String refreshToken, String scope, OAuthConfig oAuthConfig) {
        super(client, clientId, oAuthConfig);
        if (refreshToken == null) {
            throw new AssertionError();
        }
        if (TextUtils.isEmpty((CharSequence)refreshToken)) {
            throw new AssertionError();
        }
        if (scope == null) {
            throw new AssertionError();
        }
        if (TextUtils.isEmpty((CharSequence)scope)) {
            throw new AssertionError();
        }
        this.refreshToken = refreshToken;
        this.scope = scope;
    }

    @Override
    protected void constructBody(List<NameValuePair> body) {
        body.add((NameValuePair)new BasicNameValuePair("refresh_token", this.refreshToken));
        body.add((NameValuePair)new BasicNameValuePair("scope", this.scope));
        body.add((NameValuePair)new BasicNameValuePair("grant_type", this.grantType.toString()));
    }
}

