/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.text.TextUtils;
import com.microsoft.services.msa.OAuth;
import com.microsoft.services.msa.OAuthConfig;
import com.microsoft.services.msa.TokenRequest;
import java.util.List;
import java.util.Locale;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicNameValuePair;

class AccessTokenRequest
extends TokenRequest {
    private final String code;
    private final OAuth.GrantType grantType;

    public AccessTokenRequest(HttpClient client, String clientId, String code, OAuthConfig oAuthConfig) {
        super(client, clientId, oAuthConfig);
        if (TextUtils.isEmpty((CharSequence)code)) {
            throw new AssertionError();
        }
        this.code = code;
        this.grantType = OAuth.GrantType.AUTHORIZATION_CODE;
    }

    @Override
    protected void constructBody(List<NameValuePair> body) {
        body.add((NameValuePair)new BasicNameValuePair("code", this.code));
        body.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.mOAuthConfig.getDesktopUri().toString()));
        body.add((NameValuePair)new BasicNameValuePair("grant_type", this.grantType.toString().toLowerCase(Locale.US)));
    }
}

