/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.odata.ODataEntityFetcher;
import com.microsoft.fileservices.odata.ODataExecutable;
import com.microsoft.fileservices.odata.Readable;
import com.microsoft.services.odata.EntityFetcherHelper;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataURL;

public abstract class ODataMediaEntityFetcher<E, V>
extends ODataEntityFetcher<E, V>
implements Readable<E> {
    public ODataMediaEntityFetcher(String urlComponent, ODataExecutable parent, Class<E> clazz, Class<V> operationClazz) {
        super(urlComponent, parent, clazz, operationClazz);
    }

    public ListenableFuture<byte[]> getContent() {
        ODataURL url = this.getResolver().createODataURL();
        url.appendPathComponent("$value");
        ListenableFuture<byte[]> future = this.oDataExecute(url, null, HttpVerb.GET, this.getCustomHeaders());
        return future;
    }

    public ListenableFuture<Void> putContent(byte[] content) {
        ODataURL url = this.getResolver().createODataURL();
        url.appendPathComponent("$value");
        ListenableFuture<byte[]> future = this.oDataExecute(url, content, HttpVerb.PUT, this.getCustomHeaders());
        SettableFuture result = SettableFuture.create();
        EntityFetcherHelper.addNullResultCallback((SettableFuture)result, future);
        return result;
    }
}

