/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.fileservices.odata.ODataExecutable;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.ODataURL;
import java.util.HashMap;
import java.util.Map;

public abstract class ODataOperations
extends ODataExecutable {
    private String urlComponent;
    private ODataExecutable parent;

    public ODataOperations(String urlComponent, ODataExecutable parent) {
        this.urlComponent = urlComponent;
        this.parent = parent;
    }

    @Override
    ListenableFuture<byte[]> oDataExecute(ODataURL path, byte[] content, HttpVerb verb, Map<String, String> headers) {
        path.prependPathComponent(this.urlComponent);
        Helpers.addCustomParametersToODataURL((ODataURL)path, this.getCustomParameters(), (DependencyResolver)this.getResolver());
        HashMap<String, String> newHeaders = new HashMap<String, String>(this.getCustomHeaders());
        newHeaders.putAll(headers);
        return this.parent.oDataExecute(path, content, verb, newHeaders);
    }

    @Override
    DependencyResolver getResolver() {
        return this.parent.getResolver();
    }
}

