/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.orc;

import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.fileservices.Item;
import com.microsoft.services.orc.Constants;
import com.microsoft.services.orc.Helpers;
import com.microsoft.services.orc.OrcExecutable;
import com.microsoft.services.orc.OrcOperations;
import com.microsoft.services.orc.interfaces.DependencyResolver;
import com.microsoft.services.orc.interfaces.HttpVerb;
import com.microsoft.services.orc.interfaces.JsonSerializer;
import com.microsoft.services.orc.interfaces.Request;
import java.util.HashMap;

public class ItemCollectionOperations
extends OrcOperations {
    public ItemCollectionOperations(String urlComponent, OrcExecutable parent) {
        super(urlComponent, parent);
    }

    public ItemCollectionOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    public ItemCollectionOperations addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ListenableFuture<Item> add(String path, String nameConflict, String type, byte[] content) {
        JsonSerializer serializer = this.getResolver().getJsonSerializer();
        String serializedpath = serializer.serialize((Object)path);
        String serializednameConflict = serializer.serialize((Object)nameConflict);
        String serializedtype = serializer.serialize((Object)type);
        String serializedcontent = serializer.serialize((Object)content);
        ListenableFuture<String> future = this.addRaw(serializedpath, serializednameConflict, serializedtype, serializedcontent);
        return Helpers.transformToEntityListenableFuture(future, Item.class, (DependencyResolver)this.getResolver());
    }

    public ListenableFuture<String> addRaw(String path, String nameConflict, String type, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", path);
        map.put("nameConflict", nameConflict);
        map.put("type", type);
        map.put("content", content);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(this.getResolver().getJsonSerializer().jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
        request.getUrl().appendPathComponent("add");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture((ListenableFuture)future);
    }

    public ListenableFuture<Item> getByPath(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", path);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(Helpers.serializeToJsonByteArray(map, (DependencyResolver)this.getResolver()));
        String parameters = Helpers.getFunctionParameters(map);
        request.getUrl().appendPathComponent("getByPath(" + parameters + ")");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToEntityListenableFuture((ListenableFuture)Helpers.transformToStringListenableFuture((ListenableFuture)future), Item.class, (DependencyResolver)this.getResolver());
    }
}

