/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.orc;

import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.fileservices.Folder;
import com.microsoft.fileservices.orc.ItemOperations;
import com.microsoft.services.orc.Constants;
import com.microsoft.services.orc.Helpers;
import com.microsoft.services.orc.OrcExecutable;
import com.microsoft.services.orc.interfaces.DependencyResolver;
import com.microsoft.services.orc.interfaces.HttpVerb;
import com.microsoft.services.orc.interfaces.JsonSerializer;
import com.microsoft.services.orc.interfaces.Request;
import java.util.HashMap;

public class FolderOperations
extends ItemOperations {
    public FolderOperations(String urlComponent, OrcExecutable parent) {
        super(urlComponent, parent);
    }

    @Override
    public FolderOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    @Override
    public FolderOperations addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ListenableFuture<Folder> copy(String destFolderId, String destFolderPath, String newName) {
        JsonSerializer serializer = this.getResolver().getJsonSerializer();
        String serializeddestFolderId = serializer.serialize((Object)destFolderId);
        String serializeddestFolderPath = serializer.serialize((Object)destFolderPath);
        String serializednewName = serializer.serialize((Object)newName);
        ListenableFuture<String> future = this.copyRaw(serializeddestFolderId, serializeddestFolderPath, serializednewName);
        return Helpers.transformToEntityListenableFuture(future, Folder.class, (DependencyResolver)this.getResolver());
    }

    public ListenableFuture<String> copyRaw(String destFolderId, String destFolderPath, String newName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("destFolderId", destFolderId);
        map.put("destFolderPath", destFolderPath);
        map.put("newName", newName);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(this.getResolver().getJsonSerializer().jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
        request.getUrl().appendPathComponent("Microsoft.FileServices.copy");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture((ListenableFuture)future);
    }
}

