/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.fileservices.File;
import com.microsoft.fileservices.odata.ItemOperations;
import com.microsoft.services.odata.Constants;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.JsonSerializer;
import com.microsoft.services.odata.interfaces.Request;
import java.util.HashMap;

public class FileOperations
extends ItemOperations {
    public FileOperations(String urlComponent, ODataExecutable parent) {
        super(urlComponent, parent);
    }

    @Override
    public FileOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    @Override
    public FileOperations addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ListenableFuture<File> copy(String destFolderId, String destFolderPath, String newName) {
        JsonSerializer serializer = this.getResolver().getJsonSerializer();
        String serializeddestFolderId = serializer.serialize((Object)destFolderId);
        String serializeddestFolderPath = serializer.serialize((Object)destFolderPath);
        String serializednewName = serializer.serialize((Object)newName);
        ListenableFuture<String> future = this.copyRaw(serializeddestFolderId, serializeddestFolderPath, serializednewName);
        return Helpers.transformToEntityListenableFuture(future, File.class, (DependencyResolver)this.getResolver());
    }

    public ListenableFuture<String> copyRaw(String destFolderId, String destFolderPath, String newName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("destFolderId", destFolderId);
        map.put("destFolderPath", destFolderPath);
        map.put("newName", newName);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(this.getResolver().getJsonSerializer().jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
        request.getUrl().appendPathComponent("copy");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture((ListenableFuture)future);
    }
}

