/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.odata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.Folder;
import com.microsoft.fileservices.odata.ItemOperations;
import com.microsoft.services.odata.Helpers;
import com.microsoft.services.odata.ODataExecutable;
import com.microsoft.services.odata.interfaces.DependencyResolver;
import com.microsoft.services.odata.interfaces.HttpVerb;
import com.microsoft.services.odata.interfaces.Request;
import java.util.HashMap;

public class FolderOperations
extends ItemOperations {
    public FolderOperations(String urlComponent, ODataExecutable parent) {
        super(urlComponent, parent);
    }

    @Override
    public FolderOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    @Override
    public FolderOperations addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ListenableFuture<Folder> copy(String destFolderId, String destFolderPath, String newName) {
        SettableFuture result = SettableFuture.create();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("destFolderId", destFolderId);
        map.put("destFolderPath", destFolderPath);
        map.put("newName", newName);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(Helpers.serializeToJsonByteArray(map, (DependencyResolver)this.getResolver()));
        request.getUrl().appendPathComponent("copy");
        ListenableFuture future = this.oDataExecute(request);
        this.addEntityResultCallback(result, future, Folder.class);
        return result;
    }
}

